/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText ChartOfAccountsText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.field.ChartOfAccountsTextField
 * ChartOfAccountsTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.link.ChartOfAccountsTextLink
 * ChartOfAccountsTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText#CHART_OF_ACCOUNTS_NAME
 * CHART_OF_ACCOUNTS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.chartofaccounts.ChartOfAccountsText#TO_CHART_OF_ACCOUNTS
 * TO_CHART_OF_ACCOUNTS}</li>
 * </ul>
 *
 */
public interface ChartOfAccountsTextSelectable extends EntitySelectable<ChartOfAccountsText>
{

}
