/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.field.ClfnClassCharcForKeyDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.link.ClfnClassCharcForKeyDateOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable.ClfnClassCharcForKeyDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Class Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ClfnClassCharcForKeyDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClfnClassCharcForKeyDate extends VdmEntity<ClfnClassCharcForKeyDate>
{

    /**
     * Selector for all available fields of ClfnClassCharcForKeyDate.
     *
     */
    public final static ClfnClassCharcForKeyDateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<Boolean> DELETE_MC =
        new ClfnClassCharcForKeyDateField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<Boolean> UPDATE_MC =
        new ClfnClassCharcForKeyDateField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CLASS_INTERNAL_ID =
        new ClfnClassCharcForKeyDateField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHARC_INTERNAL_ID =
        new ClfnClassCharcForKeyDateField<String>("CharcInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcPositionNumber</b>
     * </p>
     *
     * @return Item number
     */
    @SerializedName( "CharcPositionNumber" )
    @JsonProperty( "CharcPositionNumber" )
    @Nullable
    @ODataField( odataName = "CharcPositionNumber" )
    private String charcPositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>CharcPositionNumber</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHARC_POSITION_NUMBER =
        new ClfnClassCharcForKeyDateField<String>("CharcPositionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHARACTERISTIC =
        new ClfnClassCharcForKeyDateField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AncestorClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @SerializedName( "AncestorClassInternalID" )
    @JsonProperty( "AncestorClassInternalID" )
    @Nullable
    @ODataField( odataName = "AncestorClassInternalID" )
    private String ancestorClassInternalID;
    /**
     * Use with available fluent helpers to apply the <b>AncestorClassInternalID</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> ANCESTOR_CLASS_INTERNAL_ID =
        new ClfnClassCharcForKeyDateField<String>("AncestorClassInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginalCharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @SerializedName( "OriginalCharcInternalID" )
    @JsonProperty( "OriginalCharcInternalID" )
    @Nullable
    @ODataField( odataName = "OriginalCharcInternalID" )
    private String originalCharcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OriginalCharcInternalID</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> ORIGINAL_CHARC_INTERNAL_ID =
        new ClfnClassCharcForKeyDateField<String>("OriginalCharcInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHANGE_NUMBER =
        new ClfnClassCharcForKeyDateField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsPrintRelevant</b>
     * </p>
     *
     * @return The charcIsPrintRelevant contained in this entity.
     */
    @SerializedName( "CharcIsPrintRelevant" )
    @JsonProperty( "CharcIsPrintRelevant" )
    @Nullable
    @ODataField( odataName = "CharcIsPrintRelevant" )
    private String charcIsPrintRelevant;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsPrintRelevant</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHARC_IS_PRINT_RELEVANT =
        new ClfnClassCharcForKeyDateField<String>("CharcIsPrintRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsSearchRelevant</b>
     * </p>
     *
     * @return The charcIsSearchRelevant contained in this entity.
     */
    @SerializedName( "CharcIsSearchRelevant" )
    @JsonProperty( "CharcIsSearchRelevant" )
    @Nullable
    @ODataField( odataName = "CharcIsSearchRelevant" )
    private String charcIsSearchRelevant;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsSearchRelevant</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHARC_IS_SEARCH_RELEVANT =
        new ClfnClassCharcForKeyDateField<String>("CharcIsSearchRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsDisplayRelevant</b>
     * </p>
     *
     * @return The charcIsDisplayRelevant contained in this entity.
     */
    @SerializedName( "CharcIsDisplayRelevant" )
    @JsonProperty( "CharcIsDisplayRelevant" )
    @Nullable
    @ODataField( odataName = "CharcIsDisplayRelevant" )
    private String charcIsDisplayRelevant;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsDisplayRelevant</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<String> CHARC_IS_DISPLAY_RELEVANT =
        new ClfnClassCharcForKeyDateField<String>("CharcIsDisplayRelevant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<LocalDateTime> VALIDITY_START_DATE =
        new ClfnClassCharcForKeyDateField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<LocalDateTime> VALIDITY_END_DATE =
        new ClfnClassCharcForKeyDateField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsProposalRelevant</b>
     * </p>
     *
     * @return Proposal Relevant
     */
    @SerializedName( "CharcIsProposalRelevant" )
    @JsonProperty( "CharcIsProposalRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CharcIsProposalRelevant" )
    private Boolean charcIsProposalRelevant;
    /**
     * Use with available fluent helpers to apply the <b>CharcIsProposalRelevant</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<Boolean> CHARC_IS_PROPOSAL_RELEVANT =
        new ClfnClassCharcForKeyDateField<Boolean>("CharcIsProposalRelevant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date data element for SYST
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<LocalDateTime> KEY_DATE =
        new ClfnClassCharcForKeyDateField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ClassLastChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ClassLastChangedDateTime" )
    @JsonProperty( "ClassLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ClassLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime classLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ClassLastChangedDateTime</b> field to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateField<ZonedDateTime> CLASS_LAST_CHANGED_DATE_TIME =
        new ClfnClassCharcForKeyDateField<ZonedDateTime>("ClassLastChangedDateTime");
    /**
     * Navigation property <b>to_Class</b> for <b>ClfnClassCharcForKeyDate</b> to single <b>ClfnClassForKeyDate</b>.
     *
     */
    @SerializedName( "to_Class" )
    @JsonProperty( "to_Class" )
    @ODataField( odataName = "to_Class" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ClfnClassForKeyDate toClass;
    /**
     * Use with available fluent helpers to apply the <b>to_Class</b> navigation property to query operations.
     *
     */
    public final static ClfnClassCharcForKeyDateOneToOneLink<ClfnClassForKeyDate> TO_CLASS =
        new ClfnClassCharcForKeyDateOneToOneLink<ClfnClassForKeyDate>("to_Class");

    @Nonnull
    @Override
    public Class<ClfnClassCharcForKeyDate> getType()
    {
        return ClfnClassCharcForKeyDate.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcPositionNumber</b>
     * </p>
     *
     * @param charcPositionNumber
     *            Item number
     */
    public void setCharcPositionNumber( @Nullable final String charcPositionNumber )
    {
        rememberChangedField("CharcPositionNumber", this.charcPositionNumber);
        this.charcPositionNumber = charcPositionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AncestorClassInternalID</b>
     * </p>
     *
     * @param ancestorClassInternalID
     *            Internal Class Number
     */
    public void setAncestorClassInternalID( @Nullable final String ancestorClassInternalID )
    {
        rememberChangedField("AncestorClassInternalID", this.ancestorClassInternalID);
        this.ancestorClassInternalID = ancestorClassInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginalCharcInternalID</b>
     * </p>
     *
     * @param originalCharcInternalID
     *            Characteristic Internal ID
     */
    public void setOriginalCharcInternalID( @Nullable final String originalCharcInternalID )
    {
        rememberChangedField("OriginalCharcInternalID", this.originalCharcInternalID);
        this.originalCharcInternalID = originalCharcInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsPrintRelevant</b>
     * </p>
     *
     * @param charcIsPrintRelevant
     *            The charcIsPrintRelevant to set.
     */
    public void setCharcIsPrintRelevant( @Nullable final String charcIsPrintRelevant )
    {
        rememberChangedField("CharcIsPrintRelevant", this.charcIsPrintRelevant);
        this.charcIsPrintRelevant = charcIsPrintRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsSearchRelevant</b>
     * </p>
     *
     * @param charcIsSearchRelevant
     *            The charcIsSearchRelevant to set.
     */
    public void setCharcIsSearchRelevant( @Nullable final String charcIsSearchRelevant )
    {
        rememberChangedField("CharcIsSearchRelevant", this.charcIsSearchRelevant);
        this.charcIsSearchRelevant = charcIsSearchRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsDisplayRelevant</b>
     * </p>
     *
     * @param charcIsDisplayRelevant
     *            The charcIsDisplayRelevant to set.
     */
    public void setCharcIsDisplayRelevant( @Nullable final String charcIsDisplayRelevant )
    {
        rememberChangedField("CharcIsDisplayRelevant", this.charcIsDisplayRelevant);
        this.charcIsDisplayRelevant = charcIsDisplayRelevant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcIsProposalRelevant</b>
     * </p>
     *
     * @param charcIsProposalRelevant
     *            Proposal Relevant
     */
    public void setCharcIsProposalRelevant( @Nullable final Boolean charcIsProposalRelevant )
    {
        rememberChangedField("CharcIsProposalRelevant", this.charcIsProposalRelevant);
        this.charcIsProposalRelevant = charcIsProposalRelevant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date data element for SYST
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ClassLastChangedDateTime</b>
     * </p>
     *
     * @param classLastChangedDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setClassLastChangedDateTime( @Nullable final ZonedDateTime classLastChangedDateTime )
    {
        rememberChangedField("ClassLastChangedDateTime", this.classLastChangedDateTime);
        this.classLastChangedDateTime = classLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ClfnClassCharcForKeyDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ClassInternalID", getClassInternalID());
        result.put("CharcInternalID", getCharcInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ClassInternalID", getClassInternalID());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("CharcPositionNumber", getCharcPositionNumber());
        values.put("Characteristic", getCharacteristic());
        values.put("AncestorClassInternalID", getAncestorClassInternalID());
        values.put("OriginalCharcInternalID", getOriginalCharcInternalID());
        values.put("ChangeNumber", getChangeNumber());
        values.put("CharcIsPrintRelevant", getCharcIsPrintRelevant());
        values.put("CharcIsSearchRelevant", getCharcIsSearchRelevant());
        values.put("CharcIsDisplayRelevant", getCharcIsDisplayRelevant());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("CharcIsProposalRelevant", getCharcIsProposalRelevant());
        values.put("KeyDate", getKeyDate());
        values.put("ClassLastChangedDateTime", getClassLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcPositionNumber") ) {
                final Object value = values.remove("CharcPositionNumber");
                if( (value == null) || (!value.equals(getCharcPositionNumber())) ) {
                    setCharcPositionNumber(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("AncestorClassInternalID") ) {
                final Object value = values.remove("AncestorClassInternalID");
                if( (value == null) || (!value.equals(getAncestorClassInternalID())) ) {
                    setAncestorClassInternalID(((String) value));
                }
            }
            if( values.containsKey("OriginalCharcInternalID") ) {
                final Object value = values.remove("OriginalCharcInternalID");
                if( (value == null) || (!value.equals(getOriginalCharcInternalID())) ) {
                    setOriginalCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("CharcIsPrintRelevant") ) {
                final Object value = values.remove("CharcIsPrintRelevant");
                if( (value == null) || (!value.equals(getCharcIsPrintRelevant())) ) {
                    setCharcIsPrintRelevant(((String) value));
                }
            }
            if( values.containsKey("CharcIsSearchRelevant") ) {
                final Object value = values.remove("CharcIsSearchRelevant");
                if( (value == null) || (!value.equals(getCharcIsSearchRelevant())) ) {
                    setCharcIsSearchRelevant(((String) value));
                }
            }
            if( values.containsKey("CharcIsDisplayRelevant") ) {
                final Object value = values.remove("CharcIsDisplayRelevant");
                if( (value == null) || (!value.equals(getCharcIsDisplayRelevant())) ) {
                    setCharcIsDisplayRelevant(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcIsProposalRelevant") ) {
                final Object value = values.remove("CharcIsProposalRelevant");
                if( (value == null) || (!value.equals(getCharcIsProposalRelevant())) ) {
                    setCharcIsProposalRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassLastChangedDateTime") ) {
                final Object value = values.remove("ClassLastChangedDateTime");
                if( (value == null) || (!value.equals(getClassLastChangedDateTime())) ) {
                    setClassLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Class") ) {
                final Object value = (values).remove("to_Class");
                if( value instanceof Map ) {
                    if( toClass == null ) {
                        toClass = new ClfnClassForKeyDate();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toClass.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ClfnClassCharcForKeyDateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ClfnClassCharcForKeyDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClfnClassCharcForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClfnClassCharcForKeyDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toClass != null ) {
            (values).put("to_Class", toClass);
        }
        return values;
    }

    /**
     * Fetches the <b>ClfnClassForKeyDate</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Class</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ClfnClassForKeyDate</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ClfnClassForKeyDate fetchClassObjects()
    {
        return fetchFieldAsSingle("to_Class", ClfnClassForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassForKeyDate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Class</b>.
     * <p>
     * If the navigation property <b>to_Class</b> of a queried <b>ClfnClassCharcForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassForKeyDate</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ClfnClassForKeyDate getClassObjectsOrFetch()
    {
        if( toClass == null ) {
            toClass = fetchClassObjects();
        }
        return toClass;
    }

    /**
     * Retrieval of associated <b>ClfnClassForKeyDate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Class</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnClassCharcForKeyDate</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Class</b> is already loaded, the result will contain the
     *         <b>ClfnClassForKeyDate</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ClfnClassForKeyDate> getClassObjectsIfPresent()
    {
        return Option.of(toClass);
    }

    /**
     * Overwrites the associated <b>ClfnClassForKeyDate</b> entity for the loaded navigation property <b>to_Class</b>.
     *
     * @param value
     *            New <b>ClfnClassForKeyDate</b> entity.
     */
    public void setClassObjects( final ClfnClassForKeyDate value )
    {
        toClass = value;
    }

    /**
     * Helper class to allow for fluent creation of ClfnClassCharcForKeyDate instances.
     *
     */
    public final static class ClfnClassCharcForKeyDateBuilder
    {

        private ClfnClassForKeyDate toClass;

        private ClfnClassCharcForKeyDate.ClfnClassCharcForKeyDateBuilder toClass( final ClfnClassForKeyDate value )
        {
            toClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_Class</b> for <b>ClfnClassCharcForKeyDate</b> to single <b>ClfnClassForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassForKeyDate to build this ClfnClassCharcForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnClassCharcForKeyDate.ClfnClassCharcForKeyDateBuilder classProperty( final ClfnClassForKeyDate value )
        {
            return toClass(value);
        }

    }

}
