/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
 * ClfnClassCharcForKeyDate} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ClfnClassCharcForKeyDateDeleteFluentHelper
    extends
    FluentHelperDelete<ClfnClassCharcForKeyDateDeleteFluentHelper, ClfnClassCharcForKeyDate>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final ClfnClassCharcForKeyDate entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ClfnClassCharcForKeyDate to delete from the endpoint.
     */
    public ClfnClassCharcForKeyDateDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ClfnClassCharcForKeyDate entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ClfnClassCharcForKeyDate getEntity()
    {
        return entity;
    }

}
