/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.field.ClfnClassForKeyDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.link.ClfnClassForKeyDateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable.ClfnClassForKeyDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Class Header Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ClfnClassForKeyDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClfnClassForKeyDate extends VdmEntity<ClfnClassForKeyDate>
{

    /**
     * Selector for all available fields of ClfnClassForKeyDate.
     *
     */
    public final static ClfnClassForKeyDateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> DELETE_MC =
        new ClfnClassForKeyDateField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> UPDATE_MC =
        new ClfnClassForKeyDateField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassCharacteristic_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ClassCharacteristic_oc" )
    @JsonProperty( "to_ClassCharacteristic_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ClassCharacteristic_oc" )
    private Boolean classCharacteristic_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ClassCharacteristic_oc</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> CLASS_CHARACTERISTIC_OC =
        new ClfnClassForKeyDateField<Boolean>("to_ClassCharacteristic_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassDescription_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ClassDescription_oc" )
    @JsonProperty( "to_ClassDescription_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ClassDescription_oc" )
    private Boolean classDescription_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ClassDescription_oc</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> CLASS_DESCRIPTION_OC =
        new ClfnClassForKeyDateField<Boolean>("to_ClassDescription_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassKeyword_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ClassKeyword_oc" )
    @JsonProperty( "to_ClassKeyword_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ClassKeyword_oc" )
    private Boolean classKeyword_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ClassKeyword_oc</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> CLASS_KEYWORD_OC =
        new ClfnClassForKeyDateField<Boolean>("to_ClassKeyword_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassText_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ClassText_oc" )
    @JsonProperty( "to_ClassText_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ClassText_oc" )
    private Boolean classText_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ClassText_oc</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> CLASS_TEXT_OC =
        new ClfnClassForKeyDateField<Boolean>("to_ClassText_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_INTERNAL_ID =
        new ClfnClassForKeyDateField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_TYPE = new ClfnClassForKeyDateField<String>("ClassType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassTypeName</b>
     * </p>
     *
     * @return Text describing class type
     */
    @SerializedName( "ClassTypeName" )
    @JsonProperty( "ClassTypeName" )
    @Nullable
    @ODataField( odataName = "ClassTypeName" )
    private String classTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ClassTypeName</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_TYPE_NAME =
        new ClfnClassForKeyDateField<String>("ClassTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_PROPERTY = new ClfnClassForKeyDateField<String>("Class");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatus</b>
     * </p>
     *
     * @return Class status
     */
    @SerializedName( "ClassStatus" )
    @JsonProperty( "ClassStatus" )
    @Nullable
    @ODataField( odataName = "ClassStatus" )
    private String classStatus;
    /**
     * Use with available fluent helpers to apply the <b>ClassStatus</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_STATUS =
        new ClfnClassForKeyDateField<String>("ClassStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatusName</b>
     * </p>
     *
     * @return Text for a table entry
     */
    @SerializedName( "ClassStatusName" )
    @JsonProperty( "ClassStatusName" )
    @Nullable
    @ODataField( odataName = "ClassStatusName" )
    private String classStatusName;
    /**
     * Use with available fluent helpers to apply the <b>ClassStatusName</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_STATUS_NAME =
        new ClfnClassForKeyDateField<String>("ClassStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassGroup</b>
     * </p>
     *
     * @return Class Group
     */
    @SerializedName( "ClassGroup" )
    @JsonProperty( "ClassGroup" )
    @Nullable
    @ODataField( odataName = "ClassGroup" )
    private String classGroup;
    /**
     * Use with available fluent helpers to apply the <b>ClassGroup</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_GROUP =
        new ClfnClassForKeyDateField<String>("ClassGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassGroupName</b>
     * </p>
     *
     * @return Class Group Description
     */
    @SerializedName( "ClassGroupName" )
    @JsonProperty( "ClassGroupName" )
    @Nullable
    @ODataField( odataName = "ClassGroupName" )
    private String classGroupName;
    /**
     * Use with available fluent helpers to apply the <b>ClassGroupName</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_GROUP_NAME =
        new ClfnClassForKeyDateField<String>("ClassGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassSearchAuthGrp</b>
     * </p>
     *
     * @return Authorization Group for Finding Objects
     */
    @SerializedName( "ClassSearchAuthGrp" )
    @JsonProperty( "ClassSearchAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassSearchAuthGrp" )
    private String classSearchAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassSearchAuthGrp</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_SEARCH_AUTH_GRP =
        new ClfnClassForKeyDateField<String>("ClassSearchAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @return Classification Authorization Group
     */
    @SerializedName( "ClassClassfctnAuthGrp" )
    @JsonProperty( "ClassClassfctnAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassClassfctnAuthGrp" )
    private String classClassfctnAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassClassfctnAuthGrp</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_CLASSFCTN_AUTH_GRP =
        new ClfnClassForKeyDateField<String>("ClassClassfctnAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @return Class Maintenance Authorization Group
     */
    @SerializedName( "ClassMaintAuthGrp" )
    @JsonProperty( "ClassMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassMaintAuthGrp" )
    private String classMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassMaintAuthGrp</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_MAINT_AUTH_GRP =
        new ClfnClassForKeyDateField<String>("ClassMaintAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @SerializedName( "DocNumber" )
    @JsonProperty( "DocNumber" )
    @Nullable
    @ODataField( odataName = "DocNumber" )
    private String docNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocNumber</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> DOC_NUMBER = new ClfnClassForKeyDateField<String>("DocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentType</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> DOCUMENT_TYPE =
        new ClfnClassForKeyDateField<String>("DocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentPart</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> DOCUMENT_PART =
        new ClfnClassForKeyDateField<String>("DocumentPart");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentVersion</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> DOCUMENT_VERSION =
        new ClfnClassForKeyDateField<String>("DocumentVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SameClassfctnReaction</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "SameClassfctnReaction" )
    @JsonProperty( "SameClassfctnReaction" )
    @Nullable
    @ODataField( odataName = "SameClassfctnReaction" )
    private String sameClassfctnReaction;
    /**
     * Use with available fluent helpers to apply the <b>SameClassfctnReaction</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> SAME_CLASSFCTN_REACTION =
        new ClfnClassForKeyDateField<String>("SameClassfctnReaction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardOrgName</b>
     * </p>
     *
     * @return Name of standards organization
     */
    @SerializedName( "ClassStandardOrgName" )
    @JsonProperty( "ClassStandardOrgName" )
    @Nullable
    @ODataField( odataName = "ClassStandardOrgName" )
    private String classStandardOrgName;
    /**
     * Use with available fluent helpers to apply the <b>ClassStandardOrgName</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_STANDARD_ORG_NAME =
        new ClfnClassForKeyDateField<String>("ClassStandardOrgName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardNumber</b>
     * </p>
     *
     * @return Standard Number
     */
    @SerializedName( "ClassStandardNumber" )
    @JsonProperty( "ClassStandardNumber" )
    @Nullable
    @ODataField( odataName = "ClassStandardNumber" )
    private String classStandardNumber;
    /**
     * Use with available fluent helpers to apply the <b>ClassStandardNumber</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_STANDARD_NUMBER =
        new ClfnClassForKeyDateField<String>("ClassStandardNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardStartDate</b>
     * </p>
     *
     * @return Issue date
     */
    @SerializedName( "ClassStandardStartDate" )
    @JsonProperty( "ClassStandardStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ClassStandardStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime classStandardStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ClassStandardStartDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> CLASS_STANDARD_START_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("ClassStandardStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardVersionStartDate</b>
     * </p>
     *
     * @return Version date
     */
    @SerializedName( "ClassStandardVersionStartDate" )
    @JsonProperty( "ClassStandardVersionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ClassStandardVersionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime classStandardVersionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ClassStandardVersionStartDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> CLASS_STANDARD_VERSION_START_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("ClassStandardVersionStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardVersion</b>
     * </p>
     *
     * @return Version Number
     */
    @SerializedName( "ClassStandardVersion" )
    @JsonProperty( "ClassStandardVersion" )
    @Nullable
    @ODataField( odataName = "ClassStandardVersion" )
    private String classStandardVersion;
    /**
     * Use with available fluent helpers to apply the <b>ClassStandardVersion</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_STANDARD_VERSION =
        new ClfnClassForKeyDateField<String>("ClassStandardVersion");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardCharcTable</b>
     * </p>
     *
     * @return Characteristics table
     */
    @SerializedName( "ClassStandardCharcTable" )
    @JsonProperty( "ClassStandardCharcTable" )
    @Nullable
    @ODataField( odataName = "ClassStandardCharcTable" )
    private String classStandardCharcTable;
    /**
     * Use with available fluent helpers to apply the <b>ClassStandardCharcTable</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<String> CLASS_STANDARD_CHARC_TABLE =
        new ClfnClassForKeyDateField<String>("ClassStandardCharcTable");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> CREATION_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> LAST_CHANGE_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClassIsLocal</b>
     * </p>
     *
     * @return Local class
     */
    @SerializedName( "ClassIsLocal" )
    @JsonProperty( "ClassIsLocal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ClassIsLocal" )
    private Boolean classIsLocal;
    /**
     * Use with available fluent helpers to apply the <b>ClassIsLocal</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<Boolean> CLASS_IS_LOCAL =
        new ClfnClassForKeyDateField<Boolean>("ClassIsLocal");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> VALIDITY_START_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> VALIDITY_END_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ClassLastChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ClassLastChangedDateTime" )
    @JsonProperty( "ClassLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ClassLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime classLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ClassLastChangedDateTime</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<ZonedDateTime> CLASS_LAST_CHANGED_DATE_TIME =
        new ClfnClassForKeyDateField<ZonedDateTime>("ClassLastChangedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date data element for SYST
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static ClfnClassForKeyDateField<LocalDateTime> KEY_DATE =
        new ClfnClassForKeyDateField<LocalDateTime>("KeyDate");
    /**
     * Navigation property <b>to_ClassCharacteristic</b> for <b>ClfnClassForKeyDate</b> to multiple
     * <b>ClfnClassCharcForKeyDate</b>.
     *
     */
    @SerializedName( "to_ClassCharacteristic" )
    @JsonProperty( "to_ClassCharacteristic" )
    @ODataField( odataName = "to_ClassCharacteristic" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnClassCharcForKeyDate> toClassCharacteristic;
    /**
     * Navigation property <b>to_ClassDescription</b> for <b>ClfnClassForKeyDate</b> to multiple
     * <b>ClfnClassDescForKeyDate</b>.
     *
     */
    @SerializedName( "to_ClassDescription" )
    @JsonProperty( "to_ClassDescription" )
    @ODataField( odataName = "to_ClassDescription" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnClassDescForKeyDate> toClassDescription;
    /**
     * Navigation property <b>to_ClassKeyword</b> for <b>ClfnClassForKeyDate</b> to multiple
     * <b>ClfnClassKeywordForKeyDate</b>.
     *
     */
    @SerializedName( "to_ClassKeyword" )
    @JsonProperty( "to_ClassKeyword" )
    @ODataField( odataName = "to_ClassKeyword" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnClassKeywordForKeyDate> toClassKeyword;
    /**
     * Navigation property <b>to_ClassText</b> for <b>ClfnClassForKeyDate</b> to multiple
     * <b>ClfnClassTextForKeyDate</b>.
     *
     */
    @SerializedName( "to_ClassText" )
    @JsonProperty( "to_ClassText" )
    @ODataField( odataName = "to_ClassText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ClfnClassTextForKeyDate> toClassText;
    /**
     * Use with available fluent helpers to apply the <b>to_ClassCharacteristic</b> navigation property to query
     * operations.
     *
     */
    public final static ClfnClassForKeyDateLink<ClfnClassCharcForKeyDate> TO_CLASS_CHARACTERISTIC =
        new ClfnClassForKeyDateLink<ClfnClassCharcForKeyDate>("to_ClassCharacteristic");
    /**
     * Use with available fluent helpers to apply the <b>to_ClassDescription</b> navigation property to query
     * operations.
     *
     */
    public final static ClfnClassForKeyDateLink<ClfnClassDescForKeyDate> TO_CLASS_DESCRIPTION =
        new ClfnClassForKeyDateLink<ClfnClassDescForKeyDate>("to_ClassDescription");
    /**
     * Use with available fluent helpers to apply the <b>to_ClassKeyword</b> navigation property to query operations.
     *
     */
    public final static ClfnClassForKeyDateLink<ClfnClassKeywordForKeyDate> TO_CLASS_KEYWORD =
        new ClfnClassForKeyDateLink<ClfnClassKeywordForKeyDate>("to_ClassKeyword");
    /**
     * Use with available fluent helpers to apply the <b>to_ClassText</b> navigation property to query operations.
     *
     */
    public final static ClfnClassForKeyDateLink<ClfnClassTextForKeyDate> TO_CLASS_TEXT =
        new ClfnClassForKeyDateLink<ClfnClassTextForKeyDate>("to_ClassText");

    @Nonnull
    @Override
    public Class<ClfnClassForKeyDate> getType()
    {
        return ClfnClassForKeyDate.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassCharacteristic_oc</b>
     * </p>
     *
     * @param classCharacteristic_oc
     *            Dynamic CbA-Control
     */
    public void setClassCharacteristic_oc( @Nullable final Boolean classCharacteristic_oc )
    {
        rememberChangedField("to_ClassCharacteristic_oc", this.classCharacteristic_oc);
        this.classCharacteristic_oc = classCharacteristic_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassDescription_oc</b>
     * </p>
     *
     * @param classDescription_oc
     *            Dynamic CbA-Control
     */
    public void setClassDescription_oc( @Nullable final Boolean classDescription_oc )
    {
        rememberChangedField("to_ClassDescription_oc", this.classDescription_oc);
        this.classDescription_oc = classDescription_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassKeyword_oc</b>
     * </p>
     *
     * @param classKeyword_oc
     *            Dynamic CbA-Control
     */
    public void setClassKeyword_oc( @Nullable final Boolean classKeyword_oc )
    {
        rememberChangedField("to_ClassKeyword_oc", this.classKeyword_oc);
        this.classKeyword_oc = classKeyword_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ClassText_oc</b>
     * </p>
     *
     * @param classText_oc
     *            Dynamic CbA-Control
     */
    public void setClassText_oc( @Nullable final Boolean classText_oc )
    {
        rememberChangedField("to_ClassText_oc", this.classText_oc);
        this.classText_oc = classText_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassTypeName</b>
     * </p>
     *
     * @param classTypeName
     *            Text describing class type
     */
    public void setClassTypeName( @Nullable final String classTypeName )
    {
        rememberChangedField("ClassTypeName", this.classTypeName);
        this.classTypeName = classTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatus</b>
     * </p>
     *
     * @param classStatus
     *            Class status
     */
    public void setClassStatus( @Nullable final String classStatus )
    {
        rememberChangedField("ClassStatus", this.classStatus);
        this.classStatus = classStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassStatusName</b>
     * </p>
     *
     * @param classStatusName
     *            Text for a table entry
     */
    public void setClassStatusName( @Nullable final String classStatusName )
    {
        rememberChangedField("ClassStatusName", this.classStatusName);
        this.classStatusName = classStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassGroup</b>
     * </p>
     *
     * @param classGroup
     *            Class Group
     */
    public void setClassGroup( @Nullable final String classGroup )
    {
        rememberChangedField("ClassGroup", this.classGroup);
        this.classGroup = classGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassGroupName</b>
     * </p>
     *
     * @param classGroupName
     *            Class Group Description
     */
    public void setClassGroupName( @Nullable final String classGroupName )
    {
        rememberChangedField("ClassGroupName", this.classGroupName);
        this.classGroupName = classGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassSearchAuthGrp</b>
     * </p>
     *
     * @param classSearchAuthGrp
     *            Authorization Group for Finding Objects
     */
    public void setClassSearchAuthGrp( @Nullable final String classSearchAuthGrp )
    {
        rememberChangedField("ClassSearchAuthGrp", this.classSearchAuthGrp);
        this.classSearchAuthGrp = classSearchAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @param classClassfctnAuthGrp
     *            Classification Authorization Group
     */
    public void setClassClassfctnAuthGrp( @Nullable final String classClassfctnAuthGrp )
    {
        rememberChangedField("ClassClassfctnAuthGrp", this.classClassfctnAuthGrp);
        this.classClassfctnAuthGrp = classClassfctnAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @param classMaintAuthGrp
     *            Class Maintenance Authorization Group
     */
    public void setClassMaintAuthGrp( @Nullable final String classMaintAuthGrp )
    {
        rememberChangedField("ClassMaintAuthGrp", this.classMaintAuthGrp);
        this.classMaintAuthGrp = classMaintAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @param docNumber
     *            Document number
     */
    public void setDocNumber( @Nullable final String docNumber )
    {
        rememberChangedField("DocNumber", this.docNumber);
        this.docNumber = docNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SameClassfctnReaction</b>
     * </p>
     *
     * @param sameClassfctnReaction
     *            Single-Character Flag
     */
    public void setSameClassfctnReaction( @Nullable final String sameClassfctnReaction )
    {
        rememberChangedField("SameClassfctnReaction", this.sameClassfctnReaction);
        this.sameClassfctnReaction = sameClassfctnReaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardOrgName</b>
     * </p>
     *
     * @param classStandardOrgName
     *            Name of standards organization
     */
    public void setClassStandardOrgName( @Nullable final String classStandardOrgName )
    {
        rememberChangedField("ClassStandardOrgName", this.classStandardOrgName);
        this.classStandardOrgName = classStandardOrgName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardNumber</b>
     * </p>
     *
     * @param classStandardNumber
     *            Standard Number
     */
    public void setClassStandardNumber( @Nullable final String classStandardNumber )
    {
        rememberChangedField("ClassStandardNumber", this.classStandardNumber);
        this.classStandardNumber = classStandardNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardStartDate</b>
     * </p>
     *
     * @param classStandardStartDate
     *            Issue date
     */
    public void setClassStandardStartDate( @Nullable final LocalDateTime classStandardStartDate )
    {
        rememberChangedField("ClassStandardStartDate", this.classStandardStartDate);
        this.classStandardStartDate = classStandardStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardVersionStartDate</b>
     * </p>
     *
     * @param classStandardVersionStartDate
     *            Version date
     */
    public void setClassStandardVersionStartDate( @Nullable final LocalDateTime classStandardVersionStartDate )
    {
        rememberChangedField("ClassStandardVersionStartDate", this.classStandardVersionStartDate);
        this.classStandardVersionStartDate = classStandardVersionStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardVersion</b>
     * </p>
     *
     * @param classStandardVersion
     *            Version Number
     */
    public void setClassStandardVersion( @Nullable final String classStandardVersion )
    {
        rememberChangedField("ClassStandardVersion", this.classStandardVersion);
        this.classStandardVersion = classStandardVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ClassStandardCharcTable</b>
     * </p>
     *
     * @param classStandardCharcTable
     *            Characteristics table
     */
    public void setClassStandardCharcTable( @Nullable final String classStandardCharcTable )
    {
        rememberChangedField("ClassStandardCharcTable", this.classStandardCharcTable);
        this.classStandardCharcTable = classStandardCharcTable;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClassIsLocal</b>
     * </p>
     *
     * @param classIsLocal
     *            Local class
     */
    public void setClassIsLocal( @Nullable final Boolean classIsLocal )
    {
        rememberChangedField("ClassIsLocal", this.classIsLocal);
        this.classIsLocal = classIsLocal;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ClassLastChangedDateTime</b>
     * </p>
     *
     * @param classLastChangedDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setClassLastChangedDateTime( @Nullable final ZonedDateTime classLastChangedDateTime )
    {
        rememberChangedField("ClassLastChangedDateTime", this.classLastChangedDateTime);
        this.classLastChangedDateTime = classLastChangedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date data element for SYST
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ClfnClassForKeyDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ClassInternalID", getClassInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_ClassCharacteristic_oc", getClassCharacteristic_oc());
        values.put("to_ClassDescription_oc", getClassDescription_oc());
        values.put("to_ClassKeyword_oc", getClassKeyword_oc());
        values.put("to_ClassText_oc", getClassText_oc());
        values.put("ClassInternalID", getClassInternalID());
        values.put("ClassType", getClassType());
        values.put("ClassTypeName", getClassTypeName());
        values.put("Class", getClassProperty());
        values.put("ClassStatus", getClassStatus());
        values.put("ClassStatusName", getClassStatusName());
        values.put("ClassGroup", getClassGroup());
        values.put("ClassGroupName", getClassGroupName());
        values.put("ClassSearchAuthGrp", getClassSearchAuthGrp());
        values.put("ClassClassfctnAuthGrp", getClassClassfctnAuthGrp());
        values.put("ClassMaintAuthGrp", getClassMaintAuthGrp());
        values.put("DocNumber", getDocNumber());
        values.put("DocumentType", getDocumentType());
        values.put("DocumentPart", getDocumentPart());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("SameClassfctnReaction", getSameClassfctnReaction());
        values.put("ClassStandardOrgName", getClassStandardOrgName());
        values.put("ClassStandardNumber", getClassStandardNumber());
        values.put("ClassStandardStartDate", getClassStandardStartDate());
        values.put("ClassStandardVersionStartDate", getClassStandardVersionStartDate());
        values.put("ClassStandardVersion", getClassStandardVersion());
        values.put("ClassStandardCharcTable", getClassStandardCharcTable());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ClassIsLocal", getClassIsLocal());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ClassLastChangedDateTime", getClassLastChangedDateTime());
        values.put("KeyDate", getKeyDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ClassCharacteristic_oc") ) {
                final Object value = values.remove("to_ClassCharacteristic_oc");
                if( (value == null) || (!value.equals(getClassCharacteristic_oc())) ) {
                    setClassCharacteristic_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ClassDescription_oc") ) {
                final Object value = values.remove("to_ClassDescription_oc");
                if( (value == null) || (!value.equals(getClassDescription_oc())) ) {
                    setClassDescription_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ClassKeyword_oc") ) {
                final Object value = values.remove("to_ClassKeyword_oc");
                if( (value == null) || (!value.equals(getClassKeyword_oc())) ) {
                    setClassKeyword_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ClassText_oc") ) {
                final Object value = values.remove("to_ClassText_oc");
                if( (value == null) || (!value.equals(getClassText_oc())) ) {
                    setClassText_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("ClassTypeName") ) {
                final Object value = values.remove("ClassTypeName");
                if( (value == null) || (!value.equals(getClassTypeName())) ) {
                    setClassTypeName(((String) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
            if( values.containsKey("ClassStatus") ) {
                final Object value = values.remove("ClassStatus");
                if( (value == null) || (!value.equals(getClassStatus())) ) {
                    setClassStatus(((String) value));
                }
            }
            if( values.containsKey("ClassStatusName") ) {
                final Object value = values.remove("ClassStatusName");
                if( (value == null) || (!value.equals(getClassStatusName())) ) {
                    setClassStatusName(((String) value));
                }
            }
            if( values.containsKey("ClassGroup") ) {
                final Object value = values.remove("ClassGroup");
                if( (value == null) || (!value.equals(getClassGroup())) ) {
                    setClassGroup(((String) value));
                }
            }
            if( values.containsKey("ClassGroupName") ) {
                final Object value = values.remove("ClassGroupName");
                if( (value == null) || (!value.equals(getClassGroupName())) ) {
                    setClassGroupName(((String) value));
                }
            }
            if( values.containsKey("ClassSearchAuthGrp") ) {
                final Object value = values.remove("ClassSearchAuthGrp");
                if( (value == null) || (!value.equals(getClassSearchAuthGrp())) ) {
                    setClassSearchAuthGrp(((String) value));
                }
            }
            if( values.containsKey("ClassClassfctnAuthGrp") ) {
                final Object value = values.remove("ClassClassfctnAuthGrp");
                if( (value == null) || (!value.equals(getClassClassfctnAuthGrp())) ) {
                    setClassClassfctnAuthGrp(((String) value));
                }
            }
            if( values.containsKey("ClassMaintAuthGrp") ) {
                final Object value = values.remove("ClassMaintAuthGrp");
                if( (value == null) || (!value.equals(getClassMaintAuthGrp())) ) {
                    setClassMaintAuthGrp(((String) value));
                }
            }
            if( values.containsKey("DocNumber") ) {
                final Object value = values.remove("DocNumber");
                if( (value == null) || (!value.equals(getDocNumber())) ) {
                    setDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("SameClassfctnReaction") ) {
                final Object value = values.remove("SameClassfctnReaction");
                if( (value == null) || (!value.equals(getSameClassfctnReaction())) ) {
                    setSameClassfctnReaction(((String) value));
                }
            }
            if( values.containsKey("ClassStandardOrgName") ) {
                final Object value = values.remove("ClassStandardOrgName");
                if( (value == null) || (!value.equals(getClassStandardOrgName())) ) {
                    setClassStandardOrgName(((String) value));
                }
            }
            if( values.containsKey("ClassStandardNumber") ) {
                final Object value = values.remove("ClassStandardNumber");
                if( (value == null) || (!value.equals(getClassStandardNumber())) ) {
                    setClassStandardNumber(((String) value));
                }
            }
            if( values.containsKey("ClassStandardStartDate") ) {
                final Object value = values.remove("ClassStandardStartDate");
                if( (value == null) || (!value.equals(getClassStandardStartDate())) ) {
                    setClassStandardStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassStandardVersionStartDate") ) {
                final Object value = values.remove("ClassStandardVersionStartDate");
                if( (value == null) || (!value.equals(getClassStandardVersionStartDate())) ) {
                    setClassStandardVersionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassStandardVersion") ) {
                final Object value = values.remove("ClassStandardVersion");
                if( (value == null) || (!value.equals(getClassStandardVersion())) ) {
                    setClassStandardVersion(((String) value));
                }
            }
            if( values.containsKey("ClassStandardCharcTable") ) {
                final Object value = values.remove("ClassStandardCharcTable");
                if( (value == null) || (!value.equals(getClassStandardCharcTable())) ) {
                    setClassStandardCharcTable(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassIsLocal") ) {
                final Object value = values.remove("ClassIsLocal");
                if( (value == null) || (!value.equals(getClassIsLocal())) ) {
                    setClassIsLocal(((Boolean) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassLastChangedDateTime") ) {
                final Object value = values.remove("ClassLastChangedDateTime");
                if( (value == null) || (!value.equals(getClassLastChangedDateTime())) ) {
                    setClassLastChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ClassCharacteristic") ) {
                final Object value = (values).remove("to_ClassCharacteristic");
                if( value instanceof Iterable ) {
                    if( toClassCharacteristic == null ) {
                        toClassCharacteristic = Lists.newArrayList();
                    } else {
                        toClassCharacteristic = Lists.newArrayList(toClassCharacteristic);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnClassCharcForKeyDate entity;
                        if( toClassCharacteristic.size() > i ) {
                            entity = toClassCharacteristic.get(i);
                        } else {
                            entity = new ClfnClassCharcForKeyDate();
                            toClassCharacteristic.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ClassDescription") ) {
                final Object value = (values).remove("to_ClassDescription");
                if( value instanceof Iterable ) {
                    if( toClassDescription == null ) {
                        toClassDescription = Lists.newArrayList();
                    } else {
                        toClassDescription = Lists.newArrayList(toClassDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnClassDescForKeyDate entity;
                        if( toClassDescription.size() > i ) {
                            entity = toClassDescription.get(i);
                        } else {
                            entity = new ClfnClassDescForKeyDate();
                            toClassDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ClassKeyword") ) {
                final Object value = (values).remove("to_ClassKeyword");
                if( value instanceof Iterable ) {
                    if( toClassKeyword == null ) {
                        toClassKeyword = Lists.newArrayList();
                    } else {
                        toClassKeyword = Lists.newArrayList(toClassKeyword);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnClassKeywordForKeyDate entity;
                        if( toClassKeyword.size() > i ) {
                            entity = toClassKeyword.get(i);
                        } else {
                            entity = new ClfnClassKeywordForKeyDate();
                            toClassKeyword.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ClassText") ) {
                final Object value = (values).remove("to_ClassText");
                if( value instanceof Iterable ) {
                    if( toClassText == null ) {
                        toClassText = Lists.newArrayList();
                    } else {
                        toClassText = Lists.newArrayList(toClassText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ClfnClassTextForKeyDate entity;
                        if( toClassText.size() > i ) {
                            entity = toClassText.get(i);
                        } else {
                            entity = new ClfnClassTextForKeyDate();
                            toClassText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ClfnClassForKeyDateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ClfnClassForKeyDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClfnClassForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClfnClassForKeyDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toClassCharacteristic != null ) {
            (values).put("to_ClassCharacteristic", toClassCharacteristic);
        }
        if( toClassDescription != null ) {
            (values).put("to_ClassDescription", toClassDescription);
        }
        if( toClassKeyword != null ) {
            (values).put("to_ClassKeyword", toClassKeyword);
        }
        if( toClassText != null ) {
            (values).put("to_ClassText", toClassText);
        }
        return values;
    }

    /**
     * Fetches the <b>ClfnClassCharcForKeyDate</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ClassCharacteristic</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnClassCharcForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassCharcForKeyDate> fetchClassCharacteristic()
    {
        return fetchFieldAsList("to_ClassCharacteristic", ClfnClassCharcForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassCharcForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassCharacteristic</b>.
     * <p>
     * If the navigation property <b>to_ClassCharacteristic</b> of a queried <b>ClfnClassForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassCharcForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassCharcForKeyDate> getClassCharacteristicOrFetch()
    {
        if( toClassCharacteristic == null ) {
            toClassCharacteristic = fetchClassCharacteristic();
        }
        return toClassCharacteristic;
    }

    /**
     * Retrieval of associated <b>ClfnClassCharcForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassCharacteristic</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnClassForKeyDate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ClassCharacteristic</b> is already loaded, the result
     *         will contain the <b>ClfnClassCharcForKeyDate</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnClassCharcForKeyDate>> getClassCharacteristicIfPresent()
    {
        return Option.of(toClassCharacteristic);
    }

    /**
     * Overwrites the list of associated <b>ClfnClassCharcForKeyDate</b> entities for the loaded navigation property
     * <b>to_ClassCharacteristic</b>.
     * <p>
     * If the navigation property <b>to_ClassCharacteristic</b> of a queried <b>ClfnClassForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnClassCharcForKeyDate</b> entities.
     */
    public void setClassCharacteristic( @Nonnull final List<ClfnClassCharcForKeyDate> value )
    {
        if( toClassCharacteristic == null ) {
            toClassCharacteristic = Lists.newArrayList();
        }
        toClassCharacteristic.clear();
        toClassCharacteristic.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnClassCharcForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_ClassCharacteristic</b>.
     * <p>
     * If the navigation property <b>to_ClassCharacteristic</b> of a queried <b>ClfnClassForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnClassCharcForKeyDate</b> entities.
     */
    public void addClassCharacteristic( ClfnClassCharcForKeyDate... entity )
    {
        if( toClassCharacteristic == null ) {
            toClassCharacteristic = Lists.newArrayList();
        }
        toClassCharacteristic.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnClassDescForKeyDate</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ClassDescription</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnClassDescForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassDescForKeyDate> fetchClassDescription()
    {
        return fetchFieldAsList("to_ClassDescription", ClfnClassDescForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassDescForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassDescription</b>.
     * <p>
     * If the navigation property <b>to_ClassDescription</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassDescForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassDescForKeyDate> getClassDescriptionOrFetch()
    {
        if( toClassDescription == null ) {
            toClassDescription = fetchClassDescription();
        }
        return toClassDescription;
    }

    /**
     * Retrieval of associated <b>ClfnClassDescForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassDescription</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnClassForKeyDate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ClassDescription</b> is already loaded, the result will
     *         contain the <b>ClfnClassDescForKeyDate</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnClassDescForKeyDate>> getClassDescriptionIfPresent()
    {
        return Option.of(toClassDescription);
    }

    /**
     * Overwrites the list of associated <b>ClfnClassDescForKeyDate</b> entities for the loaded navigation property
     * <b>to_ClassDescription</b>.
     * <p>
     * If the navigation property <b>to_ClassDescription</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnClassDescForKeyDate</b> entities.
     */
    public void setClassDescription( @Nonnull final List<ClfnClassDescForKeyDate> value )
    {
        if( toClassDescription == null ) {
            toClassDescription = Lists.newArrayList();
        }
        toClassDescription.clear();
        toClassDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnClassDescForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_ClassDescription</b>.
     * <p>
     * If the navigation property <b>to_ClassDescription</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnClassDescForKeyDate</b> entities.
     */
    public void addClassDescription( ClfnClassDescForKeyDate... entity )
    {
        if( toClassDescription == null ) {
            toClassDescription = Lists.newArrayList();
        }
        toClassDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnClassKeywordForKeyDate</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ClassKeyword</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnClassKeywordForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassKeywordForKeyDate> fetchClassKeyword()
    {
        return fetchFieldAsList("to_ClassKeyword", ClfnClassKeywordForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassKeywordForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassKeyword</b>.
     * <p>
     * If the navigation property <b>to_ClassKeyword</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassKeywordForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassKeywordForKeyDate> getClassKeywordOrFetch()
    {
        if( toClassKeyword == null ) {
            toClassKeyword = fetchClassKeyword();
        }
        return toClassKeyword;
    }

    /**
     * Retrieval of associated <b>ClfnClassKeywordForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassKeyword</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnClassForKeyDate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ClassKeyword</b> is already loaded, the result will
     *         contain the <b>ClfnClassKeywordForKeyDate</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnClassKeywordForKeyDate>> getClassKeywordIfPresent()
    {
        return Option.of(toClassKeyword);
    }

    /**
     * Overwrites the list of associated <b>ClfnClassKeywordForKeyDate</b> entities for the loaded navigation property
     * <b>to_ClassKeyword</b>.
     * <p>
     * If the navigation property <b>to_ClassKeyword</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnClassKeywordForKeyDate</b> entities.
     */
    public void setClassKeyword( @Nonnull final List<ClfnClassKeywordForKeyDate> value )
    {
        if( toClassKeyword == null ) {
            toClassKeyword = Lists.newArrayList();
        }
        toClassKeyword.clear();
        toClassKeyword.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnClassKeywordForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_ClassKeyword</b>.
     * <p>
     * If the navigation property <b>to_ClassKeyword</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnClassKeywordForKeyDate</b> entities.
     */
    public void addClassKeyword( ClfnClassKeywordForKeyDate... entity )
    {
        if( toClassKeyword == null ) {
            toClassKeyword = Lists.newArrayList();
        }
        toClassKeyword.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ClfnClassTextForKeyDate</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ClassText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ClfnClassTextForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassTextForKeyDate> fetchClassText()
    {
        return fetchFieldAsList("to_ClassText", ClfnClassTextForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassTextForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassText</b>.
     * <p>
     * If the navigation property <b>to_ClassText</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassTextForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ClfnClassTextForKeyDate> getClassTextOrFetch()
    {
        if( toClassText == null ) {
            toClassText = fetchClassText();
        }
        return toClassText;
    }

    /**
     * Retrieval of associated <b>ClfnClassTextForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ClassText</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnClassForKeyDate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ClassText</b> is already loaded, the result will contain
     *         the <b>ClfnClassTextForKeyDate</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ClfnClassTextForKeyDate>> getClassTextIfPresent()
    {
        return Option.of(toClassText);
    }

    /**
     * Overwrites the list of associated <b>ClfnClassTextForKeyDate</b> entities for the loaded navigation property
     * <b>to_ClassText</b>.
     * <p>
     * If the navigation property <b>to_ClassText</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ClfnClassTextForKeyDate</b> entities.
     */
    public void setClassText( @Nonnull final List<ClfnClassTextForKeyDate> value )
    {
        if( toClassText == null ) {
            toClassText = Lists.newArrayList();
        }
        toClassText.clear();
        toClassText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ClfnClassTextForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_ClassText</b>.
     * <p>
     * If the navigation property <b>to_ClassText</b> of a queried <b>ClfnClassForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ClfnClassTextForKeyDate</b> entities.
     */
    public void addClassText( ClfnClassTextForKeyDate... entity )
    {
        if( toClassText == null ) {
            toClassText = Lists.newArrayList();
        }
        toClassText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ClfnClassForKeyDate instances.
     *
     */
    public final static class ClfnClassForKeyDateBuilder
    {

        private List<ClfnClassCharcForKeyDate> toClassCharacteristic = Lists.newArrayList();
        private List<ClfnClassDescForKeyDate> toClassDescription = Lists.newArrayList();
        private List<ClfnClassKeywordForKeyDate> toClassKeyword = Lists.newArrayList();
        private List<ClfnClassTextForKeyDate> toClassText = Lists.newArrayList();

        private ClfnClassForKeyDate.ClfnClassForKeyDateBuilder toClassCharacteristic(
            final List<ClfnClassCharcForKeyDate> value )
        {
            toClassCharacteristic.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ClassCharacteristic</b> for <b>ClfnClassForKeyDate</b> to multiple
         * <b>ClfnClassCharcForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassCharcForKeyDates to build this ClfnClassForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnClassForKeyDate.ClfnClassForKeyDateBuilder classCharacteristic( ClfnClassCharcForKeyDate... value )
        {
            return toClassCharacteristic(Lists.newArrayList(value));
        }

        private ClfnClassForKeyDate.ClfnClassForKeyDateBuilder toClassDescription(
            final List<ClfnClassDescForKeyDate> value )
        {
            toClassDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ClassDescription</b> for <b>ClfnClassForKeyDate</b> to multiple
         * <b>ClfnClassDescForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassDescForKeyDates to build this ClfnClassForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnClassForKeyDate.ClfnClassForKeyDateBuilder classDescription( ClfnClassDescForKeyDate... value )
        {
            return toClassDescription(Lists.newArrayList(value));
        }

        private ClfnClassForKeyDate.ClfnClassForKeyDateBuilder toClassKeyword(
            final List<ClfnClassKeywordForKeyDate> value )
        {
            toClassKeyword.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ClassKeyword</b> for <b>ClfnClassForKeyDate</b> to multiple
         * <b>ClfnClassKeywordForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassKeywordForKeyDates to build this ClfnClassForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnClassForKeyDate.ClfnClassForKeyDateBuilder classKeyword( ClfnClassKeywordForKeyDate... value )
        {
            return toClassKeyword(Lists.newArrayList(value));
        }

        private ClfnClassForKeyDate.ClfnClassForKeyDateBuilder toClassText( final List<ClfnClassTextForKeyDate> value )
        {
            toClassText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ClassText</b> for <b>ClfnClassForKeyDate</b> to multiple
         * <b>ClfnClassTextForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassTextForKeyDates to build this ClfnClassForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnClassForKeyDate.ClfnClassForKeyDateBuilder classText( ClfnClassTextForKeyDate... value )
        {
            return toClassText(Lists.newArrayList(value));
        }

    }

}
