/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.field.ClfnClassKeywordForKeyDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.link.ClfnClassKeywordForKeyDateOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable.ClfnClassKeywordForKeyDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Class Keywords
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ClfnClassKeywordForKeyDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ClfnClassKeywordForKeyDate extends VdmEntity<ClfnClassKeywordForKeyDate>
{

    /**
     * Selector for all available fields of ClfnClassKeywordForKeyDate.
     *
     */
    public final static ClfnClassKeywordForKeyDateSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<Boolean> DELETE_MC =
        new ClfnClassKeywordForKeyDateField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<Boolean> UPDATE_MC =
        new ClfnClassKeywordForKeyDateField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<String> CLASS_INTERNAL_ID =
        new ClfnClassKeywordForKeyDateField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<String> LANGUAGE =
        new ClfnClassKeywordForKeyDateField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ClassKeywordPositionNumber</b>
     * </p>
     *
     * @return Item Number
     */
    @Key
    @SerializedName( "ClassKeywordPositionNumber" )
    @JsonProperty( "ClassKeywordPositionNumber" )
    @Nullable
    @ODataField( odataName = "ClassKeywordPositionNumber" )
    private String classKeywordPositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>ClassKeywordPositionNumber</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<String> CLASS_KEYWORD_POSITION_NUMBER =
        new ClfnClassKeywordForKeyDateField<String>("ClassKeywordPositionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassKeywordText</b>
     * </p>
     *
     * @return Keywords
     */
    @SerializedName( "ClassKeywordText" )
    @JsonProperty( "ClassKeywordText" )
    @Nullable
    @ODataField( odataName = "ClassKeywordText" )
    private String classKeywordText;
    /**
     * Use with available fluent helpers to apply the <b>ClassKeywordText</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<String> CLASS_KEYWORD_TEXT =
        new ClfnClassKeywordForKeyDateField<String>("ClassKeywordText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date data element for SYST
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<LocalDateTime> KEY_DATE =
        new ClfnClassKeywordForKeyDateField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ClassLastChangedDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "ClassLastChangedDateTime" )
    @JsonProperty( "ClassLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ClassLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime classLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ClassLastChangedDateTime</b> field to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateField<ZonedDateTime> CLASS_LAST_CHANGED_DATE_TIME =
        new ClfnClassKeywordForKeyDateField<ZonedDateTime>("ClassLastChangedDateTime");
    /**
     * Navigation property <b>to_Class</b> for <b>ClfnClassKeywordForKeyDate</b> to single <b>ClfnClassForKeyDate</b>.
     *
     */
    @SerializedName( "to_Class" )
    @JsonProperty( "to_Class" )
    @ODataField( odataName = "to_Class" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ClfnClassForKeyDate toClass;
    /**
     * Use with available fluent helpers to apply the <b>to_Class</b> navigation property to query operations.
     *
     */
    public final static ClfnClassKeywordForKeyDateOneToOneLink<ClfnClassForKeyDate> TO_CLASS =
        new ClfnClassKeywordForKeyDateOneToOneLink<ClfnClassForKeyDate>("to_Class");

    @Nonnull
    @Override
    public Class<ClfnClassKeywordForKeyDate> getType()
    {
        return ClfnClassKeywordForKeyDate.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ClassKeywordPositionNumber</b>
     * </p>
     *
     * @param classKeywordPositionNumber
     *            Item Number
     */
    public void setClassKeywordPositionNumber( @Nullable final String classKeywordPositionNumber )
    {
        rememberChangedField("ClassKeywordPositionNumber", this.classKeywordPositionNumber);
        this.classKeywordPositionNumber = classKeywordPositionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ClassKeywordText</b>
     * </p>
     *
     * @param classKeywordText
     *            Keywords
     */
    public void setClassKeywordText( @Nullable final String classKeywordText )
    {
        rememberChangedField("ClassKeywordText", this.classKeywordText);
        this.classKeywordText = classKeywordText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date data element for SYST
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ClassLastChangedDateTime</b>
     * </p>
     *
     * @param classLastChangedDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setClassLastChangedDateTime( @Nullable final ZonedDateTime classLastChangedDateTime )
    {
        rememberChangedField("ClassLastChangedDateTime", this.classLastChangedDateTime);
        this.classLastChangedDateTime = classLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ClfnClassKeywordForKeyDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ClassInternalID", getClassInternalID());
        result.put("Language", getLanguage());
        result.put("ClassKeywordPositionNumber", getClassKeywordPositionNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ClassInternalID", getClassInternalID());
        values.put("Language", getLanguage());
        values.put("ClassKeywordPositionNumber", getClassKeywordPositionNumber());
        values.put("ClassKeywordText", getClassKeywordText());
        values.put("KeyDate", getKeyDate());
        values.put("ClassLastChangedDateTime", getClassLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ClassKeywordPositionNumber") ) {
                final Object value = values.remove("ClassKeywordPositionNumber");
                if( (value == null) || (!value.equals(getClassKeywordPositionNumber())) ) {
                    setClassKeywordPositionNumber(((String) value));
                }
            }
            if( values.containsKey("ClassKeywordText") ) {
                final Object value = values.remove("ClassKeywordText");
                if( (value == null) || (!value.equals(getClassKeywordText())) ) {
                    setClassKeywordText(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassLastChangedDateTime") ) {
                final Object value = values.remove("ClassLastChangedDateTime");
                if( (value == null) || (!value.equals(getClassLastChangedDateTime())) ) {
                    setClassLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Class") ) {
                final Object value = (values).remove("to_Class");
                if( value instanceof Map ) {
                    if( toClass == null ) {
                        toClass = new ClfnClassForKeyDate();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toClass.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ClfnClassKeywordForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ClfnClassKeywordForKeyDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ClfnClassKeywordForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ClfnClassKeywordForKeyDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toClass != null ) {
            (values).put("to_Class", toClass);
        }
        return values;
    }

    /**
     * Fetches the <b>ClfnClassForKeyDate</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Class</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ClfnClassForKeyDate</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ClfnClassForKeyDate fetchClassObjects()
    {
        return fetchFieldAsSingle("to_Class", ClfnClassForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>ClfnClassForKeyDate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Class</b>.
     * <p>
     * If the navigation property <b>to_Class</b> of a queried <b>ClfnClassKeywordForKeyDate</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ClfnClassForKeyDate</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ClfnClassForKeyDate getClassObjectsOrFetch()
    {
        if( toClass == null ) {
            toClass = fetchClassObjects();
        }
        return toClass;
    }

    /**
     * Retrieval of associated <b>ClfnClassForKeyDate</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Class</b>.
     * <p>
     * If the navigation property for an entity <b>ClfnClassKeywordForKeyDate</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Class</b> is already loaded, the result will contain the
     *         <b>ClfnClassForKeyDate</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ClfnClassForKeyDate> getClassObjectsIfPresent()
    {
        return Option.of(toClass);
    }

    /**
     * Overwrites the associated <b>ClfnClassForKeyDate</b> entity for the loaded navigation property <b>to_Class</b>.
     *
     * @param value
     *            New <b>ClfnClassForKeyDate</b> entity.
     */
    public void setClassObjects( final ClfnClassForKeyDate value )
    {
        toClass = value;
    }

    /**
     * Helper class to allow for fluent creation of ClfnClassKeywordForKeyDate instances.
     *
     */
    public final static class ClfnClassKeywordForKeyDateBuilder
    {

        private ClfnClassForKeyDate toClass;

        private ClfnClassKeywordForKeyDate.ClfnClassKeywordForKeyDateBuilder toClass( final ClfnClassForKeyDate value )
        {
            toClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_Class</b> for <b>ClfnClassKeywordForKeyDate</b> to single
         * <b>ClfnClassForKeyDate</b>.
         *
         * @param value
         *            The ClfnClassForKeyDate to build this ClfnClassKeywordForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ClfnClassKeywordForKeyDate.ClfnClassKeywordForKeyDateBuilder classProperty(
            final ClfnClassForKeyDate value )
        {
            return toClass(value);
        }

    }

}
