/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable.ClfnClassKeywordForKeyDateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
 * ClfnClassKeywordForKeyDate} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ClfnClassKeywordForKeyDateByKeyFluentHelper
    extends
    FluentHelperByKey<ClfnClassKeywordForKeyDateByKeyFluentHelper, ClfnClassKeywordForKeyDate, ClfnClassKeywordForKeyDateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ClfnClassKeywordForKeyDate}
     * @param classKeywordPositionNumber
     *            Item Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ClfnClassKeywordForKeyDate}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public ClfnClassKeywordForKeyDateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String classInternalID,
        final String language,
        final String classKeywordPositionNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("ClassInternalID", classInternalID);
        this.key.put("Language", language);
        this.key.put("ClassKeywordPositionNumber", classKeywordPositionNumber);
    }

    @Override
    @Nonnull
    protected Class<ClfnClassKeywordForKeyDate> getEntityClass()
    {
        return ClfnClassKeywordForKeyDate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
