/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
 * ClfnClassKeywordForKeyDate} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class ClfnClassKeywordForKeyDateUpdateFluentHelper
    extends
    FluentHelperUpdate<ClfnClassKeywordForKeyDateUpdateFluentHelper, ClfnClassKeywordForKeyDate>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity object that will be updated in the S/4HANA system.
     *
     */
    private final ClfnClassKeywordForKeyDate entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The ClfnClassKeywordForKeyDate to take the updated values from.
     */
    public ClfnClassKeywordForKeyDateUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final ClfnClassKeywordForKeyDate entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected ClfnClassKeywordForKeyDate getEntity()
    {
        return entity;
    }

}
