/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService
 * ClassDataForClassificationService}.
 *
 */
public interface ClassDataForClassificationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ClassDataForClassificationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ClassDataForClassificationServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassCharcForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *            ClfnClassCharcForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        createClfnClassCharcForKeyDate( @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassCharcForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *            ClfnClassCharcForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        updateClfnClassCharcForKeyDate( @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     * ClfnClassCharcForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassCharcForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
     *            ClfnClassCharcForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        deleteClfnClassCharcForKeyDate( @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     * ClfnClassDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *            ClfnClassDescForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        createClfnClassDescForKeyDate( @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     * ClfnClassDescForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassDescForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
     *            ClfnClassDescForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        updateClfnClassDescForKeyDate( @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *            ClfnClassForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        createClfnClassForKeyDate( @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *            ClfnClassForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        updateClfnClassForKeyDate( @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     * ClfnClassForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate
     *            ClfnClassForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        deleteClfnClassForKeyDate( @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassKeywordForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *            ClfnClassKeywordForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        createClfnClassKeywordForKeyDate( @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassKeywordForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *            ClfnClassKeywordForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        updateClfnClassKeywordForKeyDate( @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     * ClfnClassKeywordForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassKeywordForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate
     *            ClfnClassKeywordForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        deleteClfnClassKeywordForKeyDate( @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassTextForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *            ClfnClassTextForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        createClfnClassTextForKeyDate( @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param clfnClassTextForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *            ClfnClassTextForKeyDate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        updateClfnClassTextForKeyDate( @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     * ClfnClassTextForKeyDate} entity in the S/4HANA system.
     *
     * @param clfnClassTextForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
     *            ClfnClassTextForKeyDate} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ClassDataForClassificationServiceBatchChangeSet
        deleteClfnClassTextForKeyDate( @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate );

}
