/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ClassDataForClassificationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService
 * ClassDataForClassificationService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultClassDataForClassificationServiceBatch
    extends
    BatchFluentHelperBasic<ClassDataForClassificationServiceBatch, ClassDataForClassificationServiceBatchChangeSet>
    implements
    ClassDataForClassificationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultClassDataForClassificationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultClassDataForClassificationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultClassDataForClassificationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultClassDataForClassificationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultClassDataForClassificationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultClassDataForClassificationServiceBatchChangeSet(this, service);
    }

}
