/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassKeywordForKeyDate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate;

/**
 * Implementation of the {@link ClassDataForClassificationServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService
 * ClassDataForClassificationService}.
 *
 */
public class DefaultClassDataForClassificationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ClassDataForClassificationServiceBatch, ClassDataForClassificationServiceBatchChangeSet>
    implements
    ClassDataForClassificationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService service;

    @SuppressWarnings( "deprecation" )
    DefaultClassDataForClassificationServiceBatchChangeSet(
        @Nonnull final DefaultClassDataForClassificationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ClassDataForClassificationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultClassDataForClassificationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet createClfnClassCharcForKeyDate(
        @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate )
    {
        return addRequestCreate(service::createClfnClassCharcForKeyDate, clfnClassCharcForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet updateClfnClassCharcForKeyDate(
        @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate )
    {
        return addRequestUpdate(service::updateClfnClassCharcForKeyDate, clfnClassCharcForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet deleteClfnClassCharcForKeyDate(
        @Nonnull final ClfnClassCharcForKeyDate clfnClassCharcForKeyDate )
    {
        return addRequestDelete(service::deleteClfnClassCharcForKeyDate, clfnClassCharcForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet createClfnClassDescForKeyDate(
        @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate )
    {
        return addRequestCreate(service::createClfnClassDescForKeyDate, clfnClassDescForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet updateClfnClassDescForKeyDate(
        @Nonnull final ClfnClassDescForKeyDate clfnClassDescForKeyDate )
    {
        return addRequestUpdate(service::updateClfnClassDescForKeyDate, clfnClassDescForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet createClfnClassForKeyDate(
        @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate )
    {
        return addRequestCreate(service::createClfnClassForKeyDate, clfnClassForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet updateClfnClassForKeyDate(
        @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate )
    {
        return addRequestUpdate(service::updateClfnClassForKeyDate, clfnClassForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet deleteClfnClassForKeyDate(
        @Nonnull final ClfnClassForKeyDate clfnClassForKeyDate )
    {
        return addRequestDelete(service::deleteClfnClassForKeyDate, clfnClassForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet createClfnClassKeywordForKeyDate(
        @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate )
    {
        return addRequestCreate(service::createClfnClassKeywordForKeyDate, clfnClassKeywordForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet updateClfnClassKeywordForKeyDate(
        @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate )
    {
        return addRequestUpdate(service::updateClfnClassKeywordForKeyDate, clfnClassKeywordForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet deleteClfnClassKeywordForKeyDate(
        @Nonnull final ClfnClassKeywordForKeyDate clfnClassKeywordForKeyDate )
    {
        return addRequestDelete(service::deleteClfnClassKeywordForKeyDate, clfnClassKeywordForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet createClfnClassTextForKeyDate(
        @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate )
    {
        return addRequestCreate(service::createClfnClassTextForKeyDate, clfnClassTextForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet updateClfnClassTextForKeyDate(
        @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate )
    {
        return addRequestUpdate(service::updateClfnClassTextForKeyDate, clfnClassTextForKeyDate);
    }

    @Nonnull
    @Override
    public ClassDataForClassificationServiceBatchChangeSet deleteClfnClassTextForKeyDate(
        @Nonnull final ClfnClassTextForKeyDate clfnClassTextForKeyDate )
    {
        return addRequestDelete(service::deleteClfnClassTextForKeyDate, clfnClassTextForKeyDate);
    }

}
