/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate
 * ClfnClassCharcForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.field.ClfnClassCharcForKeyDateField
 * ClfnClassCharcForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.link.ClfnClassCharcForKeyDateLink
 * ClfnClassCharcForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARC_POSITION_NUMBER
 * CHARC_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARACTERISTIC
 * CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#ANCESTOR_CLASS_INTERNAL_ID
 * ANCESTOR_CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#ORIGINAL_CHARC_INTERNAL_ID
 * ORIGINAL_CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARC_IS_PRINT_RELEVANT
 * CHARC_IS_PRINT_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARC_IS_SEARCH_RELEVANT
 * CHARC_IS_SEARCH_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARC_IS_DISPLAY_RELEVANT
 * CHARC_IS_DISPLAY_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CHARC_IS_PROPOSAL_RELEVANT
 * CHARC_IS_PROPOSAL_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#CLASS_LAST_CHANGED_DATE_TIME
 * CLASS_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassCharcForKeyDate#TO_CLASS
 * TO_CLASS}</li>
 * </ul>
 *
 */
public interface ClfnClassCharcForKeyDateSelectable extends EntitySelectable<ClfnClassCharcForKeyDate>
{

}
