/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate
 * ClfnClassDescForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.field.ClfnClassDescForKeyDateField
 * ClfnClassDescForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.link.ClfnClassDescForKeyDateLink
 * ClfnClassDescForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#CLASS_DESCRIPTION
 * CLASS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#CLASS_LAST_CHANGED_DATE_TIME
 * CLASS_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassDescForKeyDate#TO_CLASS
 * TO_CLASS}</li>
 * </ul>
 *
 */
public interface ClfnClassDescForKeyDateSelectable extends EntitySelectable<ClfnClassDescForKeyDate>
{

}
