/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate
 * ClfnClassTextForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.field.ClfnClassTextForKeyDateField
 * ClfnClassTextForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.link.ClfnClassTextForKeyDateLink
 * ClfnClassTextForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#CLASS_TEXT
 * CLASS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#CLASS_LAST_CHANGED_DATE_TIME
 * CLASS_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.classdataforclassification.ClfnClassTextForKeyDate#TO_CLASS
 * TO_CLASS}</li>
 * </ul>
 *
 */
public interface ClfnClassTextForKeyDateSelectable extends EntitySelectable<ClfnClassTextForKeyDate>
{

}
