/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.CustProjSlsOrdField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.CustProjSlsOrdLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.CustProjSlsOrdSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustProjSlsOrdType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustProjSlsOrd extends VdmEntity<CustProjSlsOrd>
{

    /**
     * Selector for all available fields of CustProjSlsOrd.
     *
     */
    public final static CustProjSlsOrdSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @return Commercial Project ID
     */
    @Key
    @SerializedName( "CustomerProject" )
    @JsonProperty( "CustomerProject" )
    @Nullable
    @ODataField( odataName = "CustomerProject" )
    private String customerProject;
    /**
     * Use with available fluent helpers to apply the <b>CustomerProject</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> CUSTOMER_PROJECT =
        new CustProjSlsOrdField<String>("CustomerProject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> SALES_ORDER = new CustProjSlsOrdField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> SOLD_TO_PARTY = new CustProjSlsOrdField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value of the Sales Order in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<BigDecimal> TOTAL_NET_AMOUNT =
        new CustProjSlsOrdField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> TRANSACTION_CURRENCY =
        new CustProjSlsOrdField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new CustProjSlsOrdField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Customer Reference Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new CustProjSlsOrdField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> SALES_OFFICE = new CustProjSlsOrdField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> SALES_GROUP = new CustProjSlsOrdField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> CUSTOMER_PAYMENT_TERMS =
        new CustProjSlsOrdField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> PAYMENT_METHOD = new CustProjSlsOrdField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Customer
     */
    @SerializedName( "CustomerAccountAssignmentGroup" )
    @JsonProperty( "CustomerAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "CustomerAccountAssignmentGroup" )
    private String customerAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> CUSTOMER_ACCOUNT_ASSIGNMENT_GROUP =
        new CustProjSlsOrdField<String>("CustomerAccountAssignmentGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block in SD Document
     */
    @SerializedName( "HeaderBillingBlockReason" )
    @JsonProperty( "HeaderBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "HeaderBillingBlockReason" )
    private String headerBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>HeaderBillingBlockReason</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> HEADER_BILLING_BLOCK_REASON =
        new CustProjSlsOrdField<String>("HeaderBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> SALES_ORGANIZATION =
        new CustProjSlsOrdField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> DISTRIBUTION_CHANNEL =
        new CustProjSlsOrdField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdField<String> ORGANIZATION_DIVISION =
        new CustProjSlsOrdField<String>("OrganizationDivision");
    /**
     * Navigation property <b>to_CustProjSlsOrdItem</b> for <b>CustProjSlsOrd</b> to multiple <b>CustProjSlsOrdItem</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdItem" )
    @JsonProperty( "to_CustProjSlsOrdItem" )
    @ODataField( odataName = "to_CustProjSlsOrdItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdItem> toCustProjSlsOrdItem;
    /**
     * Navigation property <b>to_CustProjSlsOrdPartner</b> for <b>CustProjSlsOrd</b> to multiple
     * <b>CustProjSlsOrdPartner</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdPartner" )
    @JsonProperty( "to_CustProjSlsOrdPartner" )
    @ODataField( odataName = "to_CustProjSlsOrdPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdPartner> toCustProjSlsOrdPartner;
    /**
     * Navigation property <b>to_CustProjSlsOrdText</b> for <b>CustProjSlsOrd</b> to multiple <b>CustProjSlsOrdText</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdText" )
    @JsonProperty( "to_CustProjSlsOrdText" )
    @ODataField( odataName = "to_CustProjSlsOrdText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdText> toCustProjSlsOrdText;
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdItem</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdLink<CustProjSlsOrdItem> TO_CUST_PROJ_SLS_ORD_ITEM =
        new CustProjSlsOrdLink<CustProjSlsOrdItem>("to_CustProjSlsOrdItem");
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdPartner</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdLink<CustProjSlsOrdPartner> TO_CUST_PROJ_SLS_ORD_PARTNER =
        new CustProjSlsOrdLink<CustProjSlsOrdPartner>("to_CustProjSlsOrdPartner");
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdText</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdLink<CustProjSlsOrdText> TO_CUST_PROJ_SLS_ORD_TEXT =
        new CustProjSlsOrdLink<CustProjSlsOrdText>("to_CustProjSlsOrdText");

    @Nonnull
    @Override
    public Class<CustProjSlsOrd> getType()
    {
        return CustProjSlsOrd.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @param customerProject
     *            Commercial Project ID
     */
    public void setCustomerProject( @Nullable final String customerProject )
    {
        rememberChangedField("CustomerProject", this.customerProject);
        this.customerProject = customerProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value of the Sales Order in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Customer Reference Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountAssignmentGroup</b>
     * </p>
     *
     * @param customerAccountAssignmentGroup
     *            Account Assignment Group for Customer
     */
    public void setCustomerAccountAssignmentGroup( @Nullable final String customerAccountAssignmentGroup )
    {
        rememberChangedField("CustomerAccountAssignmentGroup", this.customerAccountAssignmentGroup);
        this.customerAccountAssignmentGroup = customerAccountAssignmentGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @param headerBillingBlockReason
     *            Billing Block in SD Document
     */
    public void setHeaderBillingBlockReason( @Nullable final String headerBillingBlockReason )
    {
        rememberChangedField("HeaderBillingBlockReason", this.headerBillingBlockReason);
        this.headerBillingBlockReason = headerBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustProjSlsOrd";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerProject", getCustomerProject());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerProject", getCustomerProject());
        values.put("SalesOrder", getSalesOrder());
        values.put("SoldToParty", getSoldToParty());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("CustomerAccountAssignmentGroup", getCustomerAccountAssignmentGroup());
        values.put("HeaderBillingBlockReason", getHeaderBillingBlockReason());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerProject") ) {
                final Object value = values.remove("CustomerProject");
                if( (value == null) || (!value.equals(getCustomerProject())) ) {
                    setCustomerProject(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("CustomerAccountAssignmentGroup") ) {
                final Object value = values.remove("CustomerAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getCustomerAccountAssignmentGroup())) ) {
                    setCustomerAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("HeaderBillingBlockReason") ) {
                final Object value = values.remove("HeaderBillingBlockReason");
                if( (value == null) || (!value.equals(getHeaderBillingBlockReason())) ) {
                    setHeaderBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustProjSlsOrdItem") ) {
                final Object value = (values).remove("to_CustProjSlsOrdItem");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdItem == null ) {
                        toCustProjSlsOrdItem = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdItem = Lists.newArrayList(toCustProjSlsOrdItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdItem entity;
                        if( toCustProjSlsOrdItem.size() > i ) {
                            entity = toCustProjSlsOrdItem.get(i);
                        } else {
                            entity = new CustProjSlsOrdItem();
                            toCustProjSlsOrdItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CustProjSlsOrdPartner") ) {
                final Object value = (values).remove("to_CustProjSlsOrdPartner");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdPartner == null ) {
                        toCustProjSlsOrdPartner = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdPartner = Lists.newArrayList(toCustProjSlsOrdPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdPartner entity;
                        if( toCustProjSlsOrdPartner.size() > i ) {
                            entity = toCustProjSlsOrdPartner.get(i);
                        } else {
                            entity = new CustProjSlsOrdPartner();
                            toCustProjSlsOrdPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CustProjSlsOrdText") ) {
                final Object value = (values).remove("to_CustProjSlsOrdText");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdText == null ) {
                        toCustProjSlsOrdText = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdText = Lists.newArrayList(toCustProjSlsOrdText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdText entity;
                        if( toCustProjSlsOrdText.size() > i ) {
                            entity = toCustProjSlsOrdText.get(i);
                        } else {
                            entity = new CustProjSlsOrdText();
                            toCustProjSlsOrdText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustProjSlsOrdField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustProjSlsOrdField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustProjSlsOrdField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustProjSlsOrdField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustProjSlsOrdItem != null ) {
            (values).put("to_CustProjSlsOrdItem", toCustProjSlsOrdItem);
        }
        if( toCustProjSlsOrdPartner != null ) {
            (values).put("to_CustProjSlsOrdPartner", toCustProjSlsOrdPartner);
        }
        if( toCustProjSlsOrdText != null ) {
            (values).put("to_CustProjSlsOrdText", toCustProjSlsOrdText);
        }
        return values;
    }

    /**
     * Fetches the <b>CustProjSlsOrdItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CustProjSlsOrdItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItem> fetchCustProjSlsOrdItem()
    {
        return fetchFieldAsList("to_CustProjSlsOrdItem", CustProjSlsOrdItem.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItem</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItem</b> of a queried <b>CustProjSlsOrd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItem> getCustProjSlsOrdItemOrFetch()
    {
        if( toCustProjSlsOrdItem == null ) {
            toCustProjSlsOrdItem = fetchCustProjSlsOrdItem();
        }
        return toCustProjSlsOrdItem;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItem</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrd</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdItem</b> is already loaded, the result
     *         will contain the <b>CustProjSlsOrdItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdItem>> getCustProjSlsOrdItemIfPresent()
    {
        return Option.of(toCustProjSlsOrdItem);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdItem</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdItem</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItem</b> of a queried <b>CustProjSlsOrd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdItem</b> entities.
     */
    public void setCustProjSlsOrdItem( @Nonnull final List<CustProjSlsOrdItem> value )
    {
        if( toCustProjSlsOrdItem == null ) {
            toCustProjSlsOrdItem = Lists.newArrayList();
        }
        toCustProjSlsOrdItem.clear();
        toCustProjSlsOrdItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdItem</b> entities. This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItem</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItem</b> of a queried <b>CustProjSlsOrd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdItem</b> entities.
     */
    public void addCustProjSlsOrdItem( CustProjSlsOrdItem... entity )
    {
        if( toCustProjSlsOrdItem == null ) {
            toCustProjSlsOrdItem = Lists.newArrayList();
        }
        toCustProjSlsOrdItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustProjSlsOrdPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CustProjSlsOrdPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdPartner> fetchCustProjSlsOrdPartner()
    {
        return fetchFieldAsList("to_CustProjSlsOrdPartner", CustProjSlsOrdPartner.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdPartner</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdPartner</b> of a queried <b>CustProjSlsOrd</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdPartner> getCustProjSlsOrdPartnerOrFetch()
    {
        if( toCustProjSlsOrdPartner == null ) {
            toCustProjSlsOrdPartner = fetchCustProjSlsOrdPartner();
        }
        return toCustProjSlsOrdPartner;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdPartner</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrd</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdPartner</b> is already loaded, the result
     *         will contain the <b>CustProjSlsOrdPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdPartner>> getCustProjSlsOrdPartnerIfPresent()
    {
        return Option.of(toCustProjSlsOrdPartner);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdPartner</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdPartner</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdPartner</b> of a queried <b>CustProjSlsOrd</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdPartner</b> entities.
     */
    public void setCustProjSlsOrdPartner( @Nonnull final List<CustProjSlsOrdPartner> value )
    {
        if( toCustProjSlsOrdPartner == null ) {
            toCustProjSlsOrdPartner = Lists.newArrayList();
        }
        toCustProjSlsOrdPartner.clear();
        toCustProjSlsOrdPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdPartner</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdPartner</b> of a queried <b>CustProjSlsOrd</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdPartner</b> entities.
     */
    public void addCustProjSlsOrdPartner( CustProjSlsOrdPartner... entity )
    {
        if( toCustProjSlsOrdPartner == null ) {
            toCustProjSlsOrdPartner = Lists.newArrayList();
        }
        toCustProjSlsOrdPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustProjSlsOrdText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CustProjSlsOrdText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdText> fetchCustProjSlsOrdText()
    {
        return fetchFieldAsList("to_CustProjSlsOrdText", CustProjSlsOrdText.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdText</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdText</b> of a queried <b>CustProjSlsOrd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdText> getCustProjSlsOrdTextOrFetch()
    {
        if( toCustProjSlsOrdText == null ) {
            toCustProjSlsOrdText = fetchCustProjSlsOrdText();
        }
        return toCustProjSlsOrdText;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdText</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrd</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdText</b> is already loaded, the result
     *         will contain the <b>CustProjSlsOrdText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdText>> getCustProjSlsOrdTextIfPresent()
    {
        return Option.of(toCustProjSlsOrdText);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdText</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdText</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdText</b> of a queried <b>CustProjSlsOrd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdText</b> entities.
     */
    public void setCustProjSlsOrdText( @Nonnull final List<CustProjSlsOrdText> value )
    {
        if( toCustProjSlsOrdText == null ) {
            toCustProjSlsOrdText = Lists.newArrayList();
        }
        toCustProjSlsOrdText.clear();
        toCustProjSlsOrdText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdText</b> entities. This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdText</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdText</b> of a queried <b>CustProjSlsOrd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdText</b> entities.
     */
    public void addCustProjSlsOrdText( CustProjSlsOrdText... entity )
    {
        if( toCustProjSlsOrdText == null ) {
            toCustProjSlsOrdText = Lists.newArrayList();
        }
        toCustProjSlsOrdText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustProjSlsOrd instances.
     *
     */
    public final static class CustProjSlsOrdBuilder
    {

        private List<CustProjSlsOrdItem> toCustProjSlsOrdItem = Lists.newArrayList();
        private List<CustProjSlsOrdPartner> toCustProjSlsOrdPartner = Lists.newArrayList();
        private List<CustProjSlsOrdText> toCustProjSlsOrdText = Lists.newArrayList();

        private CustProjSlsOrd.CustProjSlsOrdBuilder toCustProjSlsOrdItem( final List<CustProjSlsOrdItem> value )
        {
            toCustProjSlsOrdItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdItem</b> for <b>CustProjSlsOrd</b> to multiple
         * <b>CustProjSlsOrdItem</b>.
         *
         * @param value
         *            The CustProjSlsOrdItems to build this CustProjSlsOrd with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrd.CustProjSlsOrdBuilder custProjSlsOrdItem( CustProjSlsOrdItem... value )
        {
            return toCustProjSlsOrdItem(Lists.newArrayList(value));
        }

        private CustProjSlsOrd.CustProjSlsOrdBuilder toCustProjSlsOrdPartner( final List<CustProjSlsOrdPartner> value )
        {
            toCustProjSlsOrdPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdPartner</b> for <b>CustProjSlsOrd</b> to multiple
         * <b>CustProjSlsOrdPartner</b>.
         *
         * @param value
         *            The CustProjSlsOrdPartners to build this CustProjSlsOrd with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrd.CustProjSlsOrdBuilder custProjSlsOrdPartner( CustProjSlsOrdPartner... value )
        {
            return toCustProjSlsOrdPartner(Lists.newArrayList(value));
        }

        private CustProjSlsOrd.CustProjSlsOrdBuilder toCustProjSlsOrdText( final List<CustProjSlsOrdText> value )
        {
            toCustProjSlsOrdText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdText</b> for <b>CustProjSlsOrd</b> to multiple
         * <b>CustProjSlsOrdText</b>.
         *
         * @param value
         *            The CustProjSlsOrdTexts to build this CustProjSlsOrd with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrd.CustProjSlsOrdBuilder custProjSlsOrdText( CustProjSlsOrdText... value )
        {
            return toCustProjSlsOrdText(Lists.newArrayList(value));
        }

    }

}
