/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.CustProjSlsOrdItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.CustProjSlsOrdItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.CustProjSlsOrdItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustProjSlsOrdItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustProjSlsOrdItem extends VdmEntity<CustProjSlsOrdItem>
{

    /**
     * Selector for all available fields of CustProjSlsOrdItem.
     *
     */
    public final static CustProjSlsOrdItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @return Commercial Project ID
     */
    @Key
    @SerializedName( "CustomerProject" )
    @JsonProperty( "CustomerProject" )
    @Nullable
    @ODataField( odataName = "CustomerProject" )
    private String customerProject;
    /**
     * Use with available fluent helpers to apply the <b>CustomerProject</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> CUSTOMER_PROJECT =
        new CustProjSlsOrdItemField<String>("CustomerProject");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SALES_ORDER_ITEM =
        new CustProjSlsOrdItemField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SALES_ORDER = new CustProjSlsOrdItemField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SalesOrderItemCategory" )
    @JsonProperty( "SalesOrderItemCategory" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemCategory" )
    private String salesOrderItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemCategory</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SALES_ORDER_ITEM_CATEGORY =
        new CustProjSlsOrdItemField<String>("SalesOrderItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> MATERIAL = new CustProjSlsOrdItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "SalesOrderItemText" )
    @JsonProperty( "SalesOrderItemText" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemText" )
    private String salesOrderItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemText</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SALES_ORDER_ITEM_TEXT =
        new CustProjSlsOrdItemField<String>("SalesOrderItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> PROFIT_CENTER =
        new CustProjSlsOrdItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CappedNetAmount</b>
     * </p>
     *
     * @return Net Amount Cap
     */
    @SerializedName( "CappedNetAmount" )
    @JsonProperty( "CappedNetAmount" )
    @Nullable
    @ODataField( odataName = "CappedNetAmount" )
    private BigDecimal cappedNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>CappedNetAmount</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<BigDecimal> CAPPED_NET_AMOUNT =
        new CustProjSlsOrdItemField<BigDecimal>("CappedNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CappedNetAmtAlertThldInPct</b>
     * </p>
     *
     * @return Notification Threshold (in Pct) for Exceeded Net Amount Cap
     */
    @SerializedName( "CappedNetAmtAlertThldInPct" )
    @JsonProperty( "CappedNetAmtAlertThldInPct" )
    @Nullable
    @ODataField( odataName = "CappedNetAmtAlertThldInPct" )
    private String cappedNetAmtAlertThldInPct;
    /**
     * Use with available fluent helpers to apply the <b>CappedNetAmtAlertThldInPct</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> CAPPED_NET_AMT_ALERT_THLD_IN_PCT =
        new CustProjSlsOrdItemField<String>("CappedNetAmtAlertThldInPct");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> MATERIAL_BY_CUSTOMER =
        new CustProjSlsOrdItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<BigDecimal> NET_AMOUNT =
        new CustProjSlsOrdItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedNetAmount</b>
     * </p>
     *
     * @return Expected Net Amount
     */
    @SerializedName( "ExpectedNetAmount" )
    @JsonProperty( "ExpectedNetAmount" )
    @Nullable
    @ODataField( odataName = "ExpectedNetAmount" )
    private BigDecimal expectedNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ExpectedNetAmount</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<BigDecimal> EXPECTED_NET_AMOUNT =
        new CustProjSlsOrdItemField<BigDecimal>("ExpectedNetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalStandAloneSellingPrice</b>
     * </p>
     *
     * @return IFRS 15: Standalone Selling Price
     */
    @SerializedName( "TotalStandAloneSellingPrice" )
    @JsonProperty( "TotalStandAloneSellingPrice" )
    @Nullable
    @ODataField( odataName = "TotalStandAloneSellingPrice" )
    private BigDecimal totalStandAloneSellingPrice;
    /**
     * Use with available fluent helpers to apply the <b>TotalStandAloneSellingPrice</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<BigDecimal> TOTAL_STAND_ALONE_SELLING_PRICE =
        new CustProjSlsOrdItemField<BigDecimal>("TotalStandAloneSellingPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> TRANSACTION_CURRENCY =
        new CustProjSlsOrdItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> WBS_ELEMENT = new CustProjSlsOrdItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new CustProjSlsOrdItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnderlyingPurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of the Underlying Purchase Order
     */
    @SerializedName( "UnderlyingPurchaseOrderItem" )
    @JsonProperty( "UnderlyingPurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "UnderlyingPurchaseOrderItem" )
    private String underlyingPurchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>UnderlyingPurchaseOrderItem</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> UNDERLYING_PURCHASE_ORDER_ITEM =
        new CustProjSlsOrdItemField<String>("UnderlyingPurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new CustProjSlsOrdItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRejectionStatus</b>
     * </p>
     *
     * @return Rejection Status (Item)
     */
    @SerializedName( "SDDocumentRejectionStatus" )
    @JsonProperty( "SDDocumentRejectionStatus" )
    @Nullable
    @ODataField( odataName = "SDDocumentRejectionStatus" )
    private String sDDocumentRejectionStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentRejectionStatus</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SD_DOCUMENT_REJECTION_STATUS =
        new CustProjSlsOrdItemField<String>("SDDocumentRejectionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> SD_PROCESS_STATUS =
        new CustProjSlsOrdItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Item
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemField<String> ITEM_BILLING_BLOCK_REASON =
        new CustProjSlsOrdItemField<String>("ItemBillingBlockReason");
    /**
     * Navigation property <b>to_CustProjSlsOrdItemPartner</b> for <b>CustProjSlsOrdItem</b> to multiple
     * <b>CustProjSlsOrdItemPartner</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdItemPartner" )
    @JsonProperty( "to_CustProjSlsOrdItemPartner" )
    @ODataField( odataName = "to_CustProjSlsOrdItemPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdItemPartner> toCustProjSlsOrdItemPartner;
    /**
     * Navigation property <b>to_CustProjSlsOrdItemText</b> for <b>CustProjSlsOrdItem</b> to multiple
     * <b>CustProjSlsOrdItemText</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdItemText" )
    @JsonProperty( "to_CustProjSlsOrdItemText" )
    @ODataField( odataName = "to_CustProjSlsOrdItemText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdItemText> toCustProjSlsOrdItemText;
    /**
     * Navigation property <b>to_CustProjSlsOrdItemWorkPckg</b> for <b>CustProjSlsOrdItem</b> to multiple
     * <b>CustProjSlsOrdItemWorkPckg</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdItemWorkPckg" )
    @JsonProperty( "to_CustProjSlsOrdItemWorkPckg" )
    @ODataField( odataName = "to_CustProjSlsOrdItemWorkPckg" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdItemWorkPckg> toCustProjSlsOrdItemWorkPckg;
    /**
     * Navigation property <b>to_CustProjSlsOrdItmPrcgElement</b> for <b>CustProjSlsOrdItem</b> to multiple
     * <b>CustProjSlsOrdItmPrcgElement</b>.
     *
     */
    @SerializedName( "to_CustProjSlsOrdItmPrcgElement" )
    @JsonProperty( "to_CustProjSlsOrdItmPrcgElement" )
    @ODataField( odataName = "to_CustProjSlsOrdItmPrcgElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdItmPrcgElement> toCustProjSlsOrdItmPrcgElement;
    /**
     * Navigation property <b>to_CustProjSOIBillgPlnItm</b> for <b>CustProjSlsOrdItem</b> to multiple
     * <b>CustProjSlsOrdItmBillgPlnItm</b>.
     *
     */
    @SerializedName( "to_CustProjSOIBillgPlnItm" )
    @JsonProperty( "to_CustProjSOIBillgPlnItm" )
    @ODataField( odataName = "to_CustProjSOIBillgPlnItm" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustProjSlsOrdItmBillgPlnItm> toCustProjSOIBillgPlnItm;
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdItemPartner</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdItemLink<CustProjSlsOrdItemPartner> TO_CUST_PROJ_SLS_ORD_ITEM_PARTNER =
        new CustProjSlsOrdItemLink<CustProjSlsOrdItemPartner>("to_CustProjSlsOrdItemPartner");
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdItemText</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdItemLink<CustProjSlsOrdItemText> TO_CUST_PROJ_SLS_ORD_ITEM_TEXT =
        new CustProjSlsOrdItemLink<CustProjSlsOrdItemText>("to_CustProjSlsOrdItemText");
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdItemWorkPckg</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdItemLink<CustProjSlsOrdItemWorkPckg> TO_CUST_PROJ_SLS_ORD_ITEM_WORK_PCKG =
        new CustProjSlsOrdItemLink<CustProjSlsOrdItemWorkPckg>("to_CustProjSlsOrdItemWorkPckg");
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSlsOrdItmPrcgElement</b> navigation property to
     * query operations.
     *
     */
    public final static CustProjSlsOrdItemLink<CustProjSlsOrdItmPrcgElement> TO_CUST_PROJ_SLS_ORD_ITM_PRCG_ELEMENT =
        new CustProjSlsOrdItemLink<CustProjSlsOrdItmPrcgElement>("to_CustProjSlsOrdItmPrcgElement");
    /**
     * Use with available fluent helpers to apply the <b>to_CustProjSOIBillgPlnItm</b> navigation property to query
     * operations.
     *
     */
    public final static CustProjSlsOrdItemLink<CustProjSlsOrdItmBillgPlnItm> TO_CUST_PROJ_SOI_BILLG_PLN_ITM =
        new CustProjSlsOrdItemLink<CustProjSlsOrdItmBillgPlnItm>("to_CustProjSOIBillgPlnItm");

    @Nonnull
    @Override
    public Class<CustProjSlsOrdItem> getType()
    {
        return CustProjSlsOrdItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @param customerProject
     *            Commercial Project ID
     */
    public void setCustomerProject( @Nullable final String customerProject )
    {
        rememberChangedField("CustomerProject", this.customerProject);
        this.customerProject = customerProject;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemCategory</b>
     * </p>
     *
     * @param salesOrderItemCategory
     *            Sales Document Item Category
     */
    public void setSalesOrderItemCategory( @Nullable final String salesOrderItemCategory )
    {
        rememberChangedField("SalesOrderItemCategory", this.salesOrderItemCategory);
        this.salesOrderItemCategory = salesOrderItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @param salesOrderItemText
     *            Short Text for Sales Order Item
     */
    public void setSalesOrderItemText( @Nullable final String salesOrderItemText )
    {
        rememberChangedField("SalesOrderItemText", this.salesOrderItemText);
        this.salesOrderItemText = salesOrderItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CappedNetAmount</b>
     * </p>
     *
     * @param cappedNetAmount
     *            Net Amount Cap
     */
    public void setCappedNetAmount( @Nullable final BigDecimal cappedNetAmount )
    {
        rememberChangedField("CappedNetAmount", this.cappedNetAmount);
        this.cappedNetAmount = cappedNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CappedNetAmtAlertThldInPct</b>
     * </p>
     *
     * @param cappedNetAmtAlertThldInPct
     *            Notification Threshold (in Pct) for Exceeded Net Amount Cap
     */
    public void setCappedNetAmtAlertThldInPct( @Nullable final String cappedNetAmtAlertThldInPct )
    {
        rememberChangedField("CappedNetAmtAlertThldInPct", this.cappedNetAmtAlertThldInPct);
        this.cappedNetAmtAlertThldInPct = cappedNetAmtAlertThldInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedNetAmount</b>
     * </p>
     *
     * @param expectedNetAmount
     *            Expected Net Amount
     */
    public void setExpectedNetAmount( @Nullable final BigDecimal expectedNetAmount )
    {
        rememberChangedField("ExpectedNetAmount", this.expectedNetAmount);
        this.expectedNetAmount = expectedNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalStandAloneSellingPrice</b>
     * </p>
     *
     * @param totalStandAloneSellingPrice
     *            IFRS 15: Standalone Selling Price
     */
    public void setTotalStandAloneSellingPrice( @Nullable final BigDecimal totalStandAloneSellingPrice )
    {
        rememberChangedField("TotalStandAloneSellingPrice", this.totalStandAloneSellingPrice);
        this.totalStandAloneSellingPrice = totalStandAloneSellingPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnderlyingPurchaseOrderItem</b>
     * </p>
     *
     * @param underlyingPurchaseOrderItem
     *            Item Number of the Underlying Purchase Order
     */
    public void setUnderlyingPurchaseOrderItem( @Nullable final String underlyingPurchaseOrderItem )
    {
        rememberChangedField("UnderlyingPurchaseOrderItem", this.underlyingPurchaseOrderItem);
        this.underlyingPurchaseOrderItem = underlyingPurchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentRejectionStatus</b>
     * </p>
     *
     * @param sDDocumentRejectionStatus
     *            Rejection Status (Item)
     */
    public void setSDDocumentRejectionStatus( @Nullable final String sDDocumentRejectionStatus )
    {
        rememberChangedField("SDDocumentRejectionStatus", this.sDDocumentRejectionStatus);
        this.sDDocumentRejectionStatus = sDDocumentRejectionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block for Item
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustProjSlsOrdItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerProject", getCustomerProject());
        result.put("SalesOrderItem", getSalesOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerProject", getCustomerProject());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItemCategory", getSalesOrderItemCategory());
        values.put("Material", getMaterial());
        values.put("SalesOrderItemText", getSalesOrderItemText());
        values.put("ProfitCenter", getProfitCenter());
        values.put("CappedNetAmount", getCappedNetAmount());
        values.put("CappedNetAmtAlertThldInPct", getCappedNetAmtAlertThldInPct());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("NetAmount", getNetAmount());
        values.put("ExpectedNetAmount", getExpectedNetAmount());
        values.put("TotalStandAloneSellingPrice", getTotalStandAloneSellingPrice());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("WBSElement", getWBSElement());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("UnderlyingPurchaseOrderItem", getUnderlyingPurchaseOrderItem());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("SDDocumentRejectionStatus", getSDDocumentRejectionStatus());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerProject") ) {
                final Object value = values.remove("CustomerProject");
                if( (value == null) || (!value.equals(getCustomerProject())) ) {
                    setCustomerProject(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemCategory") ) {
                final Object value = values.remove("SalesOrderItemCategory");
                if( (value == null) || (!value.equals(getSalesOrderItemCategory())) ) {
                    setSalesOrderItemCategory(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemText") ) {
                final Object value = values.remove("SalesOrderItemText");
                if( (value == null) || (!value.equals(getSalesOrderItemText())) ) {
                    setSalesOrderItemText(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("CappedNetAmount") ) {
                final Object value = values.remove("CappedNetAmount");
                if( (value == null) || (!value.equals(getCappedNetAmount())) ) {
                    setCappedNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CappedNetAmtAlertThldInPct") ) {
                final Object value = values.remove("CappedNetAmtAlertThldInPct");
                if( (value == null) || (!value.equals(getCappedNetAmtAlertThldInPct())) ) {
                    setCappedNetAmtAlertThldInPct(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExpectedNetAmount") ) {
                final Object value = values.remove("ExpectedNetAmount");
                if( (value == null) || (!value.equals(getExpectedNetAmount())) ) {
                    setExpectedNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalStandAloneSellingPrice") ) {
                final Object value = values.remove("TotalStandAloneSellingPrice");
                if( (value == null) || (!value.equals(getTotalStandAloneSellingPrice())) ) {
                    setTotalStandAloneSellingPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("UnderlyingPurchaseOrderItem") ) {
                final Object value = values.remove("UnderlyingPurchaseOrderItem");
                if( (value == null) || (!value.equals(getUnderlyingPurchaseOrderItem())) ) {
                    setUnderlyingPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("SDDocumentRejectionStatus") ) {
                final Object value = values.remove("SDDocumentRejectionStatus");
                if( (value == null) || (!value.equals(getSDDocumentRejectionStatus())) ) {
                    setSDDocumentRejectionStatus(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CustProjSlsOrdItemPartner") ) {
                final Object value = (values).remove("to_CustProjSlsOrdItemPartner");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdItemPartner == null ) {
                        toCustProjSlsOrdItemPartner = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdItemPartner = Lists.newArrayList(toCustProjSlsOrdItemPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdItemPartner entity;
                        if( toCustProjSlsOrdItemPartner.size() > i ) {
                            entity = toCustProjSlsOrdItemPartner.get(i);
                        } else {
                            entity = new CustProjSlsOrdItemPartner();
                            toCustProjSlsOrdItemPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CustProjSlsOrdItemText") ) {
                final Object value = (values).remove("to_CustProjSlsOrdItemText");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdItemText == null ) {
                        toCustProjSlsOrdItemText = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdItemText = Lists.newArrayList(toCustProjSlsOrdItemText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdItemText entity;
                        if( toCustProjSlsOrdItemText.size() > i ) {
                            entity = toCustProjSlsOrdItemText.get(i);
                        } else {
                            entity = new CustProjSlsOrdItemText();
                            toCustProjSlsOrdItemText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CustProjSlsOrdItemWorkPckg") ) {
                final Object value = (values).remove("to_CustProjSlsOrdItemWorkPckg");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdItemWorkPckg == null ) {
                        toCustProjSlsOrdItemWorkPckg = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdItemWorkPckg = Lists.newArrayList(toCustProjSlsOrdItemWorkPckg);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdItemWorkPckg entity;
                        if( toCustProjSlsOrdItemWorkPckg.size() > i ) {
                            entity = toCustProjSlsOrdItemWorkPckg.get(i);
                        } else {
                            entity = new CustProjSlsOrdItemWorkPckg();
                            toCustProjSlsOrdItemWorkPckg.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CustProjSlsOrdItmPrcgElement") ) {
                final Object value = (values).remove("to_CustProjSlsOrdItmPrcgElement");
                if( value instanceof Iterable ) {
                    if( toCustProjSlsOrdItmPrcgElement == null ) {
                        toCustProjSlsOrdItmPrcgElement = Lists.newArrayList();
                    } else {
                        toCustProjSlsOrdItmPrcgElement = Lists.newArrayList(toCustProjSlsOrdItmPrcgElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdItmPrcgElement entity;
                        if( toCustProjSlsOrdItmPrcgElement.size() > i ) {
                            entity = toCustProjSlsOrdItmPrcgElement.get(i);
                        } else {
                            entity = new CustProjSlsOrdItmPrcgElement();
                            toCustProjSlsOrdItmPrcgElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CustProjSOIBillgPlnItm") ) {
                final Object value = (values).remove("to_CustProjSOIBillgPlnItm");
                if( value instanceof Iterable ) {
                    if( toCustProjSOIBillgPlnItm == null ) {
                        toCustProjSOIBillgPlnItm = Lists.newArrayList();
                    } else {
                        toCustProjSOIBillgPlnItm = Lists.newArrayList(toCustProjSOIBillgPlnItm);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustProjSlsOrdItmBillgPlnItm entity;
                        if( toCustProjSOIBillgPlnItm.size() > i ) {
                            entity = toCustProjSOIBillgPlnItm.get(i);
                        } else {
                            entity = new CustProjSlsOrdItmBillgPlnItm();
                            toCustProjSOIBillgPlnItm.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustProjSlsOrdItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustProjSlsOrdItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustProjSlsOrdItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustProjSlsOrdItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCustProjSlsOrdItemPartner != null ) {
            (values).put("to_CustProjSlsOrdItemPartner", toCustProjSlsOrdItemPartner);
        }
        if( toCustProjSlsOrdItemText != null ) {
            (values).put("to_CustProjSlsOrdItemText", toCustProjSlsOrdItemText);
        }
        if( toCustProjSlsOrdItemWorkPckg != null ) {
            (values).put("to_CustProjSlsOrdItemWorkPckg", toCustProjSlsOrdItemWorkPckg);
        }
        if( toCustProjSlsOrdItmPrcgElement != null ) {
            (values).put("to_CustProjSlsOrdItmPrcgElement", toCustProjSlsOrdItmPrcgElement);
        }
        if( toCustProjSOIBillgPlnItm != null ) {
            (values).put("to_CustProjSOIBillgPlnItm", toCustProjSOIBillgPlnItm);
        }
        return values;
    }

    /**
     * Fetches the <b>CustProjSlsOrdItemPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CustProjSlsOrdItemPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItemPartner> fetchCustProjSlsOrdItemPartner()
    {
        return fetchFieldAsList("to_CustProjSlsOrdItemPartner", CustProjSlsOrdItemPartner.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemPartner</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemPartner</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItemPartner> getCustProjSlsOrdItemPartnerOrFetch()
    {
        if( toCustProjSlsOrdItemPartner == null ) {
            toCustProjSlsOrdItemPartner = fetchCustProjSlsOrdItemPartner();
        }
        return toCustProjSlsOrdItemPartner;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemPartner</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrdItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdItemPartner</b> is already loaded, the
     *         result will contain the <b>CustProjSlsOrdItemPartner</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdItemPartner>> getCustProjSlsOrdItemPartnerIfPresent()
    {
        return Option.of(toCustProjSlsOrdItemPartner);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdItemPartner</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdItemPartner</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemPartner</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdItemPartner</b> entities.
     */
    public void setCustProjSlsOrdItemPartner( @Nonnull final List<CustProjSlsOrdItemPartner> value )
    {
        if( toCustProjSlsOrdItemPartner == null ) {
            toCustProjSlsOrdItemPartner = Lists.newArrayList();
        }
        toCustProjSlsOrdItemPartner.clear();
        toCustProjSlsOrdItemPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemPartner</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemPartner</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdItemPartner</b> entities.
     */
    public void addCustProjSlsOrdItemPartner( CustProjSlsOrdItemPartner... entity )
    {
        if( toCustProjSlsOrdItemPartner == null ) {
            toCustProjSlsOrdItemPartner = Lists.newArrayList();
        }
        toCustProjSlsOrdItemPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustProjSlsOrdItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CustProjSlsOrdItemText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItemText> fetchCustProjSlsOrdItemText()
    {
        return fetchFieldAsList("to_CustProjSlsOrdItemText", CustProjSlsOrdItemText.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemText</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemText</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItemText> getCustProjSlsOrdItemTextOrFetch()
    {
        if( toCustProjSlsOrdItemText == null ) {
            toCustProjSlsOrdItemText = fetchCustProjSlsOrdItemText();
        }
        return toCustProjSlsOrdItemText;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemText</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrdItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdItemText</b> is already loaded, the result
     *         will contain the <b>CustProjSlsOrdItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdItemText>> getCustProjSlsOrdItemTextIfPresent()
    {
        return Option.of(toCustProjSlsOrdItemText);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdItemText</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdItemText</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemText</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdItemText</b> entities.
     */
    public void setCustProjSlsOrdItemText( @Nonnull final List<CustProjSlsOrdItemText> value )
    {
        if( toCustProjSlsOrdItemText == null ) {
            toCustProjSlsOrdItemText = Lists.newArrayList();
        }
        toCustProjSlsOrdItemText.clear();
        toCustProjSlsOrdItemText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemText</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemText</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdItemText</b> entities.
     */
    public void addCustProjSlsOrdItemText( CustProjSlsOrdItemText... entity )
    {
        if( toCustProjSlsOrdItemText == null ) {
            toCustProjSlsOrdItemText = Lists.newArrayList();
        }
        toCustProjSlsOrdItemText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustProjSlsOrdItemWorkPckg</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CustProjSlsOrdItemWorkPckg</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdItemWorkPckg</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItemWorkPckg> fetchCustProjSlsOrdItemWorkPckg()
    {
        return fetchFieldAsList("to_CustProjSlsOrdItemWorkPckg", CustProjSlsOrdItemWorkPckg.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItemWorkPckg</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemWorkPckg</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemWorkPckg</b> of a queried <b>CustProjSlsOrdItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdItemWorkPckg</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItemWorkPckg> getCustProjSlsOrdItemWorkPckgOrFetch()
    {
        if( toCustProjSlsOrdItemWorkPckg == null ) {
            toCustProjSlsOrdItemWorkPckg = fetchCustProjSlsOrdItemWorkPckg();
        }
        return toCustProjSlsOrdItemWorkPckg;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItemWorkPckg</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemWorkPckg</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrdItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdItemWorkPckg</b> is already loaded, the
     *         result will contain the <b>CustProjSlsOrdItemWorkPckg</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdItemWorkPckg>> getCustProjSlsOrdItemWorkPckgIfPresent()
    {
        return Option.of(toCustProjSlsOrdItemWorkPckg);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdItemWorkPckg</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdItemWorkPckg</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemWorkPckg</b> of a queried <b>CustProjSlsOrdItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdItemWorkPckg</b> entities.
     */
    public void setCustProjSlsOrdItemWorkPckg( @Nonnull final List<CustProjSlsOrdItemWorkPckg> value )
    {
        if( toCustProjSlsOrdItemWorkPckg == null ) {
            toCustProjSlsOrdItemWorkPckg = Lists.newArrayList();
        }
        toCustProjSlsOrdItemWorkPckg.clear();
        toCustProjSlsOrdItemWorkPckg.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdItemWorkPckg</b> entities. This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItemWorkPckg</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItemWorkPckg</b> of a queried <b>CustProjSlsOrdItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdItemWorkPckg</b> entities.
     */
    public void addCustProjSlsOrdItemWorkPckg( CustProjSlsOrdItemWorkPckg... entity )
    {
        if( toCustProjSlsOrdItemWorkPckg == null ) {
            toCustProjSlsOrdItemWorkPckg = Lists.newArrayList();
        }
        toCustProjSlsOrdItemWorkPckg.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustProjSlsOrdItmPrcgElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CustProjSlsOrdItmPrcgElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdItmPrcgElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItmPrcgElement> fetchCustProjSlsOrdItmPrcgElement()
    {
        return fetchFieldAsList("to_CustProjSlsOrdItmPrcgElement", CustProjSlsOrdItmPrcgElement.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItmPrcgElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItmPrcgElement</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItmPrcgElement</b> of a queried <b>CustProjSlsOrdItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdItmPrcgElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItmPrcgElement> getCustProjSlsOrdItmPrcgElementOrFetch()
    {
        if( toCustProjSlsOrdItmPrcgElement == null ) {
            toCustProjSlsOrdItmPrcgElement = fetchCustProjSlsOrdItmPrcgElement();
        }
        return toCustProjSlsOrdItmPrcgElement;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItmPrcgElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSlsOrdItmPrcgElement</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrdItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSlsOrdItmPrcgElement</b> is already loaded, the
     *         result will contain the <b>CustProjSlsOrdItmPrcgElement</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdItmPrcgElement>> getCustProjSlsOrdItmPrcgElementIfPresent()
    {
        return Option.of(toCustProjSlsOrdItmPrcgElement);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdItmPrcgElement</b> entities for the loaded navigation property
     * <b>to_CustProjSlsOrdItmPrcgElement</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItmPrcgElement</b> of a queried <b>CustProjSlsOrdItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdItmPrcgElement</b> entities.
     */
    public void setCustProjSlsOrdItmPrcgElement( @Nonnull final List<CustProjSlsOrdItmPrcgElement> value )
    {
        if( toCustProjSlsOrdItmPrcgElement == null ) {
            toCustProjSlsOrdItmPrcgElement = Lists.newArrayList();
        }
        toCustProjSlsOrdItmPrcgElement.clear();
        toCustProjSlsOrdItmPrcgElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdItmPrcgElement</b> entities. This corresponds to the
     * OData navigation property <b>to_CustProjSlsOrdItmPrcgElement</b>.
     * <p>
     * If the navigation property <b>to_CustProjSlsOrdItmPrcgElement</b> of a queried <b>CustProjSlsOrdItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdItmPrcgElement</b> entities.
     */
    public void addCustProjSlsOrdItmPrcgElement( CustProjSlsOrdItmPrcgElement... entity )
    {
        if( toCustProjSlsOrdItmPrcgElement == null ) {
            toCustProjSlsOrdItmPrcgElement = Lists.newArrayList();
        }
        toCustProjSlsOrdItmPrcgElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CustProjSlsOrdItmBillgPlnItm</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CustProjSOIBillgPlnItm</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustProjSlsOrdItmBillgPlnItm</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItmBillgPlnItm> fetchCustProjSOIBillgPlnItm()
    {
        return fetchFieldAsList("to_CustProjSOIBillgPlnItm", CustProjSlsOrdItmBillgPlnItm.class);
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItmBillgPlnItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSOIBillgPlnItm</b>.
     * <p>
     * If the navigation property <b>to_CustProjSOIBillgPlnItm</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustProjSlsOrdItmBillgPlnItm</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustProjSlsOrdItmBillgPlnItm> getCustProjSOIBillgPlnItmOrFetch()
    {
        if( toCustProjSOIBillgPlnItm == null ) {
            toCustProjSOIBillgPlnItm = fetchCustProjSOIBillgPlnItm();
        }
        return toCustProjSOIBillgPlnItm;
    }

    /**
     * Retrieval of associated <b>CustProjSlsOrdItmBillgPlnItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CustProjSOIBillgPlnItm</b>.
     * <p>
     * If the navigation property for an entity <b>CustProjSlsOrdItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CustProjSOIBillgPlnItm</b> is already loaded, the result
     *         will contain the <b>CustProjSlsOrdItmBillgPlnItm</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustProjSlsOrdItmBillgPlnItm>> getCustProjSOIBillgPlnItmIfPresent()
    {
        return Option.of(toCustProjSOIBillgPlnItm);
    }

    /**
     * Overwrites the list of associated <b>CustProjSlsOrdItmBillgPlnItm</b> entities for the loaded navigation property
     * <b>to_CustProjSOIBillgPlnItm</b>.
     * <p>
     * If the navigation property <b>to_CustProjSOIBillgPlnItm</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustProjSlsOrdItmBillgPlnItm</b> entities.
     */
    public void setCustProjSOIBillgPlnItm( @Nonnull final List<CustProjSlsOrdItmBillgPlnItm> value )
    {
        if( toCustProjSOIBillgPlnItm == null ) {
            toCustProjSOIBillgPlnItm = Lists.newArrayList();
        }
        toCustProjSOIBillgPlnItm.clear();
        toCustProjSOIBillgPlnItm.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustProjSlsOrdItmBillgPlnItm</b> entities. This corresponds to the
     * OData navigation property <b>to_CustProjSOIBillgPlnItm</b>.
     * <p>
     * If the navigation property <b>to_CustProjSOIBillgPlnItm</b> of a queried <b>CustProjSlsOrdItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustProjSlsOrdItmBillgPlnItm</b> entities.
     */
    public void addCustProjSOIBillgPlnItm( CustProjSlsOrdItmBillgPlnItm... entity )
    {
        if( toCustProjSOIBillgPlnItm == null ) {
            toCustProjSOIBillgPlnItm = Lists.newArrayList();
        }
        toCustProjSOIBillgPlnItm.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustProjSlsOrdItem instances.
     *
     */
    public final static class CustProjSlsOrdItemBuilder
    {

        private List<CustProjSlsOrdItemPartner> toCustProjSlsOrdItemPartner = Lists.newArrayList();
        private List<CustProjSlsOrdItemText> toCustProjSlsOrdItemText = Lists.newArrayList();
        private List<CustProjSlsOrdItemWorkPckg> toCustProjSlsOrdItemWorkPckg = Lists.newArrayList();
        private List<CustProjSlsOrdItmPrcgElement> toCustProjSlsOrdItmPrcgElement = Lists.newArrayList();
        private List<CustProjSlsOrdItmBillgPlnItm> toCustProjSOIBillgPlnItm = Lists.newArrayList();

        private CustProjSlsOrdItem.CustProjSlsOrdItemBuilder toCustProjSlsOrdItemPartner(
            final List<CustProjSlsOrdItemPartner> value )
        {
            toCustProjSlsOrdItemPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdItemPartner</b> for <b>CustProjSlsOrdItem</b> to multiple
         * <b>CustProjSlsOrdItemPartner</b>.
         *
         * @param value
         *            The CustProjSlsOrdItemPartners to build this CustProjSlsOrdItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrdItem.CustProjSlsOrdItemBuilder custProjSlsOrdItemPartner(
            CustProjSlsOrdItemPartner... value )
        {
            return toCustProjSlsOrdItemPartner(Lists.newArrayList(value));
        }

        private CustProjSlsOrdItem.CustProjSlsOrdItemBuilder toCustProjSlsOrdItemText(
            final List<CustProjSlsOrdItemText> value )
        {
            toCustProjSlsOrdItemText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdItemText</b> for <b>CustProjSlsOrdItem</b> to multiple
         * <b>CustProjSlsOrdItemText</b>.
         *
         * @param value
         *            The CustProjSlsOrdItemTexts to build this CustProjSlsOrdItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrdItem.CustProjSlsOrdItemBuilder custProjSlsOrdItemText( CustProjSlsOrdItemText... value )
        {
            return toCustProjSlsOrdItemText(Lists.newArrayList(value));
        }

        private CustProjSlsOrdItem.CustProjSlsOrdItemBuilder toCustProjSlsOrdItemWorkPckg(
            final List<CustProjSlsOrdItemWorkPckg> value )
        {
            toCustProjSlsOrdItemWorkPckg.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdItemWorkPckg</b> for <b>CustProjSlsOrdItem</b> to multiple
         * <b>CustProjSlsOrdItemWorkPckg</b>.
         *
         * @param value
         *            The CustProjSlsOrdItemWorkPckgs to build this CustProjSlsOrdItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrdItem.CustProjSlsOrdItemBuilder custProjSlsOrdItemWorkPckg(
            CustProjSlsOrdItemWorkPckg... value )
        {
            return toCustProjSlsOrdItemWorkPckg(Lists.newArrayList(value));
        }

        private CustProjSlsOrdItem.CustProjSlsOrdItemBuilder toCustProjSlsOrdItmPrcgElement(
            final List<CustProjSlsOrdItmPrcgElement> value )
        {
            toCustProjSlsOrdItmPrcgElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSlsOrdItmPrcgElement</b> for <b>CustProjSlsOrdItem</b> to multiple
         * <b>CustProjSlsOrdItmPrcgElement</b>.
         *
         * @param value
         *            The CustProjSlsOrdItmPrcgElements to build this CustProjSlsOrdItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrdItem.CustProjSlsOrdItemBuilder custProjSlsOrdItmPrcgElement(
            CustProjSlsOrdItmPrcgElement... value )
        {
            return toCustProjSlsOrdItmPrcgElement(Lists.newArrayList(value));
        }

        private CustProjSlsOrdItem.CustProjSlsOrdItemBuilder toCustProjSOIBillgPlnItm(
            final List<CustProjSlsOrdItmBillgPlnItm> value )
        {
            toCustProjSOIBillgPlnItm.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CustProjSOIBillgPlnItm</b> for <b>CustProjSlsOrdItem</b> to multiple
         * <b>CustProjSlsOrdItmBillgPlnItm</b>.
         *
         * @param value
         *            The CustProjSlsOrdItmBillgPlnItms to build this CustProjSlsOrdItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustProjSlsOrdItem.CustProjSlsOrdItemBuilder custProjSOIBillgPlnItm(
            CustProjSlsOrdItmBillgPlnItm... value )
        {
            return toCustProjSOIBillgPlnItm(Lists.newArrayList(value));
        }

    }

}
