/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.CustProjSlsOrdItemWorkPckgField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.CustProjSlsOrdItemWorkPckgSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sales Order Item Work Package
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustProjSlsOrdItemWorkPckgType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustProjSlsOrdItemWorkPckg extends VdmEntity<CustProjSlsOrdItemWorkPckg>
{

    /**
     * Selector for all available fields of CustProjSlsOrdItemWorkPckg.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @return Commercial Project ID
     */
    @Key
    @SerializedName( "CustomerProject" )
    @JsonProperty( "CustomerProject" )
    @Nullable
    @ODataField( odataName = "CustomerProject" )
    private String customerProject;
    /**
     * Use with available fluent helpers to apply the <b>CustomerProject</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<String> CUSTOMER_PROJECT =
        new CustProjSlsOrdItemWorkPckgField<String>("CustomerProject");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<String> SALES_ORDER_ITEM =
        new CustProjSlsOrdItemWorkPckgField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return Plan Item
     */
    @Key
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<String> WORK_PACKAGE =
        new CustProjSlsOrdItemWorkPckgField<String>("WorkPackage");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @return Plan Item Description
     */
    @SerializedName( "WorkPackageName" )
    @JsonProperty( "WorkPackageName" )
    @Nullable
    @ODataField( odataName = "WorkPackageName" )
    private String workPackageName;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageName</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<String> WORK_PACKAGE_NAME =
        new CustProjSlsOrdItemWorkPckgField<String>("WorkPackageName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<String> SALES_ORDER =
        new CustProjSlsOrdItemWorkPckgField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageStartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "WorkPackageStartDate" )
    @JsonProperty( "WorkPackageStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WorkPackageStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime workPackageStartDate;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageStartDate</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<LocalDateTime> WORK_PACKAGE_START_DATE =
        new CustProjSlsOrdItemWorkPckgField<LocalDateTime>("WorkPackageStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageEndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "WorkPackageEndDate" )
    @JsonProperty( "WorkPackageEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WorkPackageEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime workPackageEndDate;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageEndDate</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItemWorkPckgField<LocalDateTime> WORK_PACKAGE_END_DATE =
        new CustProjSlsOrdItemWorkPckgField<LocalDateTime>("WorkPackageEndDate");

    @Nonnull
    @Override
    public Class<CustProjSlsOrdItemWorkPckg> getType()
    {
        return CustProjSlsOrdItemWorkPckg.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @param customerProject
     *            Commercial Project ID
     */
    public void setCustomerProject( @Nullable final String customerProject )
    {
        rememberChangedField("CustomerProject", this.customerProject);
        this.customerProject = customerProject;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            Plan Item
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @param workPackageName
     *            Plan Item Description
     */
    public void setWorkPackageName( @Nullable final String workPackageName )
    {
        rememberChangedField("WorkPackageName", this.workPackageName);
        this.workPackageName = workPackageName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageStartDate</b>
     * </p>
     *
     * @param workPackageStartDate
     *            Start Date
     */
    public void setWorkPackageStartDate( @Nullable final LocalDateTime workPackageStartDate )
    {
        rememberChangedField("WorkPackageStartDate", this.workPackageStartDate);
        this.workPackageStartDate = workPackageStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageEndDate</b>
     * </p>
     *
     * @param workPackageEndDate
     *            End Date
     */
    public void setWorkPackageEndDate( @Nullable final LocalDateTime workPackageEndDate )
    {
        rememberChangedField("WorkPackageEndDate", this.workPackageEndDate);
        this.workPackageEndDate = workPackageEndDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustProjSlsOrdItemWorkPckg";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerProject", getCustomerProject());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("WorkPackage", getWorkPackage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerProject", getCustomerProject());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("WorkPackage", getWorkPackage());
        values.put("WorkPackageName", getWorkPackageName());
        values.put("SalesOrder", getSalesOrder());
        values.put("WorkPackageStartDate", getWorkPackageStartDate());
        values.put("WorkPackageEndDate", getWorkPackageEndDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerProject") ) {
                final Object value = values.remove("CustomerProject");
                if( (value == null) || (!value.equals(getCustomerProject())) ) {
                    setCustomerProject(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("WorkPackageName") ) {
                final Object value = values.remove("WorkPackageName");
                if( (value == null) || (!value.equals(getWorkPackageName())) ) {
                    setWorkPackageName(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("WorkPackageStartDate") ) {
                final Object value = values.remove("WorkPackageStartDate");
                if( (value == null) || (!value.equals(getWorkPackageStartDate())) ) {
                    setWorkPackageStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WorkPackageEndDate") ) {
                final Object value = values.remove("WorkPackageEndDate");
                if( (value == null) || (!value.equals(getWorkPackageEndDate())) ) {
                    setWorkPackageEndDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustProjSlsOrdItemWorkPckgField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustProjSlsOrdItemWorkPckgField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustProjSlsOrdItemWorkPckgField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustProjSlsOrdItemWorkPckgField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

}
