/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
 * CustProjSlsOrdItemWorkPckg} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class CustProjSlsOrdItemWorkPckgDeleteFluentHelper
    extends
    FluentHelperDelete<CustProjSlsOrdItemWorkPckgDeleteFluentHelper, CustProjSlsOrdItemWorkPckg>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final CustProjSlsOrdItemWorkPckg entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The CustProjSlsOrdItemWorkPckg to delete from the endpoint.
     */
    public CustProjSlsOrdItemWorkPckgDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final CustProjSlsOrdItemWorkPckg entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected CustProjSlsOrdItemWorkPckg getEntity()
    {
        return entity;
    }

}
