/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.CustProjSlsOrdItmBillgPlnItmField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.CustProjSlsOrdItmBillgPlnItmSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sales Order Item Billing Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustProjSlsOrdItmBillgPlnItmType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustProjSlsOrdItmBillgPlnItm extends VdmEntity<CustProjSlsOrdItmBillgPlnItm>
{

    /**
     * Selector for all available fields of CustProjSlsOrdItmBillgPlnItm.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @return Commercial Project ID
     */
    @Key
    @SerializedName( "CustomerProject" )
    @JsonProperty( "CustomerProject" )
    @Nullable
    @ODataField( odataName = "CustomerProject" )
    private String customerProject;
    /**
     * Use with available fluent helpers to apply the <b>CustomerProject</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> CUSTOMER_PROJECT =
        new CustProjSlsOrdItmBillgPlnItmField<String>("CustomerProject");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> SALES_ORDER_ITEM =
        new CustProjSlsOrdItmBillgPlnItmField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @return Item for billing plan/invoice plan/payment cards
     */
    @Key
    @SerializedName( "BillingPlanItem" )
    @JsonProperty( "BillingPlanItem" )
    @Nullable
    @ODataField( odataName = "BillingPlanItem" )
    private String billingPlanItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanItem</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> BILLING_PLAN_ITEM =
        new CustProjSlsOrdItmBillgPlnItmField<String>("BillingPlanItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> SALES_ORDER =
        new CustProjSlsOrdItmBillgPlnItmField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingPlanBillingDate" )
    @JsonProperty( "BillingPlanBillingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanBillingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanBillingDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanBillingDate</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<LocalDateTime> BILLING_PLAN_BILLING_DATE =
        new CustProjSlsOrdItmBillgPlnItmField<LocalDateTime>("BillingPlanBillingDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanRelatedBillgStatus</b>
     * </p>
     *
     * @return Billing Status for Billing Plan/Invoice Plan Date
     */
    @SerializedName( "BillingPlanRelatedBillgStatus" )
    @JsonProperty( "BillingPlanRelatedBillgStatus" )
    @Nullable
    @ODataField( odataName = "BillingPlanRelatedBillgStatus" )
    private String billingPlanRelatedBillgStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanRelatedBillgStatus</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> BILLING_PLAN_RELATED_BILLG_STATUS =
        new CustProjSlsOrdItmBillgPlnItmField<String>("BillingPlanRelatedBillgStatus");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanAmount</b>
     * </p>
     *
     * @return Value to be billed/calc. on date in billing/invoice plan
     */
    @SerializedName( "BillingPlanAmount" )
    @JsonProperty( "BillingPlanAmount" )
    @Nullable
    @ODataField( odataName = "BillingPlanAmount" )
    private BigDecimal billingPlanAmount;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanAmount</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<BigDecimal> BILLING_PLAN_AMOUNT =
        new CustProjSlsOrdItmBillgPlnItmField<BigDecimal>("BillingPlanAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> TRANSACTION_CURRENCY =
        new CustProjSlsOrdItmBillgPlnItmField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItemUsage</b>
     * </p>
     *
     * @return Billing Plan Item Usage
     */
    @SerializedName( "BillingPlanItemUsage" )
    @JsonProperty( "BillingPlanItemUsage" )
    @Nullable
    @ODataField( odataName = "BillingPlanItemUsage" )
    private String billingPlanItemUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanItemUsage</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> BILLING_PLAN_ITEM_USAGE =
        new CustProjSlsOrdItmBillgPlnItmField<String>("BillingPlanItemUsage");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItemDescription</b>
     * </p>
     *
     * @return Billing Plan Item Description
     */
    @SerializedName( "BillingPlanItemDescription" )
    @JsonProperty( "BillingPlanItemDescription" )
    @Nullable
    @ODataField( odataName = "BillingPlanItemDescription" )
    private String billingPlanItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanItemDescription</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<String> BILLING_PLAN_ITEM_DESCRIPTION =
        new CustProjSlsOrdItmBillgPlnItmField<String>("BillingPlanItemDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceStartDate</b>
     * </p>
     *
     * @return Settlement Start Date of Billing/Invoicing Date
     */
    @SerializedName( "BillingPlanServiceStartDate" )
    @JsonProperty( "BillingPlanServiceStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanServiceStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanServiceStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanServiceStartDate</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<LocalDateTime> BILLING_PLAN_SERVICE_START_DATE =
        new CustProjSlsOrdItmBillgPlnItmField<LocalDateTime>("BillingPlanServiceStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceEndDate</b>
     * </p>
     *
     * @return Settlement End Date of Billing/Invoicing Date
     */
    @SerializedName( "BillingPlanServiceEndDate" )
    @JsonProperty( "BillingPlanServiceEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanServiceEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanServiceEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanServiceEndDate</b> field to query operations.
     *
     */
    public final static CustProjSlsOrdItmBillgPlnItmField<LocalDateTime> BILLING_PLAN_SERVICE_END_DATE =
        new CustProjSlsOrdItmBillgPlnItmField<LocalDateTime>("BillingPlanServiceEndDate");

    @Nonnull
    @Override
    public Class<CustProjSlsOrdItmBillgPlnItm> getType()
    {
        return CustProjSlsOrdItmBillgPlnItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CustomerProject</b>
     * </p>
     *
     * @param customerProject
     *            Commercial Project ID
     */
    public void setCustomerProject( @Nullable final String customerProject )
    {
        rememberChangedField("CustomerProject", this.customerProject);
        this.customerProject = customerProject;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     */
    public void setBillingPlanItem( @Nullable final String billingPlanItem )
    {
        rememberChangedField("BillingPlanItem", this.billingPlanItem);
        this.billingPlanItem = billingPlanItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDate</b>
     * </p>
     *
     * @param billingPlanBillingDate
     *            Billing Date
     */
    public void setBillingPlanBillingDate( @Nullable final LocalDateTime billingPlanBillingDate )
    {
        rememberChangedField("BillingPlanBillingDate", this.billingPlanBillingDate);
        this.billingPlanBillingDate = billingPlanBillingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanRelatedBillgStatus</b>
     * </p>
     *
     * @param billingPlanRelatedBillgStatus
     *            Billing Status for Billing Plan/Invoice Plan Date
     */
    public void setBillingPlanRelatedBillgStatus( @Nullable final String billingPlanRelatedBillgStatus )
    {
        rememberChangedField("BillingPlanRelatedBillgStatus", this.billingPlanRelatedBillgStatus);
        this.billingPlanRelatedBillgStatus = billingPlanRelatedBillgStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanAmount</b>
     * </p>
     *
     * @param billingPlanAmount
     *            Value to be billed/calc. on date in billing/invoice plan
     */
    public void setBillingPlanAmount( @Nullable final BigDecimal billingPlanAmount )
    {
        rememberChangedField("BillingPlanAmount", this.billingPlanAmount);
        this.billingPlanAmount = billingPlanAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency Key
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItemUsage</b>
     * </p>
     *
     * @param billingPlanItemUsage
     *            Billing Plan Item Usage
     */
    public void setBillingPlanItemUsage( @Nullable final String billingPlanItemUsage )
    {
        rememberChangedField("BillingPlanItemUsage", this.billingPlanItemUsage);
        this.billingPlanItemUsage = billingPlanItemUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItemDescription</b>
     * </p>
     *
     * @param billingPlanItemDescription
     *            Billing Plan Item Description
     */
    public void setBillingPlanItemDescription( @Nullable final String billingPlanItemDescription )
    {
        rememberChangedField("BillingPlanItemDescription", this.billingPlanItemDescription);
        this.billingPlanItemDescription = billingPlanItemDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceStartDate</b>
     * </p>
     *
     * @param billingPlanServiceStartDate
     *            Settlement Start Date of Billing/Invoicing Date
     */
    public void setBillingPlanServiceStartDate( @Nullable final LocalDateTime billingPlanServiceStartDate )
    {
        rememberChangedField("BillingPlanServiceStartDate", this.billingPlanServiceStartDate);
        this.billingPlanServiceStartDate = billingPlanServiceStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceEndDate</b>
     * </p>
     *
     * @param billingPlanServiceEndDate
     *            Settlement End Date of Billing/Invoicing Date
     */
    public void setBillingPlanServiceEndDate( @Nullable final LocalDateTime billingPlanServiceEndDate )
    {
        rememberChangedField("BillingPlanServiceEndDate", this.billingPlanServiceEndDate);
        this.billingPlanServiceEndDate = billingPlanServiceEndDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustProjSlsOrdItmBillgPlnItm";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CustomerProject", getCustomerProject());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("BillingPlanItem", getBillingPlanItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CustomerProject", getCustomerProject());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("BillingPlanItem", getBillingPlanItem());
        values.put("SalesOrder", getSalesOrder());
        values.put("BillingPlanBillingDate", getBillingPlanBillingDate());
        values.put("BillingPlanRelatedBillgStatus", getBillingPlanRelatedBillgStatus());
        values.put("BillingPlanAmount", getBillingPlanAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("BillingPlanItemUsage", getBillingPlanItemUsage());
        values.put("BillingPlanItemDescription", getBillingPlanItemDescription());
        values.put("BillingPlanServiceStartDate", getBillingPlanServiceStartDate());
        values.put("BillingPlanServiceEndDate", getBillingPlanServiceEndDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CustomerProject") ) {
                final Object value = values.remove("CustomerProject");
                if( (value == null) || (!value.equals(getCustomerProject())) ) {
                    setCustomerProject(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("BillingPlanItem") ) {
                final Object value = values.remove("BillingPlanItem");
                if( (value == null) || (!value.equals(getBillingPlanItem())) ) {
                    setBillingPlanItem(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("BillingPlanBillingDate") ) {
                final Object value = values.remove("BillingPlanBillingDate");
                if( (value == null) || (!value.equals(getBillingPlanBillingDate())) ) {
                    setBillingPlanBillingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanRelatedBillgStatus") ) {
                final Object value = values.remove("BillingPlanRelatedBillgStatus");
                if( (value == null) || (!value.equals(getBillingPlanRelatedBillgStatus())) ) {
                    setBillingPlanRelatedBillgStatus(((String) value));
                }
            }
            if( values.containsKey("BillingPlanAmount") ) {
                final Object value = values.remove("BillingPlanAmount");
                if( (value == null) || (!value.equals(getBillingPlanAmount())) ) {
                    setBillingPlanAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("BillingPlanItemUsage") ) {
                final Object value = values.remove("BillingPlanItemUsage");
                if( (value == null) || (!value.equals(getBillingPlanItemUsage())) ) {
                    setBillingPlanItemUsage(((String) value));
                }
            }
            if( values.containsKey("BillingPlanItemDescription") ) {
                final Object value = values.remove("BillingPlanItemDescription");
                if( (value == null) || (!value.equals(getBillingPlanItemDescription())) ) {
                    setBillingPlanItemDescription(((String) value));
                }
            }
            if( values.containsKey("BillingPlanServiceStartDate") ) {
                final Object value = values.remove("BillingPlanServiceStartDate");
                if( (value == null) || (!value.equals(getBillingPlanServiceStartDate())) ) {
                    setBillingPlanServiceStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanServiceEndDate") ) {
                final Object value = values.remove("BillingPlanServiceEndDate");
                if( (value == null) || (!value.equals(getBillingPlanServiceEndDate())) ) {
                    setBillingPlanServiceEndDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustProjSlsOrdItmBillgPlnItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustProjSlsOrdItmBillgPlnItmField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustProjSlsOrdItmBillgPlnItmField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustProjSlsOrdItmBillgPlnItmField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

}
