/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.CustProjSlsOrdItmPrcgElementSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElement
 * CustProjSlsOrdItmPrcgElement} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CustProjSlsOrdItmPrcgElementByKeyFluentHelper
    extends
    FluentHelperByKey<CustProjSlsOrdItmPrcgElementByKeyFluentHelper, CustProjSlsOrdItmPrcgElement, CustProjSlsOrdItmPrcgElementSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmPrcgElement
     * CustProjSlsOrdItmPrcgElement} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CustProjSlsOrdItmPrcgElement}
     * @param salesOrderItem
     *            Sales Order Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param customerProject
     *            Commercial Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CustProjSlsOrdItmPrcgElement}
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public CustProjSlsOrdItmPrcgElementByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String customerProject,
        final String salesOrderItem,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        super(servicePath, entityCollection);
        this.key.put("CustomerProject", customerProject);
        this.key.put("SalesOrderItem", salesOrderItem);
        this.key.put("PricingProcedureStep", pricingProcedureStep);
        this.key.put("PricingProcedureCounter", pricingProcedureCounter);
    }

    @Override
    @Nonnull
    protected Class<CustProjSlsOrdItmPrcgElement> getEntityClass()
    {
        return CustProjSlsOrdItmPrcgElement.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
