/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText CustProjSlsOrdText}
 * entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class CustProjSlsOrdTextDeleteFluentHelper
    extends
    FluentHelperDelete<CustProjSlsOrdTextDeleteFluentHelper, CustProjSlsOrdText>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final CustProjSlsOrdText entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The CustProjSlsOrdText to delete from the endpoint.
     */
    public CustProjSlsOrdTextDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final CustProjSlsOrdText entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected CustProjSlsOrdText getEntity()
    {
        return entity;
    }

}
