/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.DemandField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.DemandSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Demands
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Demand</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Demand extends VdmEntity<Demand>
{

    /**
     * Selector for all available fields of Demand.
     *
     */
    public final static DemandSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @return Billing Control Category
     */
    @SerializedName( "BillingControlCategory" )
    @JsonProperty( "BillingControlCategory" )
    @Nullable
    @ODataField( odataName = "BillingControlCategory" )
    private String billingControlCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingControlCategory</b> field to query operations.
     *
     */
    public final static DemandField<String> BILLING_CONTROL_CATEGORY =
        new DemandField<String>("BillingControlCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static DemandField<String> PROJECT_ID = new DemandField<String>("ProjectID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Uom</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "Uom" )
    @JsonProperty( "Uom" )
    @Nullable
    @ODataField( odataName = "Uom" )
    private String uom;
    /**
     * Use with available fluent helpers to apply the <b>Uom</b> field to query operations.
     *
     */
    public final static DemandField<String> UOM = new DemandField<String>("Uom");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Skills</b>
     * </p>
     *
     * @return Skills (Comma Separated)
     */
    @SerializedName( "Skills" )
    @JsonProperty( "Skills" )
    @Nullable
    @ODataField( odataName = "Skills" )
    private String skills;
    /**
     * Use with available fluent helpers to apply the <b>Skills</b> field to query operations.
     *
     */
    public final static DemandField<String> SKILLS = new DemandField<String>("Skills");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackageID" )
    @JsonProperty( "WorkPackageID" )
    @Nullable
    @ODataField( odataName = "WorkPackageID" )
    private String workPackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageID</b> field to query operations.
     *
     */
    public final static DemandField<String> WORK_PACKAGE_ID = new DemandField<String>("WorkPackageID");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExpenseCost</b>
     * </p>
     *
     * @return Expense (Cost)
     */
    @SerializedName( "ExpenseCost" )
    @JsonProperty( "ExpenseCost" )
    @Nullable
    @ODataField( odataName = "ExpenseCost" )
    private BigDecimal expenseCost;
    /**
     * Use with available fluent helpers to apply the <b>ExpenseCost</b> field to query operations.
     *
     */
    public final static DemandField<BigDecimal> EXPENSE_COST = new DemandField<BigDecimal>("ExpenseCost");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @return Work Package Name
     */
    @Key
    @SerializedName( "WorkPackageName" )
    @JsonProperty( "WorkPackageName" )
    @Nullable
    @ODataField( odataName = "WorkPackageName" )
    private String workPackageName;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageName</b> field to query operations.
     *
     */
    public final static DemandField<String> WORK_PACKAGE_NAME = new DemandField<String>("WorkPackageName");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExpenseRevenue</b>
     * </p>
     *
     * @return Expense (Revenue)
     */
    @SerializedName( "ExpenseRevenue" )
    @JsonProperty( "ExpenseRevenue" )
    @Nullable
    @ODataField( odataName = "ExpenseRevenue" )
    private BigDecimal expenseRevenue;
    /**
     * Use with available fluent helpers to apply the <b>ExpenseRevenue</b> field to query operations.
     *
     */
    public final static DemandField<BigDecimal> EXPENSE_REVENUE = new DemandField<BigDecimal>("ExpenseRevenue");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResType</b>
     * </p>
     *
     * @return Resource Type ID
     */
    @Key
    @SerializedName( "ResType" )
    @JsonProperty( "ResType" )
    @Nullable
    @ODataField( odataName = "ResType" )
    private String resType;
    /**
     * Use with available fluent helpers to apply the <b>ResType</b> field to query operations.
     *
     */
    public final static DemandField<String> RES_TYPE = new DemandField<String>("ResType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ResourceId</b>
     * </p>
     *
     * @return Resource ID
     */
    @Key
    @SerializedName( "ResourceId" )
    @JsonProperty( "ResourceId" )
    @Nullable
    @ODataField( odataName = "ResourceId" )
    private String resourceId;
    /**
     * Use with available fluent helpers to apply the <b>ResourceId</b> field to query operations.
     *
     */
    public final static DemandField<String> RESOURCE_ID = new DemandField<String>("ResourceId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Workitem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @Key
    @SerializedName( "Workitem" )
    @JsonProperty( "Workitem" )
    @Nullable
    @ODataField( odataName = "Workitem" )
    private String workitem;
    /**
     * Use with available fluent helpers to apply the <b>Workitem</b> field to query operations.
     *
     */
    public final static DemandField<String> WORKITEM = new DemandField<String>("Workitem");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Effort</b>
     * </p>
     *
     * @return Total Quantity
     */
    @SerializedName( "Effort" )
    @JsonProperty( "Effort" )
    @Nullable
    @ODataField( odataName = "Effort" )
    private BigDecimal effort;
    /**
     * Use with available fluent helpers to apply the <b>Effort</b> field to query operations.
     *
     */
    public final static DemandField<BigDecimal> EFFORT = new DemandField<BigDecimal>("Effort");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DelvryServOrg</b>
     * </p>
     *
     * @return Delivery Org. ID
     */
    @Key
    @SerializedName( "DelvryServOrg" )
    @JsonProperty( "DelvryServOrg" )
    @Nullable
    @ODataField( odataName = "DelvryServOrg" )
    private String delvryServOrg;
    /**
     * Use with available fluent helpers to apply the <b>DelvryServOrg</b> field to query operations.
     *
     */
    public final static DemandField<String> DELVRY_SERV_ORG = new DemandField<String>("DelvryServOrg");

    @Nonnull
    @Override
    public Class<Demand> getType()
    {
        return Demand.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @param billingControlCategory
     *            Billing Control Category
     */
    public void setBillingControlCategory( @Nullable final String billingControlCategory )
    {
        rememberChangedField("BillingControlCategory", this.billingControlCategory);
        this.billingControlCategory = billingControlCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Uom</b>
     * </p>
     *
     * @param uom
     *            Unit of Measure
     */
    public void setUom( @Nullable final String uom )
    {
        rememberChangedField("Uom", this.uom);
        this.uom = uom;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Skills</b>
     * </p>
     *
     * @param skills
     *            Skills (Comma Separated)
     */
    public void setSkills( @Nullable final String skills )
    {
        rememberChangedField("Skills", this.skills);
        this.skills = skills;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @param workPackageID
     *            Work Package ID
     */
    public void setWorkPackageID( @Nullable final String workPackageID )
    {
        rememberChangedField("WorkPackageID", this.workPackageID);
        this.workPackageID = workPackageID;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExpenseCost</b>
     * </p>
     *
     * @param expenseCost
     *            Expense (Cost)
     */
    public void setExpenseCost( @Nullable final BigDecimal expenseCost )
    {
        rememberChangedField("ExpenseCost", this.expenseCost);
        this.expenseCost = expenseCost;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @param workPackageName
     *            Work Package Name
     */
    public void setWorkPackageName( @Nullable final String workPackageName )
    {
        rememberChangedField("WorkPackageName", this.workPackageName);
        this.workPackageName = workPackageName;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExpenseRevenue</b>
     * </p>
     *
     * @param expenseRevenue
     *            Expense (Revenue)
     */
    public void setExpenseRevenue( @Nullable final BigDecimal expenseRevenue )
    {
        rememberChangedField("ExpenseRevenue", this.expenseRevenue);
        this.expenseRevenue = expenseRevenue;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResType</b>
     * </p>
     *
     * @param resType
     *            Resource Type ID
     */
    public void setResType( @Nullable final String resType )
    {
        rememberChangedField("ResType", this.resType);
        this.resType = resType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ResourceId</b>
     * </p>
     *
     * @param resourceId
     *            Resource ID
     */
    public void setResourceId( @Nullable final String resourceId )
    {
        rememberChangedField("ResourceId", this.resourceId);
        this.resourceId = resourceId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Workitem</b>
     * </p>
     *
     * @param workitem
     *            Work Item ID
     */
    public void setWorkitem( @Nullable final String workitem )
    {
        rememberChangedField("Workitem", this.workitem);
        this.workitem = workitem;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Effort</b>
     * </p>
     *
     * @param effort
     *            Total Quantity
     */
    public void setEffort( @Nullable final BigDecimal effort )
    {
        rememberChangedField("Effort", this.effort);
        this.effort = effort;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DelvryServOrg</b>
     * </p>
     *
     * @param delvryServOrg
     *            Delivery Org. ID
     */
    public void setDelvryServOrg( @Nullable final String delvryServOrg )
    {
        rememberChangedField("DelvryServOrg", this.delvryServOrg);
        this.delvryServOrg = delvryServOrg;
    }

    @Override
    protected String getEntityCollection()
    {
        return "DemandSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        result.put("WorkPackageID", getWorkPackageID());
        result.put("WorkPackageName", getWorkPackageName());
        result.put("ResType", getResType());
        result.put("ResourceId", getResourceId());
        result.put("Workitem", getWorkitem());
        result.put("DelvryServOrg", getDelvryServOrg());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingControlCategory", getBillingControlCategory());
        values.put("ProjectID", getProjectID());
        values.put("Uom", getUom());
        values.put("Skills", getSkills());
        values.put("WorkPackageID", getWorkPackageID());
        values.put("ExpenseCost", getExpenseCost());
        values.put("WorkPackageName", getWorkPackageName());
        values.put("ExpenseRevenue", getExpenseRevenue());
        values.put("ResType", getResType());
        values.put("ResourceId", getResourceId());
        values.put("Workitem", getWorkitem());
        values.put("Effort", getEffort());
        values.put("DelvryServOrg", getDelvryServOrg());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingControlCategory") ) {
                final Object value = values.remove("BillingControlCategory");
                if( (value == null) || (!value.equals(getBillingControlCategory())) ) {
                    setBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("Uom") ) {
                final Object value = values.remove("Uom");
                if( (value == null) || (!value.equals(getUom())) ) {
                    setUom(((String) value));
                }
            }
            if( values.containsKey("Skills") ) {
                final Object value = values.remove("Skills");
                if( (value == null) || (!value.equals(getSkills())) ) {
                    setSkills(((String) value));
                }
            }
            if( values.containsKey("WorkPackageID") ) {
                final Object value = values.remove("WorkPackageID");
                if( (value == null) || (!value.equals(getWorkPackageID())) ) {
                    setWorkPackageID(((String) value));
                }
            }
            if( values.containsKey("ExpenseCost") ) {
                final Object value = values.remove("ExpenseCost");
                if( (value == null) || (!value.equals(getExpenseCost())) ) {
                    setExpenseCost(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkPackageName") ) {
                final Object value = values.remove("WorkPackageName");
                if( (value == null) || (!value.equals(getWorkPackageName())) ) {
                    setWorkPackageName(((String) value));
                }
            }
            if( values.containsKey("ExpenseRevenue") ) {
                final Object value = values.remove("ExpenseRevenue");
                if( (value == null) || (!value.equals(getExpenseRevenue())) ) {
                    setExpenseRevenue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ResType") ) {
                final Object value = values.remove("ResType");
                if( (value == null) || (!value.equals(getResType())) ) {
                    setResType(((String) value));
                }
            }
            if( values.containsKey("ResourceId") ) {
                final Object value = values.remove("ResourceId");
                if( (value == null) || (!value.equals(getResourceId())) ) {
                    setResourceId(((String) value));
                }
            }
            if( values.containsKey("Workitem") ) {
                final Object value = values.remove("Workitem");
                if( (value == null) || (!value.equals(getWorkitem())) ) {
                    setWorkitem(((String) value));
                }
            }
            if( values.containsKey("Effort") ) {
                final Object value = values.remove("Effort");
                if( (value == null) || (!value.equals(getEffort())) ) {
                    setEffort(((BigDecimal) value));
                }
            }
            if( values.containsKey("DelvryServOrg") ) {
                final Object value = values.remove("DelvryServOrg");
                if( (value == null) || (!value.equals(getDelvryServOrg())) ) {
                    setDelvryServOrg(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DemandField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DemandField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DemandField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DemandField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

}
