/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.EngmntProjRsceDmndField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceDmndLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceDmndOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.EngmntProjRsceDmndSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Demands
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EngmntProjRsceDmndType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EngmntProjRsceDmnd extends VdmEntity<EngmntProjRsceDmnd>
{

    /**
     * Selector for all available fields of EngmntProjRsceDmnd.
     *
     */
    public final static EngmntProjRsceDmndSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> WORK_PACKAGE =
        new EngmntProjRsceDmndField<String>("WorkPackage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @return Resource Demand ID
     */
    @Key
    @SerializedName( "ResourceDemand" )
    @JsonProperty( "ResourceDemand" )
    @Nullable
    @ODataField( odataName = "ResourceDemand" )
    private String resourceDemand;
    /**
     * Use with available fluent helpers to apply the <b>ResourceDemand</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> RESOURCE_DEMAND =
        new EngmntProjRsceDmndField<String>("ResourceDemand");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Plan Version ID
     */
    @Key
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> VERSION = new EngmntProjRsceDmndField<String>("Version");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProject</b>
     * </p>
     *
     * @return Engagement Project ID
     */
    @SerializedName( "EngagementProject" )
    @JsonProperty( "EngagementProject" )
    @Nullable
    @ODataField( odataName = "EngagementProject" )
    private String engagementProject;
    /**
     * Use with available fluent helpers to apply the <b>EngagementProject</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> ENGAGEMENT_PROJECT =
        new EngmntProjRsceDmndField<String>("EngagementProject");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @SerializedName( "WorkItem" )
    @JsonProperty( "WorkItem" )
    @Nullable
    @ODataField( odataName = "WorkItem" )
    private String workItem;
    /**
     * Use with available fluent helpers to apply the <b>WorkItem</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> WORK_ITEM = new EngmntProjRsceDmndField<String>("WorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @return Billing Control Category
     */
    @SerializedName( "BillingControlCategory" )
    @JsonProperty( "BillingControlCategory" )
    @Nullable
    @ODataField( odataName = "BillingControlCategory" )
    private String billingControlCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingControlCategory</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> BILLING_CONTROL_CATEGORY =
        new EngmntProjRsceDmndField<String>("BillingControlCategory");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryOrganization</b>
     * </p>
     *
     * @return Delivery Organization
     */
    @SerializedName( "DeliveryOrganization" )
    @JsonProperty( "DeliveryOrganization" )
    @Nullable
    @ODataField( odataName = "DeliveryOrganization" )
    private String deliveryOrganization;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryOrganization</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> DELIVERY_ORGANIZATION =
        new EngmntProjRsceDmndField<String>("DeliveryOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProjectResourceType</b>
     * </p>
     *
     * @return Resource Type ID
     */
    @SerializedName( "EngagementProjectResourceType" )
    @JsonProperty( "EngagementProjectResourceType" )
    @Nullable
    @ODataField( odataName = "EngagementProjectResourceType" )
    private String engagementProjectResourceType;
    /**
     * Use with available fluent helpers to apply the <b>EngagementProjectResourceType</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> ENGAGEMENT_PROJECT_RESOURCE_TYPE =
        new EngmntProjRsceDmndField<String>("EngagementProjectResourceType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProjectResource</b>
     * </p>
     *
     * @return Resource ID
     */
    @SerializedName( "EngagementProjectResource" )
    @JsonProperty( "EngagementProjectResource" )
    @Nullable
    @ODataField( odataName = "EngagementProjectResource" )
    private String engagementProjectResource;
    /**
     * Use with available fluent helpers to apply the <b>EngagementProjectResource</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> ENGAGEMENT_PROJECT_RESOURCE =
        new EngmntProjRsceDmndField<String>("EngagementProjectResource");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>WorkforcePersonUserID</b>
     * </p>
     *
     * @return User ID
     */
    @SerializedName( "WorkforcePersonUserID" )
    @JsonProperty( "WorkforcePersonUserID" )
    @Nullable
    @ODataField( odataName = "WorkforcePersonUserID" )
    private String workforcePersonUserID;
    /**
     * Use with available fluent helpers to apply the <b>WorkforcePersonUserID</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> WORKFORCE_PERSON_USER_ID =
        new EngmntProjRsceDmndField<String>("WorkforcePersonUserID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Country2DigitISOCode</b>
     * </p>
     *
     * @return Country/Region
     */
    @SerializedName( "Country2DigitISOCode" )
    @JsonProperty( "Country2DigitISOCode" )
    @Nullable
    @ODataField( odataName = "Country2DigitISOCode" )
    private String country2DigitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>Country2DigitISOCode</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> COUNTRY2_DIGIT_ISO_CODE =
        new EngmntProjRsceDmndField<String>("Country2DigitISOCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<LocalDateTime> KEY_DATE =
        new EngmntProjRsceDmndField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonWorkAgreement" )
    @JsonProperty( "PersonWorkAgreement" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreement" )
    private String personWorkAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreement</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> PERSON_WORK_AGREEMENT =
        new EngmntProjRsceDmndField<String>("PersonWorkAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemandStatus</b>
     * </p>
     *
     * @return Assignment Status for a Resource Demand
     */
    @SerializedName( "ResourceDemandStatus" )
    @JsonProperty( "ResourceDemandStatus" )
    @Nullable
    @ODataField( odataName = "ResourceDemandStatus" )
    private String resourceDemandStatus;
    /**
     * Use with available fluent helpers to apply the <b>ResourceDemandStatus</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> RESOURCE_DEMAND_STATUS =
        new EngmntProjRsceDmndField<String>("ResourceDemandStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> UNIT_OF_MEASURE =
        new EngmntProjRsceDmndField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return The quantity contained in this entity.
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<BigDecimal> QUANTITY =
        new EngmntProjRsceDmndField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Plan Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<String> CURRENCY = new EngmntProjRsceDmndField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandCostAmt</b>
     * </p>
     *
     * @return Demand Cost Amount
     */
    @SerializedName( "DemandCostAmt" )
    @JsonProperty( "DemandCostAmt" )
    @Nullable
    @ODataField( odataName = "DemandCostAmt" )
    private BigDecimal demandCostAmt;
    /**
     * Use with available fluent helpers to apply the <b>DemandCostAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<BigDecimal> DEMAND_COST_AMT =
        new EngmntProjRsceDmndField<BigDecimal>("DemandCostAmt");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandRevAmt</b>
     * </p>
     *
     * @return Demand Revenue Amount
     */
    @SerializedName( "DemandRevAmt" )
    @JsonProperty( "DemandRevAmt" )
    @Nullable
    @ODataField( odataName = "DemandRevAmt" )
    private BigDecimal demandRevAmt;
    /**
     * Use with available fluent helpers to apply the <b>DemandRevAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndField<BigDecimal> DEMAND_REV_AMT =
        new EngmntProjRsceDmndField<BigDecimal>("DemandRevAmt");
    /**
     * Navigation property <b>to_ResourceDemandDistribution</b> for <b>EngmntProjRsceDmnd</b> to multiple
     * <b>EngmntProjRsceDmndDistr</b>.
     *
     */
    @SerializedName( "to_ResourceDemandDistribution" )
    @JsonProperty( "to_ResourceDemandDistribution" )
    @ODataField( odataName = "to_ResourceDemandDistribution" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EngmntProjRsceDmndDistr> toResourceDemandDistribution;
    /**
     * Navigation property <b>to_ResourceDemandSkills</b> for <b>EngmntProjRsceDmnd</b> to single
     * <b>EngmntProjRsceDmndSkill</b>.
     *
     */
    @SerializedName( "to_ResourceDemandSkills" )
    @JsonProperty( "to_ResourceDemandSkills" )
    @ODataField( odataName = "to_ResourceDemandSkills" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EngmntProjRsceDmndSkill toResourceDemandSkills;
    /**
     * Navigation property <b>to_ResourceSupply</b> for <b>EngmntProjRsceDmnd</b> to multiple <b>EngmntProjRsceSup</b>.
     *
     */
    @SerializedName( "to_ResourceSupply" )
    @JsonProperty( "to_ResourceSupply" )
    @ODataField( odataName = "to_ResourceSupply" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EngmntProjRsceSup> toResourceSupply;
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceDemandDistribution</b> navigation property to query
     * operations.
     *
     */
    public final static EngmntProjRsceDmndLink<EngmntProjRsceDmndDistr> TO_RESOURCE_DEMAND_DISTRIBUTION =
        new EngmntProjRsceDmndLink<EngmntProjRsceDmndDistr>("to_ResourceDemandDistribution");
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceDemandSkills</b> navigation property to query
     * operations.
     *
     */
    public final static EngmntProjRsceDmndOneToOneLink<EngmntProjRsceDmndSkill> TO_RESOURCE_DEMAND_SKILLS =
        new EngmntProjRsceDmndOneToOneLink<EngmntProjRsceDmndSkill>("to_ResourceDemandSkills");
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceSupply</b> navigation property to query operations.
     *
     */
    public final static EngmntProjRsceDmndLink<EngmntProjRsceSup> TO_RESOURCE_SUPPLY =
        new EngmntProjRsceDmndLink<EngmntProjRsceSup>("to_ResourceSupply");

    @Nonnull
    @Override
    public Class<EngmntProjRsceDmnd> getType()
    {
        return EngmntProjRsceDmnd.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            Work Package ID
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @param resourceDemand
     *            Resource Demand ID
     */
    public void setResourceDemand( @Nullable final String resourceDemand )
    {
        rememberChangedField("ResourceDemand", this.resourceDemand);
        this.resourceDemand = resourceDemand;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Plan Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProject</b>
     * </p>
     *
     * @param engagementProject
     *            Engagement Project ID
     */
    public void setEngagementProject( @Nullable final String engagementProject )
    {
        rememberChangedField("EngagementProject", this.engagementProject);
        this.engagementProject = engagementProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkItem</b>
     * </p>
     *
     * @param workItem
     *            Work Item ID
     */
    public void setWorkItem( @Nullable final String workItem )
    {
        rememberChangedField("WorkItem", this.workItem);
        this.workItem = workItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @param billingControlCategory
     *            Billing Control Category
     */
    public void setBillingControlCategory( @Nullable final String billingControlCategory )
    {
        rememberChangedField("BillingControlCategory", this.billingControlCategory);
        this.billingControlCategory = billingControlCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryOrganization</b>
     * </p>
     *
     * @param deliveryOrganization
     *            Delivery Organization
     */
    public void setDeliveryOrganization( @Nullable final String deliveryOrganization )
    {
        rememberChangedField("DeliveryOrganization", this.deliveryOrganization);
        this.deliveryOrganization = deliveryOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProjectResourceType</b>
     * </p>
     *
     * @param engagementProjectResourceType
     *            Resource Type ID
     */
    public void setEngagementProjectResourceType( @Nullable final String engagementProjectResourceType )
    {
        rememberChangedField("EngagementProjectResourceType", this.engagementProjectResourceType);
        this.engagementProjectResourceType = engagementProjectResourceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProjectResource</b>
     * </p>
     *
     * @param engagementProjectResource
     *            Resource ID
     */
    public void setEngagementProjectResource( @Nullable final String engagementProjectResource )
    {
        rememberChangedField("EngagementProjectResource", this.engagementProjectResource);
        this.engagementProjectResource = engagementProjectResource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>WorkforcePersonUserID</b>
     * </p>
     *
     * @param workforcePersonUserID
     *            User ID
     */
    public void setWorkforcePersonUserID( @Nullable final String workforcePersonUserID )
    {
        rememberChangedField("WorkforcePersonUserID", this.workforcePersonUserID);
        this.workforcePersonUserID = workforcePersonUserID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Country2DigitISOCode</b>
     * </p>
     *
     * @param country2DigitISOCode
     *            Country/Region
     */
    public void setCountry2DigitISOCode( @Nullable final String country2DigitISOCode )
    {
        rememberChangedField("Country2DigitISOCode", this.country2DigitISOCode);
        this.country2DigitISOCode = country2DigitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @param personWorkAgreement
     *            Personnel Number
     */
    public void setPersonWorkAgreement( @Nullable final String personWorkAgreement )
    {
        rememberChangedField("PersonWorkAgreement", this.personWorkAgreement);
        this.personWorkAgreement = personWorkAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemandStatus</b>
     * </p>
     *
     * @param resourceDemandStatus
     *            Assignment Status for a Resource Demand
     */
    public void setResourceDemandStatus( @Nullable final String resourceDemandStatus )
    {
        rememberChangedField("ResourceDemandStatus", this.resourceDemandStatus);
        this.resourceDemandStatus = resourceDemandStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            The quantity to set.
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Plan Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandCostAmt</b>
     * </p>
     *
     * @param demandCostAmt
     *            Demand Cost Amount
     */
    public void setDemandCostAmt( @Nullable final BigDecimal demandCostAmt )
    {
        rememberChangedField("DemandCostAmt", this.demandCostAmt);
        this.demandCostAmt = demandCostAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandRevAmt</b>
     * </p>
     *
     * @param demandRevAmt
     *            Demand Revenue Amount
     */
    public void setDemandRevAmt( @Nullable final BigDecimal demandRevAmt )
    {
        rememberChangedField("DemandRevAmt", this.demandRevAmt);
        this.demandRevAmt = demandRevAmt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EngmntProjRsceDmnd";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkPackage", getWorkPackage());
        result.put("ResourceDemand", getResourceDemand());
        result.put("Version", getVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkPackage", getWorkPackage());
        values.put("ResourceDemand", getResourceDemand());
        values.put("Version", getVersion());
        values.put("EngagementProject", getEngagementProject());
        values.put("WorkItem", getWorkItem());
        values.put("BillingControlCategory", getBillingControlCategory());
        values.put("DeliveryOrganization", getDeliveryOrganization());
        values.put("EngagementProjectResourceType", getEngagementProjectResourceType());
        values.put("EngagementProjectResource", getEngagementProjectResource());
        values.put("WorkforcePersonUserID", getWorkforcePersonUserID());
        values.put("Country2DigitISOCode", getCountry2DigitISOCode());
        values.put("KeyDate", getKeyDate());
        values.put("PersonWorkAgreement", getPersonWorkAgreement());
        values.put("ResourceDemandStatus", getResourceDemandStatus());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("Quantity", getQuantity());
        values.put("Currency", getCurrency());
        values.put("DemandCostAmt", getDemandCostAmt());
        values.put("DemandRevAmt", getDemandRevAmt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("ResourceDemand") ) {
                final Object value = values.remove("ResourceDemand");
                if( (value == null) || (!value.equals(getResourceDemand())) ) {
                    setResourceDemand(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("EngagementProject") ) {
                final Object value = values.remove("EngagementProject");
                if( (value == null) || (!value.equals(getEngagementProject())) ) {
                    setEngagementProject(((String) value));
                }
            }
            if( values.containsKey("WorkItem") ) {
                final Object value = values.remove("WorkItem");
                if( (value == null) || (!value.equals(getWorkItem())) ) {
                    setWorkItem(((String) value));
                }
            }
            if( values.containsKey("BillingControlCategory") ) {
                final Object value = values.remove("BillingControlCategory");
                if( (value == null) || (!value.equals(getBillingControlCategory())) ) {
                    setBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("DeliveryOrganization") ) {
                final Object value = values.remove("DeliveryOrganization");
                if( (value == null) || (!value.equals(getDeliveryOrganization())) ) {
                    setDeliveryOrganization(((String) value));
                }
            }
            if( values.containsKey("EngagementProjectResourceType") ) {
                final Object value = values.remove("EngagementProjectResourceType");
                if( (value == null) || (!value.equals(getEngagementProjectResourceType())) ) {
                    setEngagementProjectResourceType(((String) value));
                }
            }
            if( values.containsKey("EngagementProjectResource") ) {
                final Object value = values.remove("EngagementProjectResource");
                if( (value == null) || (!value.equals(getEngagementProjectResource())) ) {
                    setEngagementProjectResource(((String) value));
                }
            }
            if( values.containsKey("WorkforcePersonUserID") ) {
                final Object value = values.remove("WorkforcePersonUserID");
                if( (value == null) || (!value.equals(getWorkforcePersonUserID())) ) {
                    setWorkforcePersonUserID(((String) value));
                }
            }
            if( values.containsKey("Country2DigitISOCode") ) {
                final Object value = values.remove("Country2DigitISOCode");
                if( (value == null) || (!value.equals(getCountry2DigitISOCode())) ) {
                    setCountry2DigitISOCode(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PersonWorkAgreement") ) {
                final Object value = values.remove("PersonWorkAgreement");
                if( (value == null) || (!value.equals(getPersonWorkAgreement())) ) {
                    setPersonWorkAgreement(((String) value));
                }
            }
            if( values.containsKey("ResourceDemandStatus") ) {
                final Object value = values.remove("ResourceDemandStatus");
                if( (value == null) || (!value.equals(getResourceDemandStatus())) ) {
                    setResourceDemandStatus(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("DemandCostAmt") ) {
                final Object value = values.remove("DemandCostAmt");
                if( (value == null) || (!value.equals(getDemandCostAmt())) ) {
                    setDemandCostAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("DemandRevAmt") ) {
                final Object value = values.remove("DemandRevAmt");
                if( (value == null) || (!value.equals(getDemandRevAmt())) ) {
                    setDemandRevAmt(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ResourceDemandDistribution") ) {
                final Object value = (values).remove("to_ResourceDemandDistribution");
                if( value instanceof Iterable ) {
                    if( toResourceDemandDistribution == null ) {
                        toResourceDemandDistribution = Lists.newArrayList();
                    } else {
                        toResourceDemandDistribution = Lists.newArrayList(toResourceDemandDistribution);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EngmntProjRsceDmndDistr entity;
                        if( toResourceDemandDistribution.size() > i ) {
                            entity = toResourceDemandDistribution.get(i);
                        } else {
                            entity = new EngmntProjRsceDmndDistr();
                            toResourceDemandDistribution.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ResourceDemandSkills") ) {
                final Object value = (values).remove("to_ResourceDemandSkills");
                if( value instanceof Map ) {
                    if( toResourceDemandSkills == null ) {
                        toResourceDemandSkills = new EngmntProjRsceDmndSkill();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toResourceDemandSkills.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ResourceSupply") ) {
                final Object value = (values).remove("to_ResourceSupply");
                if( value instanceof Iterable ) {
                    if( toResourceSupply == null ) {
                        toResourceSupply = Lists.newArrayList();
                    } else {
                        toResourceSupply = Lists.newArrayList(toResourceSupply);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EngmntProjRsceSup entity;
                        if( toResourceSupply.size() > i ) {
                            entity = toResourceSupply.get(i);
                        } else {
                            entity = new EngmntProjRsceSup();
                            toResourceSupply.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EngmntProjRsceDmndField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EngmntProjRsceDmndField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EngmntProjRsceDmndField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EngmntProjRsceDmndField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResourceDemandDistribution != null ) {
            (values).put("to_ResourceDemandDistribution", toResourceDemandDistribution);
        }
        if( toResourceDemandSkills != null ) {
            (values).put("to_ResourceDemandSkills", toResourceDemandSkills);
        }
        if( toResourceSupply != null ) {
            (values).put("to_ResourceSupply", toResourceSupply);
        }
        return values;
    }

    /**
     * Fetches the <b>EngmntProjRsceDmndDistr</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ResourceDemandDistribution</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EngmntProjRsceDmndDistr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceDmndDistr> fetchResourceDemandDistribution()
    {
        return fetchFieldAsList("to_ResourceDemandDistribution", EngmntProjRsceDmndDistr.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmndDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceDemandDistribution</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemandDistribution</b> of a queried <b>EngmntProjRsceDmnd</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceDmndDistr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceDmndDistr> getResourceDemandDistributionOrFetch()
    {
        if( toResourceDemandDistribution == null ) {
            toResourceDemandDistribution = fetchResourceDemandDistribution();
        }
        return toResourceDemandDistribution;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmndDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceDemandDistribution</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceDmnd</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceDemandDistribution</b> is already loaded, the
     *         result will contain the <b>EngmntProjRsceDmndDistr</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EngmntProjRsceDmndDistr>> getResourceDemandDistributionIfPresent()
    {
        return Option.of(toResourceDemandDistribution);
    }

    /**
     * Overwrites the list of associated <b>EngmntProjRsceDmndDistr</b> entities for the loaded navigation property
     * <b>to_ResourceDemandDistribution</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemandDistribution</b> of a queried <b>EngmntProjRsceDmnd</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EngmntProjRsceDmndDistr</b> entities.
     */
    public void setResourceDemandDistribution( @Nonnull final List<EngmntProjRsceDmndDistr> value )
    {
        if( toResourceDemandDistribution == null ) {
            toResourceDemandDistribution = Lists.newArrayList();
        }
        toResourceDemandDistribution.clear();
        toResourceDemandDistribution.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EngmntProjRsceDmndDistr</b> entities. This corresponds to the OData
     * navigation property <b>to_ResourceDemandDistribution</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemandDistribution</b> of a queried <b>EngmntProjRsceDmnd</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EngmntProjRsceDmndDistr</b> entities.
     */
    public void addResourceDemandDistribution( EngmntProjRsceDmndDistr... entity )
    {
        if( toResourceDemandDistribution == null ) {
            toResourceDemandDistribution = Lists.newArrayList();
        }
        toResourceDemandDistribution.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EngmntProjRsceDmndSkill</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ResourceDemandSkills</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EngmntProjRsceDmndSkill</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceDmndSkill fetchResourceDemandSkills()
    {
        return fetchFieldAsSingle("to_ResourceDemandSkills", EngmntProjRsceDmndSkill.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmndSkill</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ResourceDemandSkills</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemandSkills</b> of a queried <b>EngmntProjRsceDmnd</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceDmndSkill</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceDmndSkill getResourceDemandSkillsOrFetch()
    {
        if( toResourceDemandSkills == null ) {
            toResourceDemandSkills = fetchResourceDemandSkills();
        }
        return toResourceDemandSkills;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmndSkill</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ResourceDemandSkills</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceDmnd</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceDemandSkills</b> is already loaded, the result
     *         will contain the <b>EngmntProjRsceDmndSkill</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EngmntProjRsceDmndSkill> getResourceDemandSkillsIfPresent()
    {
        return Option.of(toResourceDemandSkills);
    }

    /**
     * Overwrites the associated <b>EngmntProjRsceDmndSkill</b> entity for the loaded navigation property
     * <b>to_ResourceDemandSkills</b>.
     *
     * @param value
     *            New <b>EngmntProjRsceDmndSkill</b> entity.
     */
    public void setResourceDemandSkills( final EngmntProjRsceDmndSkill value )
    {
        toResourceDemandSkills = value;
    }

    /**
     * Fetches the <b>EngmntProjRsceSup</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ResourceSupply</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EngmntProjRsceSup</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceSup> fetchResourceSupply()
    {
        return fetchFieldAsList("to_ResourceSupply", EngmntProjRsceSup.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceSup</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ResourceSupply</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupply</b> of a queried <b>EngmntProjRsceDmnd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceSup</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceSup> getResourceSupplyOrFetch()
    {
        if( toResourceSupply == null ) {
            toResourceSupply = fetchResourceSupply();
        }
        return toResourceSupply;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceSup</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ResourceSupply</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceDmnd</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceSupply</b> is already loaded, the result will
     *         contain the <b>EngmntProjRsceSup</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EngmntProjRsceSup>> getResourceSupplyIfPresent()
    {
        return Option.of(toResourceSupply);
    }

    /**
     * Overwrites the list of associated <b>EngmntProjRsceSup</b> entities for the loaded navigation property
     * <b>to_ResourceSupply</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupply</b> of a queried <b>EngmntProjRsceDmnd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EngmntProjRsceSup</b> entities.
     */
    public void setResourceSupply( @Nonnull final List<EngmntProjRsceSup> value )
    {
        if( toResourceSupply == null ) {
            toResourceSupply = Lists.newArrayList();
        }
        toResourceSupply.clear();
        toResourceSupply.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EngmntProjRsceSup</b> entities. This corresponds to the OData
     * navigation property <b>to_ResourceSupply</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupply</b> of a queried <b>EngmntProjRsceDmnd</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EngmntProjRsceSup</b> entities.
     */
    public void addResourceSupply( EngmntProjRsceSup... entity )
    {
        if( toResourceSupply == null ) {
            toResourceSupply = Lists.newArrayList();
        }
        toResourceSupply.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EngmntProjRsceDmnd instances.
     *
     */
    public final static class EngmntProjRsceDmndBuilder
    {

        private List<EngmntProjRsceDmndDistr> toResourceDemandDistribution = Lists.newArrayList();
        private EngmntProjRsceDmndSkill toResourceDemandSkills;
        private List<EngmntProjRsceSup> toResourceSupply = Lists.newArrayList();

        private EngmntProjRsceDmnd.EngmntProjRsceDmndBuilder toResourceDemandDistribution(
            final List<EngmntProjRsceDmndDistr> value )
        {
            toResourceDemandDistribution.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ResourceDemandDistribution</b> for <b>EngmntProjRsceDmnd</b> to multiple
         * <b>EngmntProjRsceDmndDistr</b>.
         *
         * @param value
         *            The EngmntProjRsceDmndDistrs to build this EngmntProjRsceDmnd with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceDmnd.EngmntProjRsceDmndBuilder resourceDemandDistribution(
            EngmntProjRsceDmndDistr... value )
        {
            return toResourceDemandDistribution(Lists.newArrayList(value));
        }

        private EngmntProjRsceDmnd.EngmntProjRsceDmndBuilder toResourceDemandSkills(
            final EngmntProjRsceDmndSkill value )
        {
            toResourceDemandSkills = value;
            return this;
        }

        /**
         * Navigation property <b>to_ResourceDemandSkills</b> for <b>EngmntProjRsceDmnd</b> to single
         * <b>EngmntProjRsceDmndSkill</b>.
         *
         * @param value
         *            The EngmntProjRsceDmndSkill to build this EngmntProjRsceDmnd with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceDmnd.EngmntProjRsceDmndBuilder resourceDemandSkills( final EngmntProjRsceDmndSkill value )
        {
            return toResourceDemandSkills(value);
        }

        private EngmntProjRsceDmnd.EngmntProjRsceDmndBuilder toResourceSupply( final List<EngmntProjRsceSup> value )
        {
            toResourceSupply.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ResourceSupply</b> for <b>EngmntProjRsceDmnd</b> to multiple
         * <b>EngmntProjRsceSup</b>.
         *
         * @param value
         *            The EngmntProjRsceSups to build this EngmntProjRsceDmnd with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceDmnd.EngmntProjRsceDmndBuilder resourceSupply( EngmntProjRsceSup... value )
        {
            return toResourceSupply(Lists.newArrayList(value));
        }

    }

}
