/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.EngmntProjRsceDmndDistrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceDmndDistrOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.EngmntProjRsceDmndDistrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Demand Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EngmntProjRsceDmndDistrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EngmntProjRsceDmndDistr extends VdmEntity<EngmntProjRsceDmndDistr>
{

    /**
     * Selector for all available fields of EngmntProjRsceDmndDistr.
     *
     */
    public final static EngmntProjRsceDmndDistrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> WORK_PACKAGE =
        new EngmntProjRsceDmndDistrField<String>("WorkPackage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @return Resource Demand ID
     */
    @Key
    @SerializedName( "ResourceDemand" )
    @JsonProperty( "ResourceDemand" )
    @Nullable
    @ODataField( odataName = "ResourceDemand" )
    private String resourceDemand;
    /**
     * Use with available fluent helpers to apply the <b>ResourceDemand</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> RESOURCE_DEMAND =
        new EngmntProjRsceDmndDistrField<String>("ResourceDemand");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Plan Version ID
     */
    @Key
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> VERSION =
        new EngmntProjRsceDmndDistrField<String>("Version");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @return Calendar Month
     */
    @Key
    @SerializedName( "CalendarMonth" )
    @JsonProperty( "CalendarMonth" )
    @Nullable
    @ODataField( odataName = "CalendarMonth" )
    private String calendarMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonth</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> CALENDAR_MONTH =
        new EngmntProjRsceDmndDistrField<String>("CalendarMonth");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @return Calendar Year
     */
    @Key
    @SerializedName( "CalendarYear" )
    @JsonProperty( "CalendarYear" )
    @Nullable
    @ODataField( odataName = "CalendarYear" )
    private String calendarYear;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYear</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> CALENDAR_YEAR =
        new EngmntProjRsceDmndDistrField<String>("CalendarYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> UNIT_OF_MEASURE =
        new EngmntProjRsceDmndDistrField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Total Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<BigDecimal> QUANTITY =
        new EngmntProjRsceDmndDistrField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Plan Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<String> CURRENCY =
        new EngmntProjRsceDmndDistrField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandCostAmt</b>
     * </p>
     *
     * @return Demand Cost Amount
     */
    @SerializedName( "DemandCostAmt" )
    @JsonProperty( "DemandCostAmt" )
    @Nullable
    @ODataField( odataName = "DemandCostAmt" )
    private BigDecimal demandCostAmt;
    /**
     * Use with available fluent helpers to apply the <b>DemandCostAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<BigDecimal> DEMAND_COST_AMT =
        new EngmntProjRsceDmndDistrField<BigDecimal>("DemandCostAmt");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandRevAmt</b>
     * </p>
     *
     * @return Demand Revenue Amount
     */
    @SerializedName( "DemandRevAmt" )
    @JsonProperty( "DemandRevAmt" )
    @Nullable
    @ODataField( odataName = "DemandRevAmt" )
    private BigDecimal demandRevAmt;
    /**
     * Use with available fluent helpers to apply the <b>DemandRevAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrField<BigDecimal> DEMAND_REV_AMT =
        new EngmntProjRsceDmndDistrField<BigDecimal>("DemandRevAmt");
    /**
     * Navigation property <b>to_ResourceDemand</b> for <b>EngmntProjRsceDmndDistr</b> to single
     * <b>EngmntProjRsceDmnd</b>.
     *
     */
    @SerializedName( "to_ResourceDemand" )
    @JsonProperty( "to_ResourceDemand" )
    @ODataField( odataName = "to_ResourceDemand" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EngmntProjRsceDmnd toResourceDemand;
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceDemand</b> navigation property to query operations.
     *
     */
    public final static EngmntProjRsceDmndDistrOneToOneLink<EngmntProjRsceDmnd> TO_RESOURCE_DEMAND =
        new EngmntProjRsceDmndDistrOneToOneLink<EngmntProjRsceDmnd>("to_ResourceDemand");

    @Nonnull
    @Override
    public Class<EngmntProjRsceDmndDistr> getType()
    {
        return EngmntProjRsceDmndDistr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            Work Package ID
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @param resourceDemand
     *            Resource Demand ID
     */
    public void setResourceDemand( @Nullable final String resourceDemand )
    {
        rememberChangedField("ResourceDemand", this.resourceDemand);
        this.resourceDemand = resourceDemand;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Plan Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @param calendarMonth
     *            Calendar Month
     */
    public void setCalendarMonth( @Nullable final String calendarMonth )
    {
        rememberChangedField("CalendarMonth", this.calendarMonth);
        this.calendarMonth = calendarMonth;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @param calendarYear
     *            Calendar Year
     */
    public void setCalendarYear( @Nullable final String calendarYear )
    {
        rememberChangedField("CalendarYear", this.calendarYear);
        this.calendarYear = calendarYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Total Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Plan Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandCostAmt</b>
     * </p>
     *
     * @param demandCostAmt
     *            Demand Cost Amount
     */
    public void setDemandCostAmt( @Nullable final BigDecimal demandCostAmt )
    {
        rememberChangedField("DemandCostAmt", this.demandCostAmt);
        this.demandCostAmt = demandCostAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DemandRevAmt</b>
     * </p>
     *
     * @param demandRevAmt
     *            Demand Revenue Amount
     */
    public void setDemandRevAmt( @Nullable final BigDecimal demandRevAmt )
    {
        rememberChangedField("DemandRevAmt", this.demandRevAmt);
        this.demandRevAmt = demandRevAmt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EngmntProjRsceDmndDistr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkPackage", getWorkPackage());
        result.put("ResourceDemand", getResourceDemand());
        result.put("Version", getVersion());
        result.put("CalendarMonth", getCalendarMonth());
        result.put("CalendarYear", getCalendarYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkPackage", getWorkPackage());
        values.put("ResourceDemand", getResourceDemand());
        values.put("Version", getVersion());
        values.put("CalendarMonth", getCalendarMonth());
        values.put("CalendarYear", getCalendarYear());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("Quantity", getQuantity());
        values.put("Currency", getCurrency());
        values.put("DemandCostAmt", getDemandCostAmt());
        values.put("DemandRevAmt", getDemandRevAmt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("ResourceDemand") ) {
                final Object value = values.remove("ResourceDemand");
                if( (value == null) || (!value.equals(getResourceDemand())) ) {
                    setResourceDemand(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("CalendarMonth") ) {
                final Object value = values.remove("CalendarMonth");
                if( (value == null) || (!value.equals(getCalendarMonth())) ) {
                    setCalendarMonth(((String) value));
                }
            }
            if( values.containsKey("CalendarYear") ) {
                final Object value = values.remove("CalendarYear");
                if( (value == null) || (!value.equals(getCalendarYear())) ) {
                    setCalendarYear(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("DemandCostAmt") ) {
                final Object value = values.remove("DemandCostAmt");
                if( (value == null) || (!value.equals(getDemandCostAmt())) ) {
                    setDemandCostAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("DemandRevAmt") ) {
                final Object value = values.remove("DemandRevAmt");
                if( (value == null) || (!value.equals(getDemandRevAmt())) ) {
                    setDemandRevAmt(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ResourceDemand") ) {
                final Object value = (values).remove("to_ResourceDemand");
                if( value instanceof Map ) {
                    if( toResourceDemand == null ) {
                        toResourceDemand = new EngmntProjRsceDmnd();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toResourceDemand.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EngmntProjRsceDmndDistrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EngmntProjRsceDmndDistrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EngmntProjRsceDmndDistrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EngmntProjRsceDmndDistrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResourceDemand != null ) {
            (values).put("to_ResourceDemand", toResourceDemand);
        }
        return values;
    }

    /**
     * Fetches the <b>EngmntProjRsceDmnd</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ResourceDemand</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EngmntProjRsceDmnd</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceDmnd fetchResourceDemand()
    {
        return fetchFieldAsSingle("to_ResourceDemand", EngmntProjRsceDmnd.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmnd</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemand</b> of a queried <b>EngmntProjRsceDmndDistr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceDmnd</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceDmnd getResourceDemandOrFetch()
    {
        if( toResourceDemand == null ) {
            toResourceDemand = fetchResourceDemand();
        }
        return toResourceDemand;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmnd</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceDmndDistr</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceDemand</b> is already loaded, the result will
     *         contain the <b>EngmntProjRsceDmnd</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EngmntProjRsceDmnd> getResourceDemandIfPresent()
    {
        return Option.of(toResourceDemand);
    }

    /**
     * Overwrites the associated <b>EngmntProjRsceDmnd</b> entity for the loaded navigation property
     * <b>to_ResourceDemand</b>.
     *
     * @param value
     *            New <b>EngmntProjRsceDmnd</b> entity.
     */
    public void setResourceDemand( final EngmntProjRsceDmnd value )
    {
        toResourceDemand = value;
    }

    /**
     * Helper class to allow for fluent creation of EngmntProjRsceDmndDistr instances.
     *
     */
    public final static class EngmntProjRsceDmndDistrBuilder
    {

        private EngmntProjRsceDmnd toResourceDemand;
        private String resourceDemand = null;

        private EngmntProjRsceDmndDistr.EngmntProjRsceDmndDistrBuilder toResourceDemand(
            final EngmntProjRsceDmnd value )
        {
            toResourceDemand = value;
            return this;
        }

        /**
         * Navigation property <b>to_ResourceDemand</b> for <b>EngmntProjRsceDmndDistr</b> to single
         * <b>EngmntProjRsceDmnd</b>.
         *
         * @param value
         *            The EngmntProjRsceDmnd to build this EngmntProjRsceDmndDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceDmndDistr.EngmntProjRsceDmndDistrBuilder resourceDemand( final EngmntProjRsceDmnd value )
        {
            return toResourceDemand(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 24
         * <p>
         * Original property name from the Odata EDM: <b>ResourceDemand</b>
         * </p>
         *
         * @param value
         *            The resourceDemand to build this EngmntProjRsceDmndDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceDmndDistr.EngmntProjRsceDmndDistrBuilder resourceDemand( final String value )
        {
            resourceDemand = value;
            return this;
        }

    }

}
