/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.EngmntProjRsceDmndDistrSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
 * EngmntProjRsceDmndDistr} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class EngmntProjRsceDmndDistrByKeyFluentHelper
    extends
    FluentHelperByKey<EngmntProjRsceDmndDistrByKeyFluentHelper, EngmntProjRsceDmndDistr, EngmntProjRsceDmndDistrSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EngmntProjRsceDmndDistr}
     * @param calendarMonth
     *            Calendar Month
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param resourceDemand
     *            Resource Demand ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 24
     *            </p>
     * @param calendarYear
     *            Calendar Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code EngmntProjRsceDmndDistr}
     * @param workPackage
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param version
     *            Plan Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     */
    public EngmntProjRsceDmndDistrByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String workPackage,
        final String resourceDemand,
        final String version,
        final String calendarMonth,
        final String calendarYear )
    {
        super(servicePath, entityCollection);
        this.key.put("WorkPackage", workPackage);
        this.key.put("ResourceDemand", resourceDemand);
        this.key.put("Version", version);
        this.key.put("CalendarMonth", calendarMonth);
        this.key.put("CalendarYear", calendarYear);
    }

    @Override
    @Nonnull
    protected Class<EngmntProjRsceDmndDistr> getEntityClass()
    {
        return EngmntProjRsceDmndDistr.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
