/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.EngmntProjRsceDmndSkillField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.EngmntProjRsceDmndSkillSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Resource Demand Skills
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EngmntProjRsceDmndSkillType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EngmntProjRsceDmndSkill extends VdmEntity<EngmntProjRsceDmndSkill>
{

    /**
     * Selector for all available fields of EngmntProjRsceDmndSkill.
     *
     */
    public final static EngmntProjRsceDmndSkillSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndSkillField<String> WORK_PACKAGE =
        new EngmntProjRsceDmndSkillField<String>("WorkPackage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @return Resource Demand ID
     */
    @Key
    @SerializedName( "ResourceDemand" )
    @JsonProperty( "ResourceDemand" )
    @Nullable
    @ODataField( odataName = "ResourceDemand" )
    private String resourceDemand;
    /**
     * Use with available fluent helpers to apply the <b>ResourceDemand</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndSkillField<String> RESOURCE_DEMAND =
        new EngmntProjRsceDmndSkillField<String>("ResourceDemand");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Plan Version ID
     */
    @Key
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndSkillField<String> VERSION =
        new EngmntProjRsceDmndSkillField<String>("Version");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SkillTagDescription</b>
     * </p>
     *
     * @return Skill Tag Description
     */
    @SerializedName( "SkillTagDescription" )
    @JsonProperty( "SkillTagDescription" )
    @Nullable
    @ODataField( odataName = "SkillTagDescription" )
    private String skillTagDescription;
    /**
     * Use with available fluent helpers to apply the <b>SkillTagDescription</b> field to query operations.
     *
     */
    public final static EngmntProjRsceDmndSkillField<String> SKILL_TAG_DESCRIPTION =
        new EngmntProjRsceDmndSkillField<String>("SkillTagDescription");

    @Nonnull
    @Override
    public Class<EngmntProjRsceDmndSkill> getType()
    {
        return EngmntProjRsceDmndSkill.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            Work Package ID
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @param resourceDemand
     *            Resource Demand ID
     */
    public void setResourceDemand( @Nullable final String resourceDemand )
    {
        rememberChangedField("ResourceDemand", this.resourceDemand);
        this.resourceDemand = resourceDemand;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Plan Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SkillTagDescription</b>
     * </p>
     *
     * @param skillTagDescription
     *            Skill Tag Description
     */
    public void setSkillTagDescription( @Nullable final String skillTagDescription )
    {
        rememberChangedField("SkillTagDescription", this.skillTagDescription);
        this.skillTagDescription = skillTagDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EngmntProjRsceDmndSkill";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkPackage", getWorkPackage());
        result.put("ResourceDemand", getResourceDemand());
        result.put("Version", getVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkPackage", getWorkPackage());
        values.put("ResourceDemand", getResourceDemand());
        values.put("Version", getVersion());
        values.put("SkillTagDescription", getSkillTagDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("ResourceDemand") ) {
                final Object value = values.remove("ResourceDemand");
                if( (value == null) || (!value.equals(getResourceDemand())) ) {
                    setResourceDemand(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("SkillTagDescription") ) {
                final Object value = values.remove("SkillTagDescription");
                if( (value == null) || (!value.equals(getSkillTagDescription())) ) {
                    setSkillTagDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EngmntProjRsceDmndSkillField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EngmntProjRsceDmndSkillField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EngmntProjRsceDmndSkillField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EngmntProjRsceDmndSkillField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

}
