/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.EngmntProjRsceSupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceSupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceSupOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.EngmntProjRsceSupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Supplies
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EngmntProjRsceSupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EngmntProjRsceSup extends VdmEntity<EngmntProjRsceSup>
{

    /**
     * Selector for all available fields of EngmntProjRsceSup.
     *
     */
    public final static EngmntProjRsceSupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> WORK_PACKAGE = new EngmntProjRsceSupField<String>("WorkPackage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @return Resource Demand ID
     */
    @Key
    @SerializedName( "ResourceDemand" )
    @JsonProperty( "ResourceDemand" )
    @Nullable
    @ODataField( odataName = "ResourceDemand" )
    private String resourceDemand;
    /**
     * Use with available fluent helpers to apply the <b>ResourceDemand</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> RESOURCE_DEMAND =
        new EngmntProjRsceSupField<String>("ResourceDemand");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceSupply</b>
     * </p>
     *
     * @return Resource Supply ID
     */
    @Key
    @SerializedName( "ResourceSupply" )
    @JsonProperty( "ResourceSupply" )
    @Nullable
    @ODataField( odataName = "ResourceSupply" )
    private String resourceSupply;
    /**
     * Use with available fluent helpers to apply the <b>ResourceSupply</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> RESOURCE_SUPPLY =
        new EngmntProjRsceSupField<String>("ResourceSupply");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Plan Version ID
     */
    @Key
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> VERSION = new EngmntProjRsceSupField<String>("Version");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProject</b>
     * </p>
     *
     * @return Engagement Project ID
     */
    @SerializedName( "EngagementProject" )
    @JsonProperty( "EngagementProject" )
    @Nullable
    @ODataField( odataName = "EngagementProject" )
    private String engagementProject;
    /**
     * Use with available fluent helpers to apply the <b>EngagementProject</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> ENGAGEMENT_PROJECT =
        new EngmntProjRsceSupField<String>("EngagementProject");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryOrganization</b>
     * </p>
     *
     * @return Delivery Organization
     */
    @SerializedName( "DeliveryOrganization" )
    @JsonProperty( "DeliveryOrganization" )
    @Nullable
    @ODataField( odataName = "DeliveryOrganization" )
    private String deliveryOrganization;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryOrganization</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> DELIVERY_ORGANIZATION =
        new EngmntProjRsceSupField<String>("DeliveryOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>WorkforcePersonUserID</b>
     * </p>
     *
     * @return User ID
     */
    @SerializedName( "WorkforcePersonUserID" )
    @JsonProperty( "WorkforcePersonUserID" )
    @Nullable
    @ODataField( odataName = "WorkforcePersonUserID" )
    private String workforcePersonUserID;
    /**
     * Use with available fluent helpers to apply the <b>WorkforcePersonUserID</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> WORKFORCE_PERSON_USER_ID =
        new EngmntProjRsceSupField<String>("WorkforcePersonUserID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Country2DigitISOCode</b>
     * </p>
     *
     * @return Country/Region
     */
    @SerializedName( "Country2DigitISOCode" )
    @JsonProperty( "Country2DigitISOCode" )
    @Nullable
    @ODataField( odataName = "Country2DigitISOCode" )
    private String country2DigitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>Country2DigitISOCode</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> COUNTRY2_DIGIT_ISO_CODE =
        new EngmntProjRsceSupField<String>("Country2DigitISOCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return Date
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<LocalDateTime> KEY_DATE =
        new EngmntProjRsceSupField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonWorkAgreement" )
    @JsonProperty( "PersonWorkAgreement" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreement" )
    private String personWorkAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreement</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> PERSON_WORK_AGREEMENT =
        new EngmntProjRsceSupField<String>("PersonWorkAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> UNIT_OF_MEASURE =
        new EngmntProjRsceSupField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Plan Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<String> CURRENCY = new EngmntProjRsceSupField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return The quantity contained in this entity.
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<BigDecimal> QUANTITY =
        new EngmntProjRsceSupField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyCostAmt</b>
     * </p>
     *
     * @return Supply Cost Amount
     */
    @SerializedName( "SupplyCostAmt" )
    @JsonProperty( "SupplyCostAmt" )
    @Nullable
    @ODataField( odataName = "SupplyCostAmt" )
    private BigDecimal supplyCostAmt;
    /**
     * Use with available fluent helpers to apply the <b>SupplyCostAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<BigDecimal> SUPPLY_COST_AMT =
        new EngmntProjRsceSupField<BigDecimal>("SupplyCostAmt");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyRevnAmt</b>
     * </p>
     *
     * @return Supply Revenue Amount
     */
    @SerializedName( "SupplyRevnAmt" )
    @JsonProperty( "SupplyRevnAmt" )
    @Nullable
    @ODataField( odataName = "SupplyRevnAmt" )
    private BigDecimal supplyRevnAmt;
    /**
     * Use with available fluent helpers to apply the <b>SupplyRevnAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupField<BigDecimal> SUPPLY_REVN_AMT =
        new EngmntProjRsceSupField<BigDecimal>("SupplyRevnAmt");
    /**
     * Navigation property <b>to_ResourceDemand</b> for <b>EngmntProjRsceSup</b> to single <b>EngmntProjRsceDmnd</b>.
     *
     */
    @SerializedName( "to_ResourceDemand" )
    @JsonProperty( "to_ResourceDemand" )
    @ODataField( odataName = "to_ResourceDemand" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EngmntProjRsceDmnd toResourceDemand;
    /**
     * Navigation property <b>to_ResourceSupplyDistribution</b> for <b>EngmntProjRsceSup</b> to multiple
     * <b>EngmntProjRsceSupDistr</b>.
     *
     */
    @SerializedName( "to_ResourceSupplyDistribution" )
    @JsonProperty( "to_ResourceSupplyDistribution" )
    @ODataField( odataName = "to_ResourceSupplyDistribution" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EngmntProjRsceSupDistr> toResourceSupplyDistribution;
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceDemand</b> navigation property to query operations.
     *
     */
    public final static EngmntProjRsceSupOneToOneLink<EngmntProjRsceDmnd> TO_RESOURCE_DEMAND =
        new EngmntProjRsceSupOneToOneLink<EngmntProjRsceDmnd>("to_ResourceDemand");
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceSupplyDistribution</b> navigation property to query
     * operations.
     *
     */
    public final static EngmntProjRsceSupLink<EngmntProjRsceSupDistr> TO_RESOURCE_SUPPLY_DISTRIBUTION =
        new EngmntProjRsceSupLink<EngmntProjRsceSupDistr>("to_ResourceSupplyDistribution");

    @Nonnull
    @Override
    public Class<EngmntProjRsceSup> getType()
    {
        return EngmntProjRsceSup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            Work Package ID
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @param resourceDemand
     *            Resource Demand ID
     */
    public void setResourceDemand( @Nullable final String resourceDemand )
    {
        rememberChangedField("ResourceDemand", this.resourceDemand);
        this.resourceDemand = resourceDemand;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceSupply</b>
     * </p>
     *
     * @param resourceSupply
     *            Resource Supply ID
     */
    public void setResourceSupply( @Nullable final String resourceSupply )
    {
        rememberChangedField("ResourceSupply", this.resourceSupply);
        this.resourceSupply = resourceSupply;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Plan Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EngagementProject</b>
     * </p>
     *
     * @param engagementProject
     *            Engagement Project ID
     */
    public void setEngagementProject( @Nullable final String engagementProject )
    {
        rememberChangedField("EngagementProject", this.engagementProject);
        this.engagementProject = engagementProject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryOrganization</b>
     * </p>
     *
     * @param deliveryOrganization
     *            Delivery Organization
     */
    public void setDeliveryOrganization( @Nullable final String deliveryOrganization )
    {
        rememberChangedField("DeliveryOrganization", this.deliveryOrganization);
        this.deliveryOrganization = deliveryOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>WorkforcePersonUserID</b>
     * </p>
     *
     * @param workforcePersonUserID
     *            User ID
     */
    public void setWorkforcePersonUserID( @Nullable final String workforcePersonUserID )
    {
        rememberChangedField("WorkforcePersonUserID", this.workforcePersonUserID);
        this.workforcePersonUserID = workforcePersonUserID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Country2DigitISOCode</b>
     * </p>
     *
     * @param country2DigitISOCode
     *            Country/Region
     */
    public void setCountry2DigitISOCode( @Nullable final String country2DigitISOCode )
    {
        rememberChangedField("Country2DigitISOCode", this.country2DigitISOCode);
        this.country2DigitISOCode = country2DigitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            Date
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @param personWorkAgreement
     *            Personnel Number
     */
    public void setPersonWorkAgreement( @Nullable final String personWorkAgreement )
    {
        rememberChangedField("PersonWorkAgreement", this.personWorkAgreement);
        this.personWorkAgreement = personWorkAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Plan Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            The quantity to set.
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyCostAmt</b>
     * </p>
     *
     * @param supplyCostAmt
     *            Supply Cost Amount
     */
    public void setSupplyCostAmt( @Nullable final BigDecimal supplyCostAmt )
    {
        rememberChangedField("SupplyCostAmt", this.supplyCostAmt);
        this.supplyCostAmt = supplyCostAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyRevnAmt</b>
     * </p>
     *
     * @param supplyRevnAmt
     *            Supply Revenue Amount
     */
    public void setSupplyRevnAmt( @Nullable final BigDecimal supplyRevnAmt )
    {
        rememberChangedField("SupplyRevnAmt", this.supplyRevnAmt);
        this.supplyRevnAmt = supplyRevnAmt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EngmntProjRsceSup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkPackage", getWorkPackage());
        result.put("ResourceDemand", getResourceDemand());
        result.put("ResourceSupply", getResourceSupply());
        result.put("Version", getVersion());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkPackage", getWorkPackage());
        values.put("ResourceDemand", getResourceDemand());
        values.put("ResourceSupply", getResourceSupply());
        values.put("Version", getVersion());
        values.put("EngagementProject", getEngagementProject());
        values.put("DeliveryOrganization", getDeliveryOrganization());
        values.put("WorkforcePersonUserID", getWorkforcePersonUserID());
        values.put("Country2DigitISOCode", getCountry2DigitISOCode());
        values.put("KeyDate", getKeyDate());
        values.put("PersonWorkAgreement", getPersonWorkAgreement());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("Currency", getCurrency());
        values.put("Quantity", getQuantity());
        values.put("SupplyCostAmt", getSupplyCostAmt());
        values.put("SupplyRevnAmt", getSupplyRevnAmt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("ResourceDemand") ) {
                final Object value = values.remove("ResourceDemand");
                if( (value == null) || (!value.equals(getResourceDemand())) ) {
                    setResourceDemand(((String) value));
                }
            }
            if( values.containsKey("ResourceSupply") ) {
                final Object value = values.remove("ResourceSupply");
                if( (value == null) || (!value.equals(getResourceSupply())) ) {
                    setResourceSupply(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("EngagementProject") ) {
                final Object value = values.remove("EngagementProject");
                if( (value == null) || (!value.equals(getEngagementProject())) ) {
                    setEngagementProject(((String) value));
                }
            }
            if( values.containsKey("DeliveryOrganization") ) {
                final Object value = values.remove("DeliveryOrganization");
                if( (value == null) || (!value.equals(getDeliveryOrganization())) ) {
                    setDeliveryOrganization(((String) value));
                }
            }
            if( values.containsKey("WorkforcePersonUserID") ) {
                final Object value = values.remove("WorkforcePersonUserID");
                if( (value == null) || (!value.equals(getWorkforcePersonUserID())) ) {
                    setWorkforcePersonUserID(((String) value));
                }
            }
            if( values.containsKey("Country2DigitISOCode") ) {
                final Object value = values.remove("Country2DigitISOCode");
                if( (value == null) || (!value.equals(getCountry2DigitISOCode())) ) {
                    setCountry2DigitISOCode(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PersonWorkAgreement") ) {
                final Object value = values.remove("PersonWorkAgreement");
                if( (value == null) || (!value.equals(getPersonWorkAgreement())) ) {
                    setPersonWorkAgreement(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplyCostAmt") ) {
                final Object value = values.remove("SupplyCostAmt");
                if( (value == null) || (!value.equals(getSupplyCostAmt())) ) {
                    setSupplyCostAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplyRevnAmt") ) {
                final Object value = values.remove("SupplyRevnAmt");
                if( (value == null) || (!value.equals(getSupplyRevnAmt())) ) {
                    setSupplyRevnAmt(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ResourceDemand") ) {
                final Object value = (values).remove("to_ResourceDemand");
                if( value instanceof Map ) {
                    if( toResourceDemand == null ) {
                        toResourceDemand = new EngmntProjRsceDmnd();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toResourceDemand.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ResourceSupplyDistribution") ) {
                final Object value = (values).remove("to_ResourceSupplyDistribution");
                if( value instanceof Iterable ) {
                    if( toResourceSupplyDistribution == null ) {
                        toResourceSupplyDistribution = Lists.newArrayList();
                    } else {
                        toResourceSupplyDistribution = Lists.newArrayList(toResourceSupplyDistribution);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EngmntProjRsceSupDistr entity;
                        if( toResourceSupplyDistribution.size() > i ) {
                            entity = toResourceSupplyDistribution.get(i);
                        } else {
                            entity = new EngmntProjRsceSupDistr();
                            toResourceSupplyDistribution.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EngmntProjRsceSupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EngmntProjRsceSupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EngmntProjRsceSupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EngmntProjRsceSupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResourceDemand != null ) {
            (values).put("to_ResourceDemand", toResourceDemand);
        }
        if( toResourceSupplyDistribution != null ) {
            (values).put("to_ResourceSupplyDistribution", toResourceSupplyDistribution);
        }
        return values;
    }

    /**
     * Fetches the <b>EngmntProjRsceDmnd</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ResourceDemand</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EngmntProjRsceDmnd</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceDmnd fetchResourceDemand()
    {
        return fetchFieldAsSingle("to_ResourceDemand", EngmntProjRsceDmnd.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmnd</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemand</b> of a queried <b>EngmntProjRsceSup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceDmnd</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceDmnd getResourceDemandOrFetch()
    {
        if( toResourceDemand == null ) {
            toResourceDemand = fetchResourceDemand();
        }
        return toResourceDemand;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmnd</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceSup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceDemand</b> is already loaded, the result will
     *         contain the <b>EngmntProjRsceDmnd</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EngmntProjRsceDmnd> getResourceDemandIfPresent()
    {
        return Option.of(toResourceDemand);
    }

    /**
     * Overwrites the associated <b>EngmntProjRsceDmnd</b> entity for the loaded navigation property
     * <b>to_ResourceDemand</b>.
     *
     * @param value
     *            New <b>EngmntProjRsceDmnd</b> entity.
     */
    public void setResourceDemand( final EngmntProjRsceDmnd value )
    {
        toResourceDemand = value;
    }

    /**
     * Fetches the <b>EngmntProjRsceSupDistr</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ResourceSupplyDistribution</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EngmntProjRsceSupDistr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceSupDistr> fetchResourceSupplyDistribution()
    {
        return fetchFieldAsList("to_ResourceSupplyDistribution", EngmntProjRsceSupDistr.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceSupDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceSupplyDistribution</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupplyDistribution</b> of a queried <b>EngmntProjRsceSup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceSupDistr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceSupDistr> getResourceSupplyDistributionOrFetch()
    {
        if( toResourceSupplyDistribution == null ) {
            toResourceSupplyDistribution = fetchResourceSupplyDistribution();
        }
        return toResourceSupplyDistribution;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceSupDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceSupplyDistribution</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceSup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceSupplyDistribution</b> is already loaded, the
     *         result will contain the <b>EngmntProjRsceSupDistr</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EngmntProjRsceSupDistr>> getResourceSupplyDistributionIfPresent()
    {
        return Option.of(toResourceSupplyDistribution);
    }

    /**
     * Overwrites the list of associated <b>EngmntProjRsceSupDistr</b> entities for the loaded navigation property
     * <b>to_ResourceSupplyDistribution</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupplyDistribution</b> of a queried <b>EngmntProjRsceSup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EngmntProjRsceSupDistr</b> entities.
     */
    public void setResourceSupplyDistribution( @Nonnull final List<EngmntProjRsceSupDistr> value )
    {
        if( toResourceSupplyDistribution == null ) {
            toResourceSupplyDistribution = Lists.newArrayList();
        }
        toResourceSupplyDistribution.clear();
        toResourceSupplyDistribution.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EngmntProjRsceSupDistr</b> entities. This corresponds to the OData
     * navigation property <b>to_ResourceSupplyDistribution</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupplyDistribution</b> of a queried <b>EngmntProjRsceSup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EngmntProjRsceSupDistr</b> entities.
     */
    public void addResourceSupplyDistribution( EngmntProjRsceSupDistr... entity )
    {
        if( toResourceSupplyDistribution == null ) {
            toResourceSupplyDistribution = Lists.newArrayList();
        }
        toResourceSupplyDistribution.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EngmntProjRsceSup instances.
     *
     */
    public final static class EngmntProjRsceSupBuilder
    {

        private EngmntProjRsceDmnd toResourceDemand;
        private String resourceDemand = null;
        private List<EngmntProjRsceSupDistr> toResourceSupplyDistribution = Lists.newArrayList();

        private EngmntProjRsceSup.EngmntProjRsceSupBuilder toResourceDemand( final EngmntProjRsceDmnd value )
        {
            toResourceDemand = value;
            return this;
        }

        /**
         * Navigation property <b>to_ResourceDemand</b> for <b>EngmntProjRsceSup</b> to single
         * <b>EngmntProjRsceDmnd</b>.
         *
         * @param value
         *            The EngmntProjRsceDmnd to build this EngmntProjRsceSup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceSup.EngmntProjRsceSupBuilder resourceDemand( final EngmntProjRsceDmnd value )
        {
            return toResourceDemand(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 24
         * <p>
         * Original property name from the Odata EDM: <b>ResourceDemand</b>
         * </p>
         *
         * @param value
         *            The resourceDemand to build this EngmntProjRsceSup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceSup.EngmntProjRsceSupBuilder resourceDemand( final String value )
        {
            resourceDemand = value;
            return this;
        }

        private EngmntProjRsceSup.EngmntProjRsceSupBuilder toResourceSupplyDistribution(
            final List<EngmntProjRsceSupDistr> value )
        {
            toResourceSupplyDistribution.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ResourceSupplyDistribution</b> for <b>EngmntProjRsceSup</b> to multiple
         * <b>EngmntProjRsceSupDistr</b>.
         *
         * @param value
         *            The EngmntProjRsceSupDistrs to build this EngmntProjRsceSup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceSup.EngmntProjRsceSupBuilder resourceSupplyDistribution( EngmntProjRsceSupDistr... value )
        {
            return toResourceSupplyDistribution(Lists.newArrayList(value));
        }

    }

}
