/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.EngmntProjRsceSupDistrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceSupDistrOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.EngmntProjRsceSupDistrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Resource Supply Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EngmntProjRsceSupDistrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EngmntProjRsceSupDistr extends VdmEntity<EngmntProjRsceSupDistr>
{

    /**
     * Selector for all available fields of EngmntProjRsceSupDistr.
     *
     */
    public final static EngmntProjRsceSupDistrSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackage" )
    @JsonProperty( "WorkPackage" )
    @Nullable
    @ODataField( odataName = "WorkPackage" )
    private String workPackage;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackage</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> WORK_PACKAGE =
        new EngmntProjRsceSupDistrField<String>("WorkPackage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @return Resource Demand ID
     */
    @Key
    @SerializedName( "ResourceDemand" )
    @JsonProperty( "ResourceDemand" )
    @Nullable
    @ODataField( odataName = "ResourceDemand" )
    private String resourceDemand;
    /**
     * Use with available fluent helpers to apply the <b>ResourceDemand</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> RESOURCE_DEMAND =
        new EngmntProjRsceSupDistrField<String>("ResourceDemand");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceSupply</b>
     * </p>
     *
     * @return Resource Supply ID
     */
    @Key
    @SerializedName( "ResourceSupply" )
    @JsonProperty( "ResourceSupply" )
    @Nullable
    @ODataField( odataName = "ResourceSupply" )
    private String resourceSupply;
    /**
     * Use with available fluent helpers to apply the <b>ResourceSupply</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> RESOURCE_SUPPLY =
        new EngmntProjRsceSupDistrField<String>("ResourceSupply");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Plan Version ID
     */
    @Key
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> VERSION =
        new EngmntProjRsceSupDistrField<String>("Version");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @return Calendar Month
     */
    @Key
    @SerializedName( "CalendarMonth" )
    @JsonProperty( "CalendarMonth" )
    @Nullable
    @ODataField( odataName = "CalendarMonth" )
    private String calendarMonth;
    /**
     * Use with available fluent helpers to apply the <b>CalendarMonth</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> CALENDAR_MONTH =
        new EngmntProjRsceSupDistrField<String>("CalendarMonth");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @return Calendar Year
     */
    @Key
    @SerializedName( "CalendarYear" )
    @JsonProperty( "CalendarYear" )
    @Nullable
    @ODataField( odataName = "CalendarYear" )
    private String calendarYear;
    /**
     * Use with available fluent helpers to apply the <b>CalendarYear</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> CALENDAR_YEAR =
        new EngmntProjRsceSupDistrField<String>("CalendarYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> UNIT_OF_MEASURE =
        new EngmntProjRsceSupDistrField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Plan Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<String> CURRENCY =
        new EngmntProjRsceSupDistrField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Total Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<BigDecimal> QUANTITY =
        new EngmntProjRsceSupDistrField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyCostAmt</b>
     * </p>
     *
     * @return Supply Cost Amount
     */
    @SerializedName( "SupplyCostAmt" )
    @JsonProperty( "SupplyCostAmt" )
    @Nullable
    @ODataField( odataName = "SupplyCostAmt" )
    private BigDecimal supplyCostAmt;
    /**
     * Use with available fluent helpers to apply the <b>SupplyCostAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<BigDecimal> SUPPLY_COST_AMT =
        new EngmntProjRsceSupDistrField<BigDecimal>("SupplyCostAmt");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyRevnAmt</b>
     * </p>
     *
     * @return Supply Revenue Amount
     */
    @SerializedName( "SupplyRevnAmt" )
    @JsonProperty( "SupplyRevnAmt" )
    @Nullable
    @ODataField( odataName = "SupplyRevnAmt" )
    private BigDecimal supplyRevnAmt;
    /**
     * Use with available fluent helpers to apply the <b>SupplyRevnAmt</b> field to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrField<BigDecimal> SUPPLY_REVN_AMT =
        new EngmntProjRsceSupDistrField<BigDecimal>("SupplyRevnAmt");
    /**
     * Navigation property <b>to_ResourceSupply</b> for <b>EngmntProjRsceSupDistr</b> to single
     * <b>EngmntProjRsceSup</b>.
     *
     */
    @SerializedName( "to_ResourceSupply" )
    @JsonProperty( "to_ResourceSupply" )
    @ODataField( odataName = "to_ResourceSupply" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EngmntProjRsceSup toResourceSupply;
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceSupply</b> navigation property to query operations.
     *
     */
    public final static EngmntProjRsceSupDistrOneToOneLink<EngmntProjRsceSup> TO_RESOURCE_SUPPLY =
        new EngmntProjRsceSupDistrOneToOneLink<EngmntProjRsceSup>("to_ResourceSupply");

    @Nonnull
    @Override
    public Class<EngmntProjRsceSupDistr> getType()
    {
        return EngmntProjRsceSupDistr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackage</b>
     * </p>
     *
     * @param workPackage
     *            Work Package ID
     */
    public void setWorkPackage( @Nullable final String workPackage )
    {
        rememberChangedField("WorkPackage", this.workPackage);
        this.workPackage = workPackage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceDemand</b>
     * </p>
     *
     * @param resourceDemand
     *            Resource Demand ID
     */
    public void setResourceDemand( @Nullable final String resourceDemand )
    {
        rememberChangedField("ResourceDemand", this.resourceDemand);
        this.resourceDemand = resourceDemand;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ResourceSupply</b>
     * </p>
     *
     * @param resourceSupply
     *            Resource Supply ID
     */
    public void setResourceSupply( @Nullable final String resourceSupply )
    {
        rememberChangedField("ResourceSupply", this.resourceSupply);
        this.resourceSupply = resourceSupply;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Plan Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalendarMonth</b>
     * </p>
     *
     * @param calendarMonth
     *            Calendar Month
     */
    public void setCalendarMonth( @Nullable final String calendarMonth )
    {
        rememberChangedField("CalendarMonth", this.calendarMonth);
        this.calendarMonth = calendarMonth;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CalendarYear</b>
     * </p>
     *
     * @param calendarYear
     *            Calendar Year
     */
    public void setCalendarYear( @Nullable final String calendarYear )
    {
        rememberChangedField("CalendarYear", this.calendarYear);
        this.calendarYear = calendarYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Plan Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Total Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyCostAmt</b>
     * </p>
     *
     * @param supplyCostAmt
     *            Supply Cost Amount
     */
    public void setSupplyCostAmt( @Nullable final BigDecimal supplyCostAmt )
    {
        rememberChangedField("SupplyCostAmt", this.supplyCostAmt);
        this.supplyCostAmt = supplyCostAmt;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplyRevnAmt</b>
     * </p>
     *
     * @param supplyRevnAmt
     *            Supply Revenue Amount
     */
    public void setSupplyRevnAmt( @Nullable final BigDecimal supplyRevnAmt )
    {
        rememberChangedField("SupplyRevnAmt", this.supplyRevnAmt);
        this.supplyRevnAmt = supplyRevnAmt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EngmntProjRsceSupDistr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkPackage", getWorkPackage());
        result.put("ResourceDemand", getResourceDemand());
        result.put("ResourceSupply", getResourceSupply());
        result.put("Version", getVersion());
        result.put("CalendarMonth", getCalendarMonth());
        result.put("CalendarYear", getCalendarYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkPackage", getWorkPackage());
        values.put("ResourceDemand", getResourceDemand());
        values.put("ResourceSupply", getResourceSupply());
        values.put("Version", getVersion());
        values.put("CalendarMonth", getCalendarMonth());
        values.put("CalendarYear", getCalendarYear());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("Currency", getCurrency());
        values.put("Quantity", getQuantity());
        values.put("SupplyCostAmt", getSupplyCostAmt());
        values.put("SupplyRevnAmt", getSupplyRevnAmt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkPackage") ) {
                final Object value = values.remove("WorkPackage");
                if( (value == null) || (!value.equals(getWorkPackage())) ) {
                    setWorkPackage(((String) value));
                }
            }
            if( values.containsKey("ResourceDemand") ) {
                final Object value = values.remove("ResourceDemand");
                if( (value == null) || (!value.equals(getResourceDemand())) ) {
                    setResourceDemand(((String) value));
                }
            }
            if( values.containsKey("ResourceSupply") ) {
                final Object value = values.remove("ResourceSupply");
                if( (value == null) || (!value.equals(getResourceSupply())) ) {
                    setResourceSupply(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("CalendarMonth") ) {
                final Object value = values.remove("CalendarMonth");
                if( (value == null) || (!value.equals(getCalendarMonth())) ) {
                    setCalendarMonth(((String) value));
                }
            }
            if( values.containsKey("CalendarYear") ) {
                final Object value = values.remove("CalendarYear");
                if( (value == null) || (!value.equals(getCalendarYear())) ) {
                    setCalendarYear(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplyCostAmt") ) {
                final Object value = values.remove("SupplyCostAmt");
                if( (value == null) || (!value.equals(getSupplyCostAmt())) ) {
                    setSupplyCostAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplyRevnAmt") ) {
                final Object value = values.remove("SupplyRevnAmt");
                if( (value == null) || (!value.equals(getSupplyRevnAmt())) ) {
                    setSupplyRevnAmt(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ResourceSupply") ) {
                final Object value = (values).remove("to_ResourceSupply");
                if( value instanceof Map ) {
                    if( toResourceSupply == null ) {
                        toResourceSupply = new EngmntProjRsceSup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toResourceSupply.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EngmntProjRsceSupDistrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EngmntProjRsceSupDistrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EngmntProjRsceSupDistrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EngmntProjRsceSupDistrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResourceSupply != null ) {
            (values).put("to_ResourceSupply", toResourceSupply);
        }
        return values;
    }

    /**
     * Fetches the <b>EngmntProjRsceSup</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ResourceSupply</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EngmntProjRsceSup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceSup fetchResourceSupply()
    {
        return fetchFieldAsSingle("to_ResourceSupply", EngmntProjRsceSup.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceSup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ResourceSupply</b>.
     * <p>
     * If the navigation property <b>to_ResourceSupply</b> of a queried <b>EngmntProjRsceSupDistr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceSup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EngmntProjRsceSup getResourceSupplyOrFetch()
    {
        if( toResourceSupply == null ) {
            toResourceSupply = fetchResourceSupply();
        }
        return toResourceSupply;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceSup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ResourceSupply</b>.
     * <p>
     * If the navigation property for an entity <b>EngmntProjRsceSupDistr</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceSupply</b> is already loaded, the result will
     *         contain the <b>EngmntProjRsceSup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EngmntProjRsceSup> getResourceSupplyIfPresent()
    {
        return Option.of(toResourceSupply);
    }

    /**
     * Overwrites the associated <b>EngmntProjRsceSup</b> entity for the loaded navigation property
     * <b>to_ResourceSupply</b>.
     *
     * @param value
     *            New <b>EngmntProjRsceSup</b> entity.
     */
    public void setResourceSupply( final EngmntProjRsceSup value )
    {
        toResourceSupply = value;
    }

    /**
     * Helper class to allow for fluent creation of EngmntProjRsceSupDistr instances.
     *
     */
    public final static class EngmntProjRsceSupDistrBuilder
    {

        private EngmntProjRsceSup toResourceSupply;
        private String resourceSupply = null;

        private EngmntProjRsceSupDistr.EngmntProjRsceSupDistrBuilder toResourceSupply( final EngmntProjRsceSup value )
        {
            toResourceSupply = value;
            return this;
        }

        /**
         * Navigation property <b>to_ResourceSupply</b> for <b>EngmntProjRsceSupDistr</b> to single
         * <b>EngmntProjRsceSup</b>.
         *
         * @param value
         *            The EngmntProjRsceSup to build this EngmntProjRsceSupDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceSupDistr.EngmntProjRsceSupDistrBuilder resourceSupply( final EngmntProjRsceSup value )
        {
            return toResourceSupply(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 24
         * <p>
         * Original property name from the Odata EDM: <b>ResourceSupply</b>
         * </p>
         *
         * @param value
         *            The resourceSupply to build this EngmntProjRsceSupDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EngmntProjRsceSupDistr.EngmntProjRsceSupDistrBuilder resourceSupply( final String value )
        {
            resourceSupply = value;
            return this;
        }

    }

}
