/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.ProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.ProjectLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.ProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Project</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Project extends VdmEntity<Project>
{

    /**
     * Selector for all available fields of Project.
     *
     */
    public final static ProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_ID = new ProjectField<String>("ProjectID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectName</b>
     * </p>
     *
     * @return Project Name
     */
    @SerializedName( "ProjectName" )
    @JsonProperty( "ProjectName" )
    @Nullable
    @ODataField( odataName = "ProjectName" )
    private String projectName;
    /**
     * Use with available fluent helpers to apply the <b>ProjectName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_NAME = new ProjectField<String>("ProjectName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStage</b>
     * </p>
     *
     * @return Stage ID
     */
    @SerializedName( "ProjectStage" )
    @JsonProperty( "ProjectStage" )
    @Nullable
    @ODataField( odataName = "ProjectStage" )
    private String projectStage;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStage</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_STAGE = new ProjectField<String>("ProjectStage");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrgID</b>
     * </p>
     *
     * @return Service Organization ID
     */
    @SerializedName( "OrgID" )
    @JsonProperty( "OrgID" )
    @Nullable
    @ODataField( odataName = "OrgID" )
    private String orgID;
    /**
     * Use with available fluent helpers to apply the <b>OrgID</b> field to query operations.
     *
     */
    public final static ProjectField<String> ORG_ID = new ProjectField<String>("OrgID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCategory</b>
     * </p>
     *
     * @return Project Type
     */
    @SerializedName( "ProjectCategory" )
    @JsonProperty( "ProjectCategory" )
    @Nullable
    @ODataField( odataName = "ProjectCategory" )
    private String projectCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProjectCategory</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_CATEGORY = new ProjectField<String>("ProjectCategory");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProjectField<String> CURRENCY = new ProjectField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>StartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "StartDate" )
    @JsonProperty( "StartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "StartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime startDate;
    /**
     * Use with available fluent helpers to apply the <b>StartDate</b> field to query operations.
     *
     */
    public final static ProjectField<LocalDateTime> START_DATE = new ProjectField<LocalDateTime>("StartDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "EndDate" )
    @JsonProperty( "EndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime endDate;
    /**
     * Use with available fluent helpers to apply the <b>EndDate</b> field to query operations.
     *
     */
    public final static ProjectField<LocalDateTime> END_DATE = new ProjectField<LocalDateTime>("EndDate");
    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerExtId</b>
     * </p>
     *
     * @return Project Manager ID
     */
    @SerializedName( "ProjManagerExtId" )
    @JsonProperty( "ProjManagerExtId" )
    @Nullable
    @ODataField( odataName = "ProjManagerExtId" )
    private String projManagerExtId;
    /**
     * Use with available fluent helpers to apply the <b>ProjManagerExtId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_MANAGER_EXT_ID = new ProjectField<String>("ProjManagerExtId");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerCompCode</b>
     * </p>
     *
     * @return Project Manager's Company Code
     */
    @SerializedName( "ProjManagerCompCode" )
    @JsonProperty( "ProjManagerCompCode" )
    @Nullable
    @ODataField( odataName = "ProjManagerCompCode" )
    private String projManagerCompCode;
    /**
     * Use with available fluent helpers to apply the <b>ProjManagerCompCode</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_MANAGER_COMP_CODE = new ProjectField<String>("ProjManagerCompCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer ID
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ProjectField<String> CUSTOMER = new ProjectField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Project Cost Center ID
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static ProjectField<String> COST_CENTER = new ProjectField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center ID
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROFIT_CENTER = new ProjectField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantExtId</b>
     * </p>
     *
     * @return Project Accountant ID
     */
    @SerializedName( "ProjAccountantExtId" )
    @JsonProperty( "ProjAccountantExtId" )
    @Nullable
    @ODataField( odataName = "ProjAccountantExtId" )
    private String projAccountantExtId;
    /**
     * Use with available fluent helpers to apply the <b>ProjAccountantExtId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_ACCOUNTANT_EXT_ID = new ProjectField<String>("ProjAccountantExtId");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantCompCode</b>
     * </p>
     *
     * @return Project Accountant's Company Code
     */
    @SerializedName( "ProjAccountantCompCode" )
    @JsonProperty( "ProjAccountantCompCode" )
    @Nullable
    @ODataField( odataName = "ProjAccountantCompCode" )
    private String projAccountantCompCode;
    /**
     * Use with available fluent helpers to apply the <b>ProjAccountantCompCode</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_ACCOUNTANT_COMP_CODE =
        new ProjectField<String>("ProjAccountantCompCode");
    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerExtId</b>
     * </p>
     *
     * @return Project Controller ID
     */
    @SerializedName( "ProjControllerExtId" )
    @JsonProperty( "ProjControllerExtId" )
    @Nullable
    @ODataField( odataName = "ProjControllerExtId" )
    private String projControllerExtId;
    /**
     * Use with available fluent helpers to apply the <b>ProjControllerExtId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_CONTROLLER_EXT_ID = new ProjectField<String>("ProjControllerExtId");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerCompCode</b>
     * </p>
     *
     * @return Project Controller's Company Code
     */
    @SerializedName( "ProjControllerCompCode" )
    @JsonProperty( "ProjControllerCompCode" )
    @Nullable
    @ODataField( odataName = "ProjControllerCompCode" )
    private String projControllerCompCode;
    /**
     * Use with available fluent helpers to apply the <b>ProjControllerCompCode</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_CONTROLLER_COMP_CODE =
        new ProjectField<String>("ProjControllerCompCode");
    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerExtId</b>
     * </p>
     *
     * @return Project Partner ID
     */
    @SerializedName( "ProjPartnerExtId" )
    @JsonProperty( "ProjPartnerExtId" )
    @Nullable
    @ODataField( odataName = "ProjPartnerExtId" )
    private String projPartnerExtId;
    /**
     * Use with available fluent helpers to apply the <b>ProjPartnerExtId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_PARTNER_EXT_ID = new ProjectField<String>("ProjPartnerExtId");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerCompCode</b>
     * </p>
     *
     * @return Project Partner's Company Code
     */
    @SerializedName( "ProjPartnerCompCode" )
    @JsonProperty( "ProjPartnerCompCode" )
    @Nullable
    @ODataField( odataName = "ProjPartnerCompCode" )
    private String projPartnerCompCode;
    /**
     * Use with available fluent helpers to apply the <b>ProjPartnerCompCode</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_PARTNER_COMP_CODE = new ProjectField<String>("ProjPartnerCompCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDesc</b>
     * </p>
     *
     * @return Project Desc.
     */
    @SerializedName( "ProjectDesc" )
    @JsonProperty( "ProjectDesc" )
    @Nullable
    @ODataField( odataName = "ProjectDesc" )
    private String projectDesc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDesc</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_DESC = new ProjectField<String>("ProjectDesc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confidential</b>
     * </p>
     *
     * @return Confidential
     */
    @SerializedName( "Confidential" )
    @JsonProperty( "Confidential" )
    @Nullable
    @ODataField( odataName = "Confidential" )
    private String confidential;
    /**
     * Use with available fluent helpers to apply the <b>Confidential</b> field to query operations.
     *
     */
    public final static ProjectField<String> CONFIDENTIAL = new ProjectField<String>("Confidential");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>UseProjectBilling</b>
     * </p>
     *
     * @return Use Project Billiing
     */
    @SerializedName( "UseProjectBilling" )
    @JsonProperty( "UseProjectBilling" )
    @Nullable
    @ODataField( odataName = "UseProjectBilling" )
    private String useProjectBilling;
    /**
     * Use with available fluent helpers to apply the <b>UseProjectBilling</b> field to query operations.
     *
     */
    public final static ProjectField<String> USE_PROJECT_BILLING = new ProjectField<String>("UseProjectBilling");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RestrictTimePosting</b>
     * </p>
     *
     * @return Restrict time post
     */
    @SerializedName( "RestrictTimePosting" )
    @JsonProperty( "RestrictTimePosting" )
    @Nullable
    @ODataField( odataName = "RestrictTimePosting" )
    private String restrictTimePosting;
    /**
     * Use with available fluent helpers to apply the <b>RestrictTimePosting</b> field to query operations.
     *
     */
    public final static ProjectField<String> RESTRICT_TIME_POSTING = new ProjectField<String>("RestrictTimePosting");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreatedOn</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreatedOn" )
    @JsonProperty( "CreatedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreatedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime createdOn;
    /**
     * Use with available fluent helpers to apply the <b>CreatedOn</b> field to query operations.
     *
     */
    public final static ProjectField<LocalDateTime> CREATED_ON = new ProjectField<LocalDateTime>("CreatedOn");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "ChangedOn" )
    @JsonProperty( "ChangedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedOn;
    /**
     * Use with available fluent helpers to apply the <b>ChangedOn</b> field to query operations.
     *
     */
    public final static ProjectField<ZonedDateTime> CHANGED_ON = new ProjectField<ZonedDateTime>("ChangedOn");
    /**
     * Navigation property <b>ProjectRoleSet</b> for <b>Project</b> to multiple <b>ProjectRole</b>.
     *
     */
    @SerializedName( "ProjectRoleSet" )
    @JsonProperty( "ProjectRoleSet" )
    @ODataField( odataName = "ProjectRoleSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjectRole> toProjectRoleSet;
    /**
     * Navigation property <b>WorkPackageSet</b> for <b>Project</b> to multiple <b>WorkPackage</b>.
     *
     */
    @SerializedName( "WorkPackageSet" )
    @JsonProperty( "WorkPackageSet" )
    @ODataField( odataName = "WorkPackageSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkPackage> toWorkPackageSet;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleSet</b> navigation property to query operations.
     *
     */
    public final static ProjectLink<ProjectRole> TO_PROJECT_ROLE_SET = new ProjectLink<ProjectRole>("ProjectRoleSet");
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageSet</b> navigation property to query operations.
     *
     */
    public final static ProjectLink<WorkPackage> TO_WORK_PACKAGE_SET = new ProjectLink<WorkPackage>("WorkPackageSet");

    @Nonnull
    @Override
    public Class<Project> getType()
    {
        return Project.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectName</b>
     * </p>
     *
     * @param projectName
     *            Project Name
     */
    public void setProjectName( @Nullable final String projectName )
    {
        rememberChangedField("ProjectName", this.projectName);
        this.projectName = projectName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStage</b>
     * </p>
     *
     * @param projectStage
     *            Stage ID
     */
    public void setProjectStage( @Nullable final String projectStage )
    {
        rememberChangedField("ProjectStage", this.projectStage);
        this.projectStage = projectStage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrgID</b>
     * </p>
     *
     * @param orgID
     *            Service Organization ID
     */
    public void setOrgID( @Nullable final String orgID )
    {
        rememberChangedField("OrgID", this.orgID);
        this.orgID = orgID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCategory</b>
     * </p>
     *
     * @param projectCategory
     *            Project Type
     */
    public void setProjectCategory( @Nullable final String projectCategory )
    {
        rememberChangedField("ProjectCategory", this.projectCategory);
        this.projectCategory = projectCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>StartDate</b>
     * </p>
     *
     * @param startDate
     *            Start Date
     */
    public void setStartDate( @Nullable final LocalDateTime startDate )
    {
        rememberChangedField("StartDate", this.startDate);
        this.startDate = startDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @param endDate
     *            End Date
     */
    public void setEndDate( @Nullable final LocalDateTime endDate )
    {
        rememberChangedField("EndDate", this.endDate);
        this.endDate = endDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerExtId</b>
     * </p>
     *
     * @param projManagerExtId
     *            Project Manager ID
     */
    public void setProjManagerExtId( @Nullable final String projManagerExtId )
    {
        rememberChangedField("ProjManagerExtId", this.projManagerExtId);
        this.projManagerExtId = projManagerExtId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerCompCode</b>
     * </p>
     *
     * @param projManagerCompCode
     *            Project Manager's Company Code
     */
    public void setProjManagerCompCode( @Nullable final String projManagerCompCode )
    {
        rememberChangedField("ProjManagerCompCode", this.projManagerCompCode);
        this.projManagerCompCode = projManagerCompCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer ID
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Project Cost Center ID
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center ID
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantExtId</b>
     * </p>
     *
     * @param projAccountantExtId
     *            Project Accountant ID
     */
    public void setProjAccountantExtId( @Nullable final String projAccountantExtId )
    {
        rememberChangedField("ProjAccountantExtId", this.projAccountantExtId);
        this.projAccountantExtId = projAccountantExtId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantCompCode</b>
     * </p>
     *
     * @param projAccountantCompCode
     *            Project Accountant's Company Code
     */
    public void setProjAccountantCompCode( @Nullable final String projAccountantCompCode )
    {
        rememberChangedField("ProjAccountantCompCode", this.projAccountantCompCode);
        this.projAccountantCompCode = projAccountantCompCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerExtId</b>
     * </p>
     *
     * @param projControllerExtId
     *            Project Controller ID
     */
    public void setProjControllerExtId( @Nullable final String projControllerExtId )
    {
        rememberChangedField("ProjControllerExtId", this.projControllerExtId);
        this.projControllerExtId = projControllerExtId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerCompCode</b>
     * </p>
     *
     * @param projControllerCompCode
     *            Project Controller's Company Code
     */
    public void setProjControllerCompCode( @Nullable final String projControllerCompCode )
    {
        rememberChangedField("ProjControllerCompCode", this.projControllerCompCode);
        this.projControllerCompCode = projControllerCompCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 38
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerExtId</b>
     * </p>
     *
     * @param projPartnerExtId
     *            Project Partner ID
     */
    public void setProjPartnerExtId( @Nullable final String projPartnerExtId )
    {
        rememberChangedField("ProjPartnerExtId", this.projPartnerExtId);
        this.projPartnerExtId = projPartnerExtId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerCompCode</b>
     * </p>
     *
     * @param projPartnerCompCode
     *            Project Partner's Company Code
     */
    public void setProjPartnerCompCode( @Nullable final String projPartnerCompCode )
    {
        rememberChangedField("ProjPartnerCompCode", this.projPartnerCompCode);
        this.projPartnerCompCode = projPartnerCompCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDesc</b>
     * </p>
     *
     * @param projectDesc
     *            Project Desc.
     */
    public void setProjectDesc( @Nullable final String projectDesc )
    {
        rememberChangedField("ProjectDesc", this.projectDesc);
        this.projectDesc = projectDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confidential</b>
     * </p>
     *
     * @param confidential
     *            Confidential
     */
    public void setConfidential( @Nullable final String confidential )
    {
        rememberChangedField("Confidential", this.confidential);
        this.confidential = confidential;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>UseProjectBilling</b>
     * </p>
     *
     * @param useProjectBilling
     *            Use Project Billiing
     */
    public void setUseProjectBilling( @Nullable final String useProjectBilling )
    {
        rememberChangedField("UseProjectBilling", this.useProjectBilling);
        this.useProjectBilling = useProjectBilling;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RestrictTimePosting</b>
     * </p>
     *
     * @param restrictTimePosting
     *            Restrict time post
     */
    public void setRestrictTimePosting( @Nullable final String restrictTimePosting )
    {
        rememberChangedField("RestrictTimePosting", this.restrictTimePosting);
        this.restrictTimePosting = restrictTimePosting;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreatedOn</b>
     * </p>
     *
     * @param createdOn
     *            Created On
     */
    public void setCreatedOn( @Nullable final LocalDateTime createdOn )
    {
        rememberChangedField("CreatedOn", this.createdOn);
        this.createdOn = createdOn;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @param changedOn
     *            Changed On
     */
    public void setChangedOn( @Nullable final ZonedDateTime changedOn )
    {
        rememberChangedField("ChangedOn", this.changedOn);
        this.changedOn = changedOn;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProjectSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectID", getProjectID());
        values.put("ProjectName", getProjectName());
        values.put("ProjectStage", getProjectStage());
        values.put("OrgID", getOrgID());
        values.put("ProjectCategory", getProjectCategory());
        values.put("Currency", getCurrency());
        values.put("StartDate", getStartDate());
        values.put("EndDate", getEndDate());
        values.put("ProjManagerExtId", getProjManagerExtId());
        values.put("ProjManagerCompCode", getProjManagerCompCode());
        values.put("Customer", getCustomer());
        values.put("CostCenter", getCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProjAccountantExtId", getProjAccountantExtId());
        values.put("ProjAccountantCompCode", getProjAccountantCompCode());
        values.put("ProjControllerExtId", getProjControllerExtId());
        values.put("ProjControllerCompCode", getProjControllerCompCode());
        values.put("ProjPartnerExtId", getProjPartnerExtId());
        values.put("ProjPartnerCompCode", getProjPartnerCompCode());
        values.put("ProjectDesc", getProjectDesc());
        values.put("Confidential", getConfidential());
        values.put("UseProjectBilling", getUseProjectBilling());
        values.put("RestrictTimePosting", getRestrictTimePosting());
        values.put("CreatedOn", getCreatedOn());
        values.put("ChangedOn", getChangedOn());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("ProjectName") ) {
                final Object value = values.remove("ProjectName");
                if( (value == null) || (!value.equals(getProjectName())) ) {
                    setProjectName(((String) value));
                }
            }
            if( values.containsKey("ProjectStage") ) {
                final Object value = values.remove("ProjectStage");
                if( (value == null) || (!value.equals(getProjectStage())) ) {
                    setProjectStage(((String) value));
                }
            }
            if( values.containsKey("OrgID") ) {
                final Object value = values.remove("OrgID");
                if( (value == null) || (!value.equals(getOrgID())) ) {
                    setOrgID(((String) value));
                }
            }
            if( values.containsKey("ProjectCategory") ) {
                final Object value = values.remove("ProjectCategory");
                if( (value == null) || (!value.equals(getProjectCategory())) ) {
                    setProjectCategory(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("StartDate") ) {
                final Object value = values.remove("StartDate");
                if( (value == null) || (!value.equals(getStartDate())) ) {
                    setStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EndDate") ) {
                final Object value = values.remove("EndDate");
                if( (value == null) || (!value.equals(getEndDate())) ) {
                    setEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjManagerExtId") ) {
                final Object value = values.remove("ProjManagerExtId");
                if( (value == null) || (!value.equals(getProjManagerExtId())) ) {
                    setProjManagerExtId(((String) value));
                }
            }
            if( values.containsKey("ProjManagerCompCode") ) {
                final Object value = values.remove("ProjManagerCompCode");
                if( (value == null) || (!value.equals(getProjManagerCompCode())) ) {
                    setProjManagerCompCode(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProjAccountantExtId") ) {
                final Object value = values.remove("ProjAccountantExtId");
                if( (value == null) || (!value.equals(getProjAccountantExtId())) ) {
                    setProjAccountantExtId(((String) value));
                }
            }
            if( values.containsKey("ProjAccountantCompCode") ) {
                final Object value = values.remove("ProjAccountantCompCode");
                if( (value == null) || (!value.equals(getProjAccountantCompCode())) ) {
                    setProjAccountantCompCode(((String) value));
                }
            }
            if( values.containsKey("ProjControllerExtId") ) {
                final Object value = values.remove("ProjControllerExtId");
                if( (value == null) || (!value.equals(getProjControllerExtId())) ) {
                    setProjControllerExtId(((String) value));
                }
            }
            if( values.containsKey("ProjControllerCompCode") ) {
                final Object value = values.remove("ProjControllerCompCode");
                if( (value == null) || (!value.equals(getProjControllerCompCode())) ) {
                    setProjControllerCompCode(((String) value));
                }
            }
            if( values.containsKey("ProjPartnerExtId") ) {
                final Object value = values.remove("ProjPartnerExtId");
                if( (value == null) || (!value.equals(getProjPartnerExtId())) ) {
                    setProjPartnerExtId(((String) value));
                }
            }
            if( values.containsKey("ProjPartnerCompCode") ) {
                final Object value = values.remove("ProjPartnerCompCode");
                if( (value == null) || (!value.equals(getProjPartnerCompCode())) ) {
                    setProjPartnerCompCode(((String) value));
                }
            }
            if( values.containsKey("ProjectDesc") ) {
                final Object value = values.remove("ProjectDesc");
                if( (value == null) || (!value.equals(getProjectDesc())) ) {
                    setProjectDesc(((String) value));
                }
            }
            if( values.containsKey("Confidential") ) {
                final Object value = values.remove("Confidential");
                if( (value == null) || (!value.equals(getConfidential())) ) {
                    setConfidential(((String) value));
                }
            }
            if( values.containsKey("UseProjectBilling") ) {
                final Object value = values.remove("UseProjectBilling");
                if( (value == null) || (!value.equals(getUseProjectBilling())) ) {
                    setUseProjectBilling(((String) value));
                }
            }
            if( values.containsKey("RestrictTimePosting") ) {
                final Object value = values.remove("RestrictTimePosting");
                if( (value == null) || (!value.equals(getRestrictTimePosting())) ) {
                    setRestrictTimePosting(((String) value));
                }
            }
            if( values.containsKey("CreatedOn") ) {
                final Object value = values.remove("CreatedOn");
                if( (value == null) || (!value.equals(getCreatedOn())) ) {
                    setCreatedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedOn") ) {
                final Object value = values.remove("ChangedOn");
                if( (value == null) || (!value.equals(getChangedOn())) ) {
                    setChangedOn(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("ProjectRoleSet") ) {
                final Object value = (values).remove("ProjectRoleSet");
                if( value instanceof Iterable ) {
                    if( toProjectRoleSet == null ) {
                        toProjectRoleSet = Lists.newArrayList();
                    } else {
                        toProjectRoleSet = Lists.newArrayList(toProjectRoleSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjectRole entity;
                        if( toProjectRoleSet.size() > i ) {
                            entity = toProjectRoleSet.get(i);
                        } else {
                            entity = new ProjectRole();
                            toProjectRoleSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("WorkPackageSet") ) {
                final Object value = (values).remove("WorkPackageSet");
                if( value instanceof Iterable ) {
                    if( toWorkPackageSet == null ) {
                        toWorkPackageSet = Lists.newArrayList();
                    } else {
                        toWorkPackageSet = Lists.newArrayList(toWorkPackageSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkPackage entity;
                        if( toWorkPackageSet.size() > i ) {
                            entity = toWorkPackageSet.get(i);
                        } else {
                            entity = new WorkPackage();
                            toWorkPackageSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProjectRoleSet != null ) {
            (values).put("ProjectRoleSet", toProjectRoleSet);
        }
        if( toWorkPackageSet != null ) {
            (values).put("WorkPackageSet", toWorkPackageSet);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectRole</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>ProjectRoleSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjectRole</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectRole> fetchProjectRoleSet()
    {
        return fetchFieldAsList("ProjectRoleSet", ProjectRole.class);
    }

    /**
     * Retrieval of associated <b>ProjectRole</b> entities (one to many). This corresponds to the OData navigation
     * property <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property <b>ProjectRoleSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectRole</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectRole> getProjectRoleSetOrFetch()
    {
        if( toProjectRoleSet == null ) {
            toProjectRoleSet = fetchProjectRoleSet();
        }
        return toProjectRoleSet;
    }

    /**
     * Retrieval of associated <b>ProjectRole</b> entities (one to many). This corresponds to the OData navigation
     * property <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property for an entity <b>Project</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>ProjectRoleSet</b> is already loaded, the result will
     *         contain the <b>ProjectRole</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjectRole>> getProjectRoleSetIfPresent()
    {
        return Option.of(toProjectRoleSet);
    }

    /**
     * Overwrites the list of associated <b>ProjectRole</b> entities for the loaded navigation property
     * <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property <b>ProjectRoleSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjectRole</b> entities.
     */
    public void setProjectRoleSet( @Nonnull final List<ProjectRole> value )
    {
        if( toProjectRoleSet == null ) {
            toProjectRoleSet = Lists.newArrayList();
        }
        toProjectRoleSet.clear();
        toProjectRoleSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjectRole</b> entities. This corresponds to the OData navigation
     * property <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property <b>ProjectRoleSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjectRole</b> entities.
     */
    public void addProjectRoleSet( ProjectRole... entity )
    {
        if( toProjectRoleSet == null ) {
            toProjectRoleSet = Lists.newArrayList();
        }
        toProjectRoleSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkPackage</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>WorkPackageSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkPackage</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkPackage> fetchWorkPackageSet()
    {
        return fetchFieldAsList("WorkPackageSet", WorkPackage.class);
    }

    /**
     * Retrieval of associated <b>WorkPackage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>WorkPackageSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkPackage</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkPackage> getWorkPackageSetOrFetch()
    {
        if( toWorkPackageSet == null ) {
            toWorkPackageSet = fetchWorkPackageSet();
        }
        return toWorkPackageSet;
    }

    /**
     * Retrieval of associated <b>WorkPackage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>WorkPackageSet</b>.
     * <p>
     * If the navigation property for an entity <b>Project</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>WorkPackageSet</b> is already loaded, the result will
     *         contain the <b>WorkPackage</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkPackage>> getWorkPackageSetIfPresent()
    {
        return Option.of(toWorkPackageSet);
    }

    /**
     * Overwrites the list of associated <b>WorkPackage</b> entities for the loaded navigation property
     * <b>WorkPackageSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkPackage</b> entities.
     */
    public void setWorkPackageSet( @Nonnull final List<WorkPackage> value )
    {
        if( toWorkPackageSet == null ) {
            toWorkPackageSet = Lists.newArrayList();
        }
        toWorkPackageSet.clear();
        toWorkPackageSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkPackage</b> entities. This corresponds to the OData navigation
     * property <b>WorkPackageSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkPackage</b> entities.
     */
    public void addWorkPackageSet( WorkPackage... entity )
    {
        if( toWorkPackageSet == null ) {
            toWorkPackageSet = Lists.newArrayList();
        }
        toWorkPackageSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Project instances.
     *
     */
    public final static class ProjectBuilder
    {

        private List<ProjectRole> toProjectRoleSet = Lists.newArrayList();
        private List<WorkPackage> toWorkPackageSet = Lists.newArrayList();

        private Project.ProjectBuilder toProjectRoleSet( final List<ProjectRole> value )
        {
            toProjectRoleSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>ProjectRoleSet</b> for <b>Project</b> to multiple <b>ProjectRole</b>.
         *
         * @param value
         *            The ProjectRoles to build this Project with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Project.ProjectBuilder projectRoleSet( ProjectRole... value )
        {
            return toProjectRoleSet(Lists.newArrayList(value));
        }

        private Project.ProjectBuilder toWorkPackageSet( final List<WorkPackage> value )
        {
            toWorkPackageSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>WorkPackageSet</b> for <b>Project</b> to multiple <b>WorkPackage</b>.
         *
         * @param value
         *            The WorkPackages to build this Project with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Project.ProjectBuilder workPackageSet( WorkPackage... value )
        {
            return toWorkPackageSet(Lists.newArrayList(value));
        }

    }

}
