/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.ProjectRoleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.ProjectRoleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Project Roles
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectRole</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectRole extends VdmEntity<ProjectRole>
{

    /**
     * Selector for all available fields of ProjectRole.
     *
     */
    public final static ProjectRoleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static ProjectRoleField<String> PROJECT_ID = new ProjectRoleField<String>("ProjectID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleID</b>
     * </p>
     *
     * @return Project Role ID
     */
    @Key
    @SerializedName( "ProjectRoleID" )
    @JsonProperty( "ProjectRoleID" )
    @Nullable
    @ODataField( odataName = "ProjectRoleID" )
    private String projectRoleID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleID</b> field to query operations.
     *
     */
    public final static ProjectRoleField<String> PROJECT_ROLE_ID = new ProjectRoleField<String>("ProjectRoleID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleName</b>
     * </p>
     *
     * @return Project Role Name
     */
    @SerializedName( "ProjectRoleName" )
    @JsonProperty( "ProjectRoleName" )
    @Nullable
    @ODataField( odataName = "ProjectRoleName" )
    private String projectRoleName;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleName</b> field to query operations.
     *
     */
    public final static ProjectRoleField<String> PROJECT_ROLE_NAME = new ProjectRoleField<String>("ProjectRoleName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerID</b>
     * </p>
     *
     * @return Business Partner ID
     */
    @SerializedName( "BusinessPartnerID" )
    @JsonProperty( "BusinessPartnerID" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerID" )
    private String businessPartnerID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerID</b> field to query operations.
     *
     */
    public final static ProjectRoleField<String> BUSINESS_PARTNER_ID =
        new ProjectRoleField<String>("BusinessPartnerID");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @return Business Partner Name
     */
    @SerializedName( "BusinessPartnerName" )
    @JsonProperty( "BusinessPartnerName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName" )
    private String businessPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName</b> field to query operations.
     *
     */
    public final static ProjectRoleField<String> BUSINESS_PARTNER_NAME =
        new ProjectRoleField<String>("BusinessPartnerName");

    @Nonnull
    @Override
    public Class<ProjectRole> getType()
    {
        return ProjectRole.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleID</b>
     * </p>
     *
     * @param projectRoleID
     *            Project Role ID
     */
    public void setProjectRoleID( @Nullable final String projectRoleID )
    {
        rememberChangedField("ProjectRoleID", this.projectRoleID);
        this.projectRoleID = projectRoleID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleName</b>
     * </p>
     *
     * @param projectRoleName
     *            Project Role Name
     */
    public void setProjectRoleName( @Nullable final String projectRoleName )
    {
        rememberChangedField("ProjectRoleName", this.projectRoleName);
        this.projectRoleName = projectRoleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerID</b>
     * </p>
     *
     * @param businessPartnerID
     *            Business Partner ID
     */
    public void setBusinessPartnerID( @Nullable final String businessPartnerID )
    {
        rememberChangedField("BusinessPartnerID", this.businessPartnerID);
        this.businessPartnerID = businessPartnerID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @param businessPartnerName
     *            Business Partner Name
     */
    public void setBusinessPartnerName( @Nullable final String businessPartnerName )
    {
        rememberChangedField("BusinessPartnerName", this.businessPartnerName);
        this.businessPartnerName = businessPartnerName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProjectRoleSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        result.put("ProjectRoleID", getProjectRoleID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectID", getProjectID());
        values.put("ProjectRoleID", getProjectRoleID());
        values.put("ProjectRoleName", getProjectRoleName());
        values.put("BusinessPartnerID", getBusinessPartnerID());
        values.put("BusinessPartnerName", getBusinessPartnerName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("ProjectRoleID") ) {
                final Object value = values.remove("ProjectRoleID");
                if( (value == null) || (!value.equals(getProjectRoleID())) ) {
                    setProjectRoleID(((String) value));
                }
            }
            if( values.containsKey("ProjectRoleName") ) {
                final Object value = values.remove("ProjectRoleName");
                if( (value == null) || (!value.equals(getProjectRoleName())) ) {
                    setProjectRoleName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerID") ) {
                final Object value = values.remove("BusinessPartnerID");
                if( (value == null) || (!value.equals(getBusinessPartnerID())) ) {
                    setBusinessPartnerID(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName") ) {
                final Object value = values.remove("BusinessPartnerName");
                if( (value == null) || (!value.equals(getBusinessPartnerName())) ) {
                    setBusinessPartnerName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectRoleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectRoleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectRoleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectRoleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

}
