/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.WorkPackageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.WorkPackageLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.WorkPackageOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.WorkPackageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Work Packages
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WorkPackage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkPackage extends VdmEntity<WorkPackage>
{

    /**
     * Selector for all available fields of WorkPackage.
     *
     */
    public final static WorkPackageSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static WorkPackageField<String> PROJECT_ID = new WorkPackageField<String>("ProjectID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackageID" )
    @JsonProperty( "WorkPackageID" )
    @Nullable
    @ODataField( odataName = "WorkPackageID" )
    private String workPackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageID</b> field to query operations.
     *
     */
    public final static WorkPackageField<String> WORK_PACKAGE_ID = new WorkPackageField<String>("WorkPackageID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @return Work Package Name
     */
    @Key
    @SerializedName( "WorkPackageName" )
    @JsonProperty( "WorkPackageName" )
    @Nullable
    @ODataField( odataName = "WorkPackageName" )
    private String workPackageName;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageName</b> field to query operations.
     *
     */
    public final static WorkPackageField<String> WORK_PACKAGE_NAME = new WorkPackageField<String>("WorkPackageName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Description</b>
     * </p>
     *
     * @return Work Package Desc.
     */
    @SerializedName( "Description" )
    @JsonProperty( "Description" )
    @Nullable
    @ODataField( odataName = "Description" )
    private String description;
    /**
     * Use with available fluent helpers to apply the <b>Description</b> field to query operations.
     *
     */
    public final static WorkPackageField<String> DESCRIPTION = new WorkPackageField<String>("Description");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPStartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "WPStartDate" )
    @JsonProperty( "WPStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WPStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime wPStartDate;
    /**
     * Use with available fluent helpers to apply the <b>WPStartDate</b> field to query operations.
     *
     */
    public final static WorkPackageField<LocalDateTime> WP_START_DATE =
        new WorkPackageField<LocalDateTime>("WPStartDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPEndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "WPEndDate" )
    @JsonProperty( "WPEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WPEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime wPEndDate;
    /**
     * Use with available fluent helpers to apply the <b>WPEndDate</b> field to query operations.
     *
     */
    public final static WorkPackageField<LocalDateTime> WP_END_DATE = new WorkPackageField<LocalDateTime>("WPEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageType</b>
     * </p>
     *
     * @return Work Package Type
     */
    @SerializedName( "WorkPackageType" )
    @JsonProperty( "WorkPackageType" )
    @Nullable
    @ODataField( odataName = "WorkPackageType" )
    private String workPackageType;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageType</b> field to query operations.
     *
     */
    public final static WorkPackageField<String> WORK_PACKAGE_TYPE = new WorkPackageField<String>("WorkPackageType");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitQuantity</b>
     * </p>
     *
     * @return Total Quantity
     */
    @SerializedName( "UnitQuantity" )
    @JsonProperty( "UnitQuantity" )
    @Nullable
    @ODataField( odataName = "UnitQuantity" )
    private BigDecimal unitQuantity;
    /**
     * Use with available fluent helpers to apply the <b>UnitQuantity</b> field to query operations.
     *
     */
    public final static WorkPackageField<BigDecimal> UNIT_QUANTITY = new WorkPackageField<BigDecimal>("UnitQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>UnitId</b>
     * </p>
     *
     * @return Resource ID
     */
    @SerializedName( "UnitId" )
    @JsonProperty( "UnitId" )
    @Nullable
    @ODataField( odataName = "UnitId" )
    private String unitId;
    /**
     * Use with available fluent helpers to apply the <b>UnitId</b> field to query operations.
     *
     */
    public final static WorkPackageField<String> UNIT_ID = new WorkPackageField<String>("UnitId");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreatedOn</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreatedOn" )
    @JsonProperty( "CreatedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreatedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime createdOn;
    /**
     * Use with available fluent helpers to apply the <b>CreatedOn</b> field to query operations.
     *
     */
    public final static WorkPackageField<LocalDateTime> CREATED_ON = new WorkPackageField<LocalDateTime>("CreatedOn");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "ChangedOn" )
    @JsonProperty( "ChangedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedOn;
    /**
     * Use with available fluent helpers to apply the <b>ChangedOn</b> field to query operations.
     *
     */
    public final static WorkPackageField<ZonedDateTime> CHANGED_ON = new WorkPackageField<ZonedDateTime>("ChangedOn");
    /**
     * Navigation property <b>to_ResourceDemand</b> for <b>WorkPackage</b> to multiple <b>EngmntProjRsceDmnd</b>.
     *
     */
    @SerializedName( "to_ResourceDemand" )
    @JsonProperty( "to_ResourceDemand" )
    @ODataField( odataName = "to_ResourceDemand" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EngmntProjRsceDmnd> toResourceDemand;
    /**
     * Navigation property <b>to_Project</b> for <b>WorkPackage</b> to single <b>Project</b>.
     *
     */
    @SerializedName( "to_Project" )
    @JsonProperty( "to_Project" )
    @ODataField( odataName = "to_Project" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Project toProject;
    /**
     * Navigation property <b>WorkItemSet</b> for <b>WorkPackage</b> to multiple <b>WorkItem</b>.
     *
     */
    @SerializedName( "WorkItemSet" )
    @JsonProperty( "WorkItemSet" )
    @ODataField( odataName = "WorkItemSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkItem> toWorkItemSet;
    /**
     * Navigation property <b>DemandSet</b> for <b>WorkPackage</b> to multiple <b>Demand</b>.
     *
     */
    @SerializedName( "DemandSet" )
    @JsonProperty( "DemandSet" )
    @ODataField( odataName = "DemandSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Demand> toDemandSet;
    /**
     * Navigation property <b>WorkPackageFunctionSet</b> for <b>WorkPackage</b> to multiple <b>WorkPackageFunction</b>.
     *
     */
    @SerializedName( "WorkPackageFunctionSet" )
    @JsonProperty( "WorkPackageFunctionSet" )
    @ODataField( odataName = "WorkPackageFunctionSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkPackageFunction> toWorkPackageFunctionSet;
    /**
     * Use with available fluent helpers to apply the <b>to_ResourceDemand</b> navigation property to query operations.
     *
     */
    public final static WorkPackageLink<EngmntProjRsceDmnd> TO_RESOURCE_DEMAND =
        new WorkPackageLink<EngmntProjRsceDmnd>("to_ResourceDemand");
    /**
     * Use with available fluent helpers to apply the <b>to_Project</b> navigation property to query operations.
     *
     */
    public final static WorkPackageOneToOneLink<Project> TO_PROJECT =
        new WorkPackageOneToOneLink<Project>("to_Project");
    /**
     * Use with available fluent helpers to apply the <b>WorkItemSet</b> navigation property to query operations.
     *
     */
    public final static WorkPackageLink<WorkItem> TO_WORK_ITEM_SET = new WorkPackageLink<WorkItem>("WorkItemSet");
    /**
     * Use with available fluent helpers to apply the <b>DemandSet</b> navigation property to query operations.
     *
     */
    public final static WorkPackageLink<Demand> TO_DEMAND_SET = new WorkPackageLink<Demand>("DemandSet");
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageFunctionSet</b> navigation property to query
     * operations.
     *
     */
    public final static WorkPackageLink<WorkPackageFunction> TO_WORK_PACKAGE_FUNCTION_SET =
        new WorkPackageLink<WorkPackageFunction>("WorkPackageFunctionSet");

    @Nonnull
    @Override
    public Class<WorkPackage> getType()
    {
        return WorkPackage.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @param workPackageID
     *            Work Package ID
     */
    public void setWorkPackageID( @Nullable final String workPackageID )
    {
        rememberChangedField("WorkPackageID", this.workPackageID);
        this.workPackageID = workPackageID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @param workPackageName
     *            Work Package Name
     */
    public void setWorkPackageName( @Nullable final String workPackageName )
    {
        rememberChangedField("WorkPackageName", this.workPackageName);
        this.workPackageName = workPackageName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Description</b>
     * </p>
     *
     * @param description
     *            Work Package Desc.
     */
    public void setDescription( @Nullable final String description )
    {
        rememberChangedField("Description", this.description);
        this.description = description;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPStartDate</b>
     * </p>
     *
     * @param wPStartDate
     *            Start Date
     */
    public void setWPStartDate( @Nullable final LocalDateTime wPStartDate )
    {
        rememberChangedField("WPStartDate", this.wPStartDate);
        this.wPStartDate = wPStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPEndDate</b>
     * </p>
     *
     * @param wPEndDate
     *            End Date
     */
    public void setWPEndDate( @Nullable final LocalDateTime wPEndDate )
    {
        rememberChangedField("WPEndDate", this.wPEndDate);
        this.wPEndDate = wPEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageType</b>
     * </p>
     *
     * @param workPackageType
     *            Work Package Type
     */
    public void setWorkPackageType( @Nullable final String workPackageType )
    {
        rememberChangedField("WorkPackageType", this.workPackageType);
        this.workPackageType = workPackageType;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitQuantity</b>
     * </p>
     *
     * @param unitQuantity
     *            Total Quantity
     */
    public void setUnitQuantity( @Nullable final BigDecimal unitQuantity )
    {
        rememberChangedField("UnitQuantity", this.unitQuantity);
        this.unitQuantity = unitQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>UnitId</b>
     * </p>
     *
     * @param unitId
     *            Resource ID
     */
    public void setUnitId( @Nullable final String unitId )
    {
        rememberChangedField("UnitId", this.unitId);
        this.unitId = unitId;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreatedOn</b>
     * </p>
     *
     * @param createdOn
     *            Created On
     */
    public void setCreatedOn( @Nullable final LocalDateTime createdOn )
    {
        rememberChangedField("CreatedOn", this.createdOn);
        this.createdOn = createdOn;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @param changedOn
     *            Changed On
     */
    public void setChangedOn( @Nullable final ZonedDateTime changedOn )
    {
        rememberChangedField("ChangedOn", this.changedOn);
        this.changedOn = changedOn;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WorkPackageSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        result.put("WorkPackageID", getWorkPackageID());
        result.put("WorkPackageName", getWorkPackageName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectID", getProjectID());
        values.put("WorkPackageID", getWorkPackageID());
        values.put("WorkPackageName", getWorkPackageName());
        values.put("Description", getDescription());
        values.put("WPStartDate", getWPStartDate());
        values.put("WPEndDate", getWPEndDate());
        values.put("WorkPackageType", getWorkPackageType());
        values.put("UnitQuantity", getUnitQuantity());
        values.put("UnitId", getUnitId());
        values.put("CreatedOn", getCreatedOn());
        values.put("ChangedOn", getChangedOn());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("WorkPackageID") ) {
                final Object value = values.remove("WorkPackageID");
                if( (value == null) || (!value.equals(getWorkPackageID())) ) {
                    setWorkPackageID(((String) value));
                }
            }
            if( values.containsKey("WorkPackageName") ) {
                final Object value = values.remove("WorkPackageName");
                if( (value == null) || (!value.equals(getWorkPackageName())) ) {
                    setWorkPackageName(((String) value));
                }
            }
            if( values.containsKey("Description") ) {
                final Object value = values.remove("Description");
                if( (value == null) || (!value.equals(getDescription())) ) {
                    setDescription(((String) value));
                }
            }
            if( values.containsKey("WPStartDate") ) {
                final Object value = values.remove("WPStartDate");
                if( (value == null) || (!value.equals(getWPStartDate())) ) {
                    setWPStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WPEndDate") ) {
                final Object value = values.remove("WPEndDate");
                if( (value == null) || (!value.equals(getWPEndDate())) ) {
                    setWPEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WorkPackageType") ) {
                final Object value = values.remove("WorkPackageType");
                if( (value == null) || (!value.equals(getWorkPackageType())) ) {
                    setWorkPackageType(((String) value));
                }
            }
            if( values.containsKey("UnitQuantity") ) {
                final Object value = values.remove("UnitQuantity");
                if( (value == null) || (!value.equals(getUnitQuantity())) ) {
                    setUnitQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitId") ) {
                final Object value = values.remove("UnitId");
                if( (value == null) || (!value.equals(getUnitId())) ) {
                    setUnitId(((String) value));
                }
            }
            if( values.containsKey("CreatedOn") ) {
                final Object value = values.remove("CreatedOn");
                if( (value == null) || (!value.equals(getCreatedOn())) ) {
                    setCreatedOn(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangedOn") ) {
                final Object value = values.remove("ChangedOn");
                if( (value == null) || (!value.equals(getChangedOn())) ) {
                    setChangedOn(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ResourceDemand") ) {
                final Object value = (values).remove("to_ResourceDemand");
                if( value instanceof Iterable ) {
                    if( toResourceDemand == null ) {
                        toResourceDemand = Lists.newArrayList();
                    } else {
                        toResourceDemand = Lists.newArrayList(toResourceDemand);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EngmntProjRsceDmnd entity;
                        if( toResourceDemand.size() > i ) {
                            entity = toResourceDemand.get(i);
                        } else {
                            entity = new EngmntProjRsceDmnd();
                            toResourceDemand.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Project") ) {
                final Object value = (values).remove("to_Project");
                if( value instanceof Map ) {
                    if( toProject == null ) {
                        toProject = new Project();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProject.fromMap(inputMap);
                }
            }
            if( (values).containsKey("WorkItemSet") ) {
                final Object value = (values).remove("WorkItemSet");
                if( value instanceof Iterable ) {
                    if( toWorkItemSet == null ) {
                        toWorkItemSet = Lists.newArrayList();
                    } else {
                        toWorkItemSet = Lists.newArrayList(toWorkItemSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkItem entity;
                        if( toWorkItemSet.size() > i ) {
                            entity = toWorkItemSet.get(i);
                        } else {
                            entity = new WorkItem();
                            toWorkItemSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("DemandSet") ) {
                final Object value = (values).remove("DemandSet");
                if( value instanceof Iterable ) {
                    if( toDemandSet == null ) {
                        toDemandSet = Lists.newArrayList();
                    } else {
                        toDemandSet = Lists.newArrayList(toDemandSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Demand entity;
                        if( toDemandSet.size() > i ) {
                            entity = toDemandSet.get(i);
                        } else {
                            entity = new Demand();
                            toDemandSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("WorkPackageFunctionSet") ) {
                final Object value = (values).remove("WorkPackageFunctionSet");
                if( value instanceof Iterable ) {
                    if( toWorkPackageFunctionSet == null ) {
                        toWorkPackageFunctionSet = Lists.newArrayList();
                    } else {
                        toWorkPackageFunctionSet = Lists.newArrayList(toWorkPackageFunctionSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkPackageFunction entity;
                        if( toWorkPackageFunctionSet.size() > i ) {
                            entity = toWorkPackageFunctionSet.get(i);
                        } else {
                            entity = new WorkPackageFunction();
                            toWorkPackageFunctionSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkPackageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkPackageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkPackageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkPackageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toResourceDemand != null ) {
            (values).put("to_ResourceDemand", toResourceDemand);
        }
        if( toProject != null ) {
            (values).put("to_Project", toProject);
        }
        if( toWorkItemSet != null ) {
            (values).put("WorkItemSet", toWorkItemSet);
        }
        if( toDemandSet != null ) {
            (values).put("DemandSet", toDemandSet);
        }
        if( toWorkPackageFunctionSet != null ) {
            (values).put("WorkPackageFunctionSet", toWorkPackageFunctionSet);
        }
        return values;
    }

    /**
     * Fetches the <b>EngmntProjRsceDmnd</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ResourceDemand</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EngmntProjRsceDmnd</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceDmnd> fetchResourceDemand()
    {
        return fetchFieldAsList("to_ResourceDemand", EngmntProjRsceDmnd.class);
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmnd</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemand</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EngmntProjRsceDmnd</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EngmntProjRsceDmnd> getResourceDemandOrFetch()
    {
        if( toResourceDemand == null ) {
            toResourceDemand = fetchResourceDemand();
        }
        return toResourceDemand;
    }

    /**
     * Retrieval of associated <b>EngmntProjRsceDmnd</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property for an entity <b>WorkPackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ResourceDemand</b> is already loaded, the result will
     *         contain the <b>EngmntProjRsceDmnd</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EngmntProjRsceDmnd>> getResourceDemandIfPresent()
    {
        return Option.of(toResourceDemand);
    }

    /**
     * Overwrites the list of associated <b>EngmntProjRsceDmnd</b> entities for the loaded navigation property
     * <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemand</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EngmntProjRsceDmnd</b> entities.
     */
    public void setResourceDemand( @Nonnull final List<EngmntProjRsceDmnd> value )
    {
        if( toResourceDemand == null ) {
            toResourceDemand = Lists.newArrayList();
        }
        toResourceDemand.clear();
        toResourceDemand.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EngmntProjRsceDmnd</b> entities. This corresponds to the OData
     * navigation property <b>to_ResourceDemand</b>.
     * <p>
     * If the navigation property <b>to_ResourceDemand</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EngmntProjRsceDmnd</b> entities.
     */
    public void addResourceDemand( EngmntProjRsceDmnd... entity )
    {
        if( toResourceDemand == null ) {
            toResourceDemand = Lists.newArrayList();
        }
        toResourceDemand.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>Project</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Project</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Project</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Project fetchProject()
    {
        return fetchFieldAsSingle("to_Project", Project.class);
    }

    /**
     * Retrieval of associated <b>Project</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Project</b>.
     * <p>
     * If the navigation property <b>to_Project</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Project</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Project getProjectOrFetch()
    {
        if( toProject == null ) {
            toProject = fetchProject();
        }
        return toProject;
    }

    /**
     * Retrieval of associated <b>Project</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Project</b>.
     * <p>
     * If the navigation property for an entity <b>WorkPackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Project</b> is already loaded, the result will contain
     *         the <b>Project</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Project> getProjectIfPresent()
    {
        return Option.of(toProject);
    }

    /**
     * Overwrites the associated <b>Project</b> entity for the loaded navigation property <b>to_Project</b>.
     *
     * @param value
     *            New <b>Project</b> entity.
     */
    public void setProject( final Project value )
    {
        toProject = value;
    }

    /**
     * Fetches the <b>WorkItem</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>WorkItemSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkItem</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkItem> fetchWorkItemSet()
    {
        return fetchFieldAsList("WorkItemSet", WorkItem.class);
    }

    /**
     * Retrieval of associated <b>WorkItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>WorkItemSet</b>.
     * <p>
     * If the navigation property <b>WorkItemSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkItem> getWorkItemSetOrFetch()
    {
        if( toWorkItemSet == null ) {
            toWorkItemSet = fetchWorkItemSet();
        }
        return toWorkItemSet;
    }

    /**
     * Retrieval of associated <b>WorkItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>WorkItemSet</b>.
     * <p>
     * If the navigation property for an entity <b>WorkPackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>WorkItemSet</b> is already loaded, the result will contain
     *         the <b>WorkItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<WorkItem>> getWorkItemSetIfPresent()
    {
        return Option.of(toWorkItemSet);
    }

    /**
     * Overwrites the list of associated <b>WorkItem</b> entities for the loaded navigation property <b>WorkItemSet</b>.
     * <p>
     * If the navigation property <b>WorkItemSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkItem</b> entities.
     */
    public void setWorkItemSet( @Nonnull final List<WorkItem> value )
    {
        if( toWorkItemSet == null ) {
            toWorkItemSet = Lists.newArrayList();
        }
        toWorkItemSet.clear();
        toWorkItemSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkItem</b> entities. This corresponds to the OData navigation
     * property <b>WorkItemSet</b>.
     * <p>
     * If the navigation property <b>WorkItemSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkItem</b> entities.
     */
    public void addWorkItemSet( WorkItem... entity )
    {
        if( toWorkItemSet == null ) {
            toWorkItemSet = Lists.newArrayList();
        }
        toWorkItemSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>Demand</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>DemandSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>Demand</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Demand> fetchDemandSet()
    {
        return fetchFieldAsList("DemandSet", Demand.class);
    }

    /**
     * Retrieval of associated <b>Demand</b> entities (one to many). This corresponds to the OData navigation property
     * <b>DemandSet</b>.
     * <p>
     * If the navigation property <b>DemandSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Demand</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Demand> getDemandSetOrFetch()
    {
        if( toDemandSet == null ) {
            toDemandSet = fetchDemandSet();
        }
        return toDemandSet;
    }

    /**
     * Retrieval of associated <b>Demand</b> entities (one to many). This corresponds to the OData navigation property
     * <b>DemandSet</b>.
     * <p>
     * If the navigation property for an entity <b>WorkPackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>DemandSet</b> is already loaded, the result will contain
     *         the <b>Demand</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<Demand>> getDemandSetIfPresent()
    {
        return Option.of(toDemandSet);
    }

    /**
     * Overwrites the list of associated <b>Demand</b> entities for the loaded navigation property <b>DemandSet</b>.
     * <p>
     * If the navigation property <b>DemandSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>Demand</b> entities.
     */
    public void setDemandSet( @Nonnull final List<Demand> value )
    {
        if( toDemandSet == null ) {
            toDemandSet = Lists.newArrayList();
        }
        toDemandSet.clear();
        toDemandSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Demand</b> entities. This corresponds to the OData navigation property
     * <b>DemandSet</b>.
     * <p>
     * If the navigation property <b>DemandSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>Demand</b> entities.
     */
    public void addDemandSet( Demand... entity )
    {
        if( toDemandSet == null ) {
            toDemandSet = Lists.newArrayList();
        }
        toDemandSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkPackageFunction</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkPackageFunction</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkPackageFunction> fetchWorkPackageFunctionSet()
    {
        return fetchFieldAsList("WorkPackageFunctionSet", WorkPackageFunction.class);
    }

    /**
     * Retrieval of associated <b>WorkPackageFunction</b> entities (one to many). This corresponds to the OData
     * navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageFunctionSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkPackageFunction</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkPackageFunction> getWorkPackageFunctionSetOrFetch()
    {
        if( toWorkPackageFunctionSet == null ) {
            toWorkPackageFunctionSet = fetchWorkPackageFunctionSet();
        }
        return toWorkPackageFunctionSet;
    }

    /**
     * Retrieval of associated <b>WorkPackageFunction</b> entities (one to many). This corresponds to the OData
     * navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property for an entity <b>WorkPackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>WorkPackageFunctionSet</b> is already loaded, the result
     *         will contain the <b>WorkPackageFunction</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkPackageFunction>> getWorkPackageFunctionSetIfPresent()
    {
        return Option.of(toWorkPackageFunctionSet);
    }

    /**
     * Overwrites the list of associated <b>WorkPackageFunction</b> entities for the loaded navigation property
     * <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageFunctionSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkPackageFunction</b> entities.
     */
    public void setWorkPackageFunctionSet( @Nonnull final List<WorkPackageFunction> value )
    {
        if( toWorkPackageFunctionSet == null ) {
            toWorkPackageFunctionSet = Lists.newArrayList();
        }
        toWorkPackageFunctionSet.clear();
        toWorkPackageFunctionSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkPackageFunction</b> entities. This corresponds to the OData
     * navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageFunctionSet</b> of a queried <b>WorkPackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkPackageFunction</b> entities.
     */
    public void addWorkPackageFunctionSet( WorkPackageFunction... entity )
    {
        if( toWorkPackageFunctionSet == null ) {
            toWorkPackageFunctionSet = Lists.newArrayList();
        }
        toWorkPackageFunctionSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkPackage instances.
     *
     */
    public final static class WorkPackageBuilder
    {

        private List<EngmntProjRsceDmnd> toResourceDemand = Lists.newArrayList();
        private Project toProject;
        private List<WorkItem> toWorkItemSet = Lists.newArrayList();
        private List<Demand> toDemandSet = Lists.newArrayList();
        private List<WorkPackageFunction> toWorkPackageFunctionSet = Lists.newArrayList();

        private WorkPackage.WorkPackageBuilder toResourceDemand( final List<EngmntProjRsceDmnd> value )
        {
            toResourceDemand.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ResourceDemand</b> for <b>WorkPackage</b> to multiple <b>EngmntProjRsceDmnd</b>.
         *
         * @param value
         *            The EngmntProjRsceDmnds to build this WorkPackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkPackage.WorkPackageBuilder resourceDemand( EngmntProjRsceDmnd... value )
        {
            return toResourceDemand(Lists.newArrayList(value));
        }

        private WorkPackage.WorkPackageBuilder toProject( final Project value )
        {
            toProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_Project</b> for <b>WorkPackage</b> to single <b>Project</b>.
         *
         * @param value
         *            The Project to build this WorkPackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkPackage.WorkPackageBuilder project( final Project value )
        {
            return toProject(value);
        }

        private WorkPackage.WorkPackageBuilder toWorkItemSet( final List<WorkItem> value )
        {
            toWorkItemSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>WorkItemSet</b> for <b>WorkPackage</b> to multiple <b>WorkItem</b>.
         *
         * @param value
         *            The WorkItems to build this WorkPackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkPackage.WorkPackageBuilder workItemSet( WorkItem... value )
        {
            return toWorkItemSet(Lists.newArrayList(value));
        }

        private WorkPackage.WorkPackageBuilder toDemandSet( final List<Demand> value )
        {
            toDemandSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>DemandSet</b> for <b>WorkPackage</b> to multiple <b>Demand</b>.
         *
         * @param value
         *            The Demands to build this WorkPackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkPackage.WorkPackageBuilder demandSet( Demand... value )
        {
            return toDemandSet(Lists.newArrayList(value));
        }

        private WorkPackage.WorkPackageBuilder toWorkPackageFunctionSet( final List<WorkPackageFunction> value )
        {
            toWorkPackageFunctionSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>WorkPackageFunctionSet</b> for <b>WorkPackage</b> to multiple
         * <b>WorkPackageFunction</b>.
         *
         * @param value
         *            The WorkPackageFunctions to build this WorkPackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkPackage.WorkPackageBuilder workPackageFunctionSet( WorkPackageFunction... value )
        {
            return toWorkPackageFunctionSet(Lists.newArrayList(value));
        }

    }

}
