/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.WorkPackageFunctionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.WorkPackageFunctionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Work Package Functions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WorkPackageFunction</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkPackageFunction extends VdmEntity<WorkPackageFunction>
{

    /**
     * Selector for all available fields of WorkPackageFunction.
     *
     */
    public final static WorkPackageFunctionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static WorkPackageFunctionField<String> PROJECT_ID = new WorkPackageFunctionField<String>("ProjectID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackageID" )
    @JsonProperty( "WorkPackageID" )
    @Nullable
    @ODataField( odataName = "WorkPackageID" )
    private String workPackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageID</b> field to query operations.
     *
     */
    public final static WorkPackageFunctionField<String> WORK_PACKAGE_ID =
        new WorkPackageFunctionField<String>("WorkPackageID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @return Work Package Name
     */
    @Key
    @SerializedName( "WorkPackageName" )
    @JsonProperty( "WorkPackageName" )
    @Nullable
    @ODataField( odataName = "WorkPackageName" )
    private String workPackageName;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageName</b> field to query operations.
     *
     */
    public final static WorkPackageFunctionField<String> WORK_PACKAGE_NAME =
        new WorkPackageFunctionField<String>("WorkPackageName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageFunctionId</b>
     * </p>
     *
     * @return Work Package Function ID
     */
    @Key
    @SerializedName( "WorkPackageFunctionId" )
    @JsonProperty( "WorkPackageFunctionId" )
    @Nullable
    @ODataField( odataName = "WorkPackageFunctionId" )
    private String workPackageFunctionId;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageFunctionId</b> field to query operations.
     *
     */
    public final static WorkPackageFunctionField<String> WORK_PACKAGE_FUNCTION_ID =
        new WorkPackageFunctionField<String>("WorkPackageFunctionId");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageFunctionName</b>
     * </p>
     *
     * @return Work Package Function Name
     */
    @SerializedName( "WorkPackageFunctionName" )
    @JsonProperty( "WorkPackageFunctionName" )
    @Nullable
    @ODataField( odataName = "WorkPackageFunctionName" )
    private String workPackageFunctionName;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageFunctionName</b> field to query operations.
     *
     */
    public final static WorkPackageFunctionField<String> WORK_PACKAGE_FUNCTION_NAME =
        new WorkPackageFunctionField<String>("WorkPackageFunctionName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageFunctionIsBlocked</b>
     * </p>
     *
     * @return Work Package Function Is Blocked
     */
    @SerializedName( "WorkPackageFunctionIsBlocked" )
    @JsonProperty( "WorkPackageFunctionIsBlocked" )
    @Nullable
    @ODataField( odataName = "WorkPackageFunctionIsBlocked" )
    private String workPackageFunctionIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageFunctionIsBlocked</b> field to query operations.
     *
     */
    public final static WorkPackageFunctionField<String> WORK_PACKAGE_FUNCTION_IS_BLOCKED =
        new WorkPackageFunctionField<String>("WorkPackageFunctionIsBlocked");

    @Nonnull
    @Override
    public Class<WorkPackageFunction> getType()
    {
        return WorkPackageFunction.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @param workPackageID
     *            Work Package ID
     */
    public void setWorkPackageID( @Nullable final String workPackageID )
    {
        rememberChangedField("WorkPackageID", this.workPackageID);
        this.workPackageID = workPackageID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @param workPackageName
     *            Work Package Name
     */
    public void setWorkPackageName( @Nullable final String workPackageName )
    {
        rememberChangedField("WorkPackageName", this.workPackageName);
        this.workPackageName = workPackageName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageFunctionId</b>
     * </p>
     *
     * @param workPackageFunctionId
     *            Work Package Function ID
     */
    public void setWorkPackageFunctionId( @Nullable final String workPackageFunctionId )
    {
        rememberChangedField("WorkPackageFunctionId", this.workPackageFunctionId);
        this.workPackageFunctionId = workPackageFunctionId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageFunctionName</b>
     * </p>
     *
     * @param workPackageFunctionName
     *            Work Package Function Name
     */
    public void setWorkPackageFunctionName( @Nullable final String workPackageFunctionName )
    {
        rememberChangedField("WorkPackageFunctionName", this.workPackageFunctionName);
        this.workPackageFunctionName = workPackageFunctionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageFunctionIsBlocked</b>
     * </p>
     *
     * @param workPackageFunctionIsBlocked
     *            Work Package Function Is Blocked
     */
    public void setWorkPackageFunctionIsBlocked( @Nullable final String workPackageFunctionIsBlocked )
    {
        rememberChangedField("WorkPackageFunctionIsBlocked", this.workPackageFunctionIsBlocked);
        this.workPackageFunctionIsBlocked = workPackageFunctionIsBlocked;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WorkPackageFunctionSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        result.put("WorkPackageID", getWorkPackageID());
        result.put("WorkPackageName", getWorkPackageName());
        result.put("WorkPackageFunctionId", getWorkPackageFunctionId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectID", getProjectID());
        values.put("WorkPackageID", getWorkPackageID());
        values.put("WorkPackageName", getWorkPackageName());
        values.put("WorkPackageFunctionId", getWorkPackageFunctionId());
        values.put("WorkPackageFunctionName", getWorkPackageFunctionName());
        values.put("WorkPackageFunctionIsBlocked", getWorkPackageFunctionIsBlocked());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("WorkPackageID") ) {
                final Object value = values.remove("WorkPackageID");
                if( (value == null) || (!value.equals(getWorkPackageID())) ) {
                    setWorkPackageID(((String) value));
                }
            }
            if( values.containsKey("WorkPackageName") ) {
                final Object value = values.remove("WorkPackageName");
                if( (value == null) || (!value.equals(getWorkPackageName())) ) {
                    setWorkPackageName(((String) value));
                }
            }
            if( values.containsKey("WorkPackageFunctionId") ) {
                final Object value = values.remove("WorkPackageFunctionId");
                if( (value == null) || (!value.equals(getWorkPackageFunctionId())) ) {
                    setWorkPackageFunctionId(((String) value));
                }
            }
            if( values.containsKey("WorkPackageFunctionName") ) {
                final Object value = values.remove("WorkPackageFunctionName");
                if( (value == null) || (!value.equals(getWorkPackageFunctionName())) ) {
                    setWorkPackageFunctionName(((String) value));
                }
            }
            if( values.containsKey("WorkPackageFunctionIsBlocked") ) {
                final Object value = values.remove("WorkPackageFunctionIsBlocked");
                if( (value == null) || (!value.equals(getWorkPackageFunctionIsBlocked())) ) {
                    setWorkPackageFunctionIsBlocked(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkPackageFunctionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkPackageFunctionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkPackageFunctionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkPackageFunctionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

}
