/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService CommercialProjectService}.
 *
 */
public interface CommercialProjectServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CommercialProjectServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CommercialProjectServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     * CustProjSlsOrd} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *            CustProjSlsOrd} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet createCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     * CustProjSlsOrd} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd
     *            CustProjSlsOrd} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet updateCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *            CustProjSlsOrdItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdItem( @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *            CustProjSlsOrdItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateCustProjSlsOrdItem( @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     * CustProjSlsOrdItem} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem
     *            CustProjSlsOrdItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteCustProjSlsOrdItem( @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     * CustProjSlsOrdItemPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *            CustProjSlsOrdItemPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdItemPartner( @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     * CustProjSlsOrdItemPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner
     *            CustProjSlsOrdItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateCustProjSlsOrdItemPartner( @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *            CustProjSlsOrdItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdItemText( @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *            CustProjSlsOrdItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateCustProjSlsOrdItemText( @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     * CustProjSlsOrdItemText} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText
     *            CustProjSlsOrdItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteCustProjSlsOrdItemText( @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItemWorkPckg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *            CustProjSlsOrdItemWorkPckg} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdItemWorkPckg( @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     * CustProjSlsOrdItemWorkPckg} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItemWorkPckg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
     *            CustProjSlsOrdItemWorkPckg} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteCustProjSlsOrdItemWorkPckg( @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItmBillgPlnItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *            CustProjSlsOrdItmBillgPlnItm} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdItmBillgPlnItm( @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdItmBillgPlnItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *            CustProjSlsOrdItmBillgPlnItm} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateCustProjSlsOrdItmBillgPlnItm( @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     * CustProjSlsOrdItmBillgPlnItm} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdItmBillgPlnItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
     *            CustProjSlsOrdItmBillgPlnItm} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteCustProjSlsOrdItmBillgPlnItm( @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     * CustProjSlsOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *            CustProjSlsOrdPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdPartner( @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     * CustProjSlsOrdPartner} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner
     *            CustProjSlsOrdPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateCustProjSlsOrdPartner( @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *            CustProjSlsOrdText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createCustProjSlsOrdText( @Nonnull final CustProjSlsOrdText custProjSlsOrdText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity and save it to the S/4HANA system.
     *
     * @param custProjSlsOrdText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *            CustProjSlsOrdText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateCustProjSlsOrdText( @Nonnull final CustProjSlsOrdText custProjSlsOrdText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     * CustProjSlsOrdText} entity in the S/4HANA system.
     *
     * @param custProjSlsOrdText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText
     *            CustProjSlsOrdText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteCustProjSlsOrdText( @Nonnull final CustProjSlsOrdText custProjSlsOrdText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmnd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *            EngmntProjRsceDmnd} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createEngmntProjRsceDmnd( @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmnd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *            EngmntProjRsceDmnd} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateEngmntProjRsceDmnd( @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     * EngmntProjRsceDmnd} entity in the S/4HANA system.
     *
     * @param engmntProjRsceDmnd
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd
     *            EngmntProjRsceDmnd} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteEngmntProjRsceDmnd( @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmndDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *            EngmntProjRsceDmndDistr} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createEngmntProjRsceDmndDistr( @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceDmndDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *            EngmntProjRsceDmndDistr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateEngmntProjRsceDmndDistr( @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     * EngmntProjRsceDmndDistr} entity in the S/4HANA system.
     *
     * @param engmntProjRsceDmndDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr
     *            EngmntProjRsceDmndDistr} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteEngmntProjRsceDmndDistr( @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     * EngmntProjRsceSup} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *            EngmntProjRsceSup} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createEngmntProjRsceSup( @Nonnull final EngmntProjRsceSup engmntProjRsceSup );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     * EngmntProjRsceSup} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *            EngmntProjRsceSup} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateEngmntProjRsceSup( @Nonnull final EngmntProjRsceSup engmntProjRsceSup );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup EngmntProjRsceSup}
     * entity in the S/4HANA system.
     *
     * @param engmntProjRsceSup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup
     *            EngmntProjRsceSup} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteEngmntProjRsceSup( @Nonnull final EngmntProjRsceSup engmntProjRsceSup );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSupDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *            EngmntProjRsceSupDistr} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createEngmntProjRsceSupDistr( @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity and save it to the S/4HANA system.
     *
     * @param engmntProjRsceSupDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *            EngmntProjRsceSupDistr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateEngmntProjRsceSupDistr( @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     * EngmntProjRsceSupDistr} entity in the S/4HANA system.
     *
     * @param engmntProjRsceSupDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr
     *            EngmntProjRsceSupDistr} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        deleteEngmntProjRsceSupDistr( @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     * WorkPackageFunction} entity and save it to the S/4HANA system.
     *
     * @param workPackageFunction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *            WorkPackageFunction} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        createWorkPackageFunction( @Nonnull final WorkPackageFunction workPackageFunction );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     * WorkPackageFunction} entity and save it to the S/4HANA system.
     *
     * @param workPackageFunction
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
     *            WorkPackageFunction} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet
        updateWorkPackageFunction( @Nonnull final WorkPackageFunction workPackageFunction );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     * and save it to the S/4HANA system.
     *
     * @param project
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet createProject( @Nonnull final Project project );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project}
     * entity and save it to the S/4HANA system.
     *
     * @param project
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project Project} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet updateProject( @Nonnull final Project project );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity and save it to the S/4HANA system.
     *
     * @param workPackage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet createWorkPackage( @Nonnull final WorkPackage workPackage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity and save it to the S/4HANA system.
     *
     * @param workPackage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet updateWorkPackage( @Nonnull final WorkPackage workPackage );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage
     * WorkPackage} entity in the S/4HANA system.
     *
     * @param workPackage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage WorkPackage}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet deleteWorkPackage( @Nonnull final WorkPackage workPackage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem}
     * entity and save it to the S/4HANA system.
     *
     * @param workItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet createWorkItem( @Nonnull final WorkItem workItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem
     * WorkItem} entity in the S/4HANA system.
     *
     * @param workItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem} entity
     *            object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet deleteWorkItem( @Nonnull final WorkItem workItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     * and save it to the S/4HANA system.
     *
     * @param demand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet createDemand( @Nonnull final Demand demand );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand}
     * entity and save it to the S/4HANA system.
     *
     * @param demand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet updateDemand( @Nonnull final Demand demand );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand}
     * entity in the S/4HANA system.
     *
     * @param demand
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand} entity
     *            object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet deleteDemand( @Nonnull final Demand demand );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity and save it to the S/4HANA system.
     *
     * @param projectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet createProjectRole( @Nonnull final ProjectRole projectRole );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity and save it to the S/4HANA system.
     *
     * @param projectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet updateProjectRole( @Nonnull final ProjectRole projectRole );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole
     * ProjectRole} entity in the S/4HANA system.
     *
     * @param projectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole ProjectRole}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CommercialProjectServiceBatchChangeSet deleteProjectRole( @Nonnull final ProjectRole projectRole );

}
