/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CommercialProjectServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService CommercialProjectService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCommercialProjectServiceBatch
    extends
    BatchFluentHelperBasic<CommercialProjectServiceBatch, CommercialProjectServiceBatchChangeSet>
    implements
    CommercialProjectServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCommercialProjectServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCommercialProjectServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCommercialProjectServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCommercialProjectServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCommercialProjectServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCommercialProjectServiceBatchChangeSet(this, service);
    }

}
