/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmnd;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceSupDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Project;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.ProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction;

/**
 * Implementation of the {@link CommercialProjectServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService CommercialProjectService}.
 *
 */
public class DefaultCommercialProjectServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CommercialProjectServiceBatch, CommercialProjectServiceBatchChangeSet>
    implements
    CommercialProjectServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService service;

    @SuppressWarnings( "deprecation" )
    DefaultCommercialProjectServiceBatchChangeSet(
        @Nonnull final DefaultCommercialProjectServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCommercialProjectServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd )
    {
        return addRequestCreate(service::createCustProjSlsOrd, custProjSlsOrd);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrd( @Nonnull final CustProjSlsOrd custProjSlsOrd )
    {
        return addRequestUpdate(service::updateCustProjSlsOrd, custProjSlsOrd);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdItem(
        @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem )
    {
        return addRequestCreate(service::createCustProjSlsOrdItem, custProjSlsOrdItem);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrdItem(
        @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem )
    {
        return addRequestUpdate(service::updateCustProjSlsOrdItem, custProjSlsOrdItem);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteCustProjSlsOrdItem(
        @Nonnull final CustProjSlsOrdItem custProjSlsOrdItem )
    {
        return addRequestDelete(service::deleteCustProjSlsOrdItem, custProjSlsOrdItem);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdItemPartner(
        @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner )
    {
        return addRequestCreate(service::createCustProjSlsOrdItemPartner, custProjSlsOrdItemPartner);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrdItemPartner(
        @Nonnull final CustProjSlsOrdItemPartner custProjSlsOrdItemPartner )
    {
        return addRequestUpdate(service::updateCustProjSlsOrdItemPartner, custProjSlsOrdItemPartner);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdItemText(
        @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText )
    {
        return addRequestCreate(service::createCustProjSlsOrdItemText, custProjSlsOrdItemText);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrdItemText(
        @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText )
    {
        return addRequestUpdate(service::updateCustProjSlsOrdItemText, custProjSlsOrdItemText);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteCustProjSlsOrdItemText(
        @Nonnull final CustProjSlsOrdItemText custProjSlsOrdItemText )
    {
        return addRequestDelete(service::deleteCustProjSlsOrdItemText, custProjSlsOrdItemText);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdItemWorkPckg(
        @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg )
    {
        return addRequestCreate(service::createCustProjSlsOrdItemWorkPckg, custProjSlsOrdItemWorkPckg);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteCustProjSlsOrdItemWorkPckg(
        @Nonnull final CustProjSlsOrdItemWorkPckg custProjSlsOrdItemWorkPckg )
    {
        return addRequestDelete(service::deleteCustProjSlsOrdItemWorkPckg, custProjSlsOrdItemWorkPckg);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdItmBillgPlnItm(
        @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm )
    {
        return addRequestCreate(service::createCustProjSlsOrdItmBillgPlnItm, custProjSlsOrdItmBillgPlnItm);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrdItmBillgPlnItm(
        @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm )
    {
        return addRequestUpdate(service::updateCustProjSlsOrdItmBillgPlnItm, custProjSlsOrdItmBillgPlnItm);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteCustProjSlsOrdItmBillgPlnItm(
        @Nonnull final CustProjSlsOrdItmBillgPlnItm custProjSlsOrdItmBillgPlnItm )
    {
        return addRequestDelete(service::deleteCustProjSlsOrdItmBillgPlnItm, custProjSlsOrdItmBillgPlnItm);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdPartner(
        @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner )
    {
        return addRequestCreate(service::createCustProjSlsOrdPartner, custProjSlsOrdPartner);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrdPartner(
        @Nonnull final CustProjSlsOrdPartner custProjSlsOrdPartner )
    {
        return addRequestUpdate(service::updateCustProjSlsOrdPartner, custProjSlsOrdPartner);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createCustProjSlsOrdText(
        @Nonnull final CustProjSlsOrdText custProjSlsOrdText )
    {
        return addRequestCreate(service::createCustProjSlsOrdText, custProjSlsOrdText);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateCustProjSlsOrdText(
        @Nonnull final CustProjSlsOrdText custProjSlsOrdText )
    {
        return addRequestUpdate(service::updateCustProjSlsOrdText, custProjSlsOrdText);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteCustProjSlsOrdText(
        @Nonnull final CustProjSlsOrdText custProjSlsOrdText )
    {
        return addRequestDelete(service::deleteCustProjSlsOrdText, custProjSlsOrdText);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createEngmntProjRsceDmnd(
        @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd )
    {
        return addRequestCreate(service::createEngmntProjRsceDmnd, engmntProjRsceDmnd);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateEngmntProjRsceDmnd(
        @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd )
    {
        return addRequestUpdate(service::updateEngmntProjRsceDmnd, engmntProjRsceDmnd);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteEngmntProjRsceDmnd(
        @Nonnull final EngmntProjRsceDmnd engmntProjRsceDmnd )
    {
        return addRequestDelete(service::deleteEngmntProjRsceDmnd, engmntProjRsceDmnd);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createEngmntProjRsceDmndDistr(
        @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr )
    {
        return addRequestCreate(service::createEngmntProjRsceDmndDistr, engmntProjRsceDmndDistr);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateEngmntProjRsceDmndDistr(
        @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr )
    {
        return addRequestUpdate(service::updateEngmntProjRsceDmndDistr, engmntProjRsceDmndDistr);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteEngmntProjRsceDmndDistr(
        @Nonnull final EngmntProjRsceDmndDistr engmntProjRsceDmndDistr )
    {
        return addRequestDelete(service::deleteEngmntProjRsceDmndDistr, engmntProjRsceDmndDistr);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createEngmntProjRsceSup(
        @Nonnull final EngmntProjRsceSup engmntProjRsceSup )
    {
        return addRequestCreate(service::createEngmntProjRsceSup, engmntProjRsceSup);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateEngmntProjRsceSup(
        @Nonnull final EngmntProjRsceSup engmntProjRsceSup )
    {
        return addRequestUpdate(service::updateEngmntProjRsceSup, engmntProjRsceSup);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteEngmntProjRsceSup(
        @Nonnull final EngmntProjRsceSup engmntProjRsceSup )
    {
        return addRequestDelete(service::deleteEngmntProjRsceSup, engmntProjRsceSup);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createEngmntProjRsceSupDistr(
        @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr )
    {
        return addRequestCreate(service::createEngmntProjRsceSupDistr, engmntProjRsceSupDistr);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateEngmntProjRsceSupDistr(
        @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr )
    {
        return addRequestUpdate(service::updateEngmntProjRsceSupDistr, engmntProjRsceSupDistr);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteEngmntProjRsceSupDistr(
        @Nonnull final EngmntProjRsceSupDistr engmntProjRsceSupDistr )
    {
        return addRequestDelete(service::deleteEngmntProjRsceSupDistr, engmntProjRsceSupDistr);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createWorkPackageFunction(
        @Nonnull final WorkPackageFunction workPackageFunction )
    {
        return addRequestCreate(service::createWorkPackageFunction, workPackageFunction);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateWorkPackageFunction(
        @Nonnull final WorkPackageFunction workPackageFunction )
    {
        return addRequestUpdate(service::updateWorkPackageFunction, workPackageFunction);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createProject( @Nonnull final Project project )
    {
        return addRequestCreate(service::createProject, project);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateProject( @Nonnull final Project project )
    {
        return addRequestUpdate(service::updateProject, project);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createWorkPackage( @Nonnull final WorkPackage workPackage )
    {
        return addRequestCreate(service::createWorkPackage, workPackage);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateWorkPackage( @Nonnull final WorkPackage workPackage )
    {
        return addRequestUpdate(service::updateWorkPackage, workPackage);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteWorkPackage( @Nonnull final WorkPackage workPackage )
    {
        return addRequestDelete(service::deleteWorkPackage, workPackage);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createWorkItem( @Nonnull final WorkItem workItem )
    {
        return addRequestCreate(service::createWorkItem, workItem);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteWorkItem( @Nonnull final WorkItem workItem )
    {
        return addRequestDelete(service::deleteWorkItem, workItem);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createDemand( @Nonnull final Demand demand )
    {
        return addRequestCreate(service::createDemand, demand);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateDemand( @Nonnull final Demand demand )
    {
        return addRequestUpdate(service::updateDemand, demand);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteDemand( @Nonnull final Demand demand )
    {
        return addRequestDelete(service::deleteDemand, demand);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet createProjectRole( @Nonnull final ProjectRole projectRole )
    {
        return addRequestCreate(service::createProjectRole, projectRole);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet updateProjectRole( @Nonnull final ProjectRole projectRole )
    {
        return addRequestUpdate(service::updateProjectRole, projectRole);
    }

    @Nonnull
    @Override
    public CommercialProjectServiceBatchChangeSet deleteProjectRole( @Nonnull final ProjectRole projectRole )
    {
        return addRequestDelete(service::deleteProjectRole, projectRole);
    }

}
