/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable.CustProjSlsOrdTextSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdText CustProjSlsOrdText}
 * to other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class CustProjSlsOrdTextLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<CustProjSlsOrdTextLink<ObjectT>, CustProjSlsOrdText, ObjectT>
    implements
    CustProjSlsOrdTextSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public CustProjSlsOrdTextLink( final String fieldName )
    {
        super(fieldName);
    }

    private CustProjSlsOrdTextLink(
        final EntityLink<CustProjSlsOrdTextLink<ObjectT>, CustProjSlsOrdText, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected CustProjSlsOrdTextLink<ObjectT> translateLinkType(
        final EntityLink<CustProjSlsOrdTextLink<ObjectT>, CustProjSlsOrdText, ObjectT> link )
    {
        return new CustProjSlsOrdTextLink<ObjectT>(link);
    }

}
