/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg
 * CustProjSlsOrdItemWorkPckg}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.CustProjSlsOrdItemWorkPckgField
 * CustProjSlsOrdItemWorkPckgField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.CustProjSlsOrdItemWorkPckgLink
 * CustProjSlsOrdItemWorkPckgLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#CUSTOMER_PROJECT
 * CUSTOMER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#WORK_PACKAGE
 * WORK_PACKAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#WORK_PACKAGE_NAME
 * WORK_PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#WORK_PACKAGE_START_DATE
 * WORK_PACKAGE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItemWorkPckg#WORK_PACKAGE_END_DATE
 * WORK_PACKAGE_END_DATE}</li>
 * </ul>
 *
 */
public interface CustProjSlsOrdItemWorkPckgSelectable extends EntitySelectable<CustProjSlsOrdItemWorkPckg>
{

}
