/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm
 * CustProjSlsOrdItmBillgPlnItm}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.CustProjSlsOrdItmBillgPlnItmField
 * CustProjSlsOrdItmBillgPlnItmField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.CustProjSlsOrdItmBillgPlnItmLink
 * CustProjSlsOrdItmBillgPlnItmLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#CUSTOMER_PROJECT
 * CUSTOMER_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_ITEM
 * BILLING_PLAN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_BILLING_DATE
 * BILLING_PLAN_BILLING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_RELATED_BILLG_STATUS
 * BILLING_PLAN_RELATED_BILLG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_AMOUNT
 * BILLING_PLAN_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_ITEM_USAGE
 * BILLING_PLAN_ITEM_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_ITEM_DESCRIPTION
 * BILLING_PLAN_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_SERVICE_START_DATE
 * BILLING_PLAN_SERVICE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.CustProjSlsOrdItmBillgPlnItm#BILLING_PLAN_SERVICE_END_DATE
 * BILLING_PLAN_SERVICE_END_DATE}</li>
 * </ul>
 *
 */
public interface CustProjSlsOrdItmBillgPlnItmSelectable extends EntitySelectable<CustProjSlsOrdItmBillgPlnItm>
{

}
