/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand Demand}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.DemandField DemandField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.DemandLink DemandLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#BILLING_CONTROL_CATEGORY
 * BILLING_CONTROL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#PROJECT_ID PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#UOM UOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#SKILLS SKILLS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#WORK_PACKAGE_ID
 * WORK_PACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#EXPENSE_COST
 * EXPENSE_COST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#WORK_PACKAGE_NAME
 * WORK_PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#EXPENSE_REVENUE
 * EXPENSE_REVENUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#RES_TYPE RES_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#RESOURCE_ID RESOURCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#WORKITEM WORKITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#EFFORT EFFORT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.Demand#DELVRY_SERV_ORG
 * DELVRY_SERV_ORG}</li>
 * </ul>
 *
 */
public interface DemandSelectable extends EntitySelectable<Demand>
{

}
