/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill
 * EngmntProjRsceDmndSkill}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.EngmntProjRsceDmndSkillField
 * EngmntProjRsceDmndSkillField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.EngmntProjRsceDmndSkillLink
 * EngmntProjRsceDmndSkillLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill#WORK_PACKAGE
 * WORK_PACKAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill#RESOURCE_DEMAND
 * RESOURCE_DEMAND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill#VERSION
 * VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.EngmntProjRsceDmndSkill#SKILL_TAG_DESCRIPTION
 * SKILL_TAG_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface EngmntProjRsceDmndSkillSelectable extends EntitySelectable<EngmntProjRsceDmndSkill>
{

}
