/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem WorkItem}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.WorkItemField
 * WorkItemField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.WorkItemLink
 * WorkItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem#PROJECT_ID PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem#WORK_PACKAGE_ID
 * WORK_PACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem#WORK_PACKAGE_NAME
 * WORK_PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem#WORKITEM WORKITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkItem#WORKITEMNAME
 * WORKITEMNAME}</li>
 * </ul>
 *
 */
public interface WorkItemSelectable extends EntitySelectable<WorkItem>
{

}
