/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction
 * WorkPackageFunction}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.field.WorkPackageFunctionField
 * WorkPackageFunctionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.link.WorkPackageFunctionLink
 * WorkPackageFunctionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction#PROJECT_ID
 * PROJECT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction#WORK_PACKAGE_ID
 * WORK_PACKAGE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction#WORK_PACKAGE_NAME
 * WORK_PACKAGE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction#WORK_PACKAGE_FUNCTION_ID
 * WORK_PACKAGE_FUNCTION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction#WORK_PACKAGE_FUNCTION_NAME
 * WORK_PACKAGE_FUNCTION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialproject.WorkPackageFunction#WORK_PACKAGE_FUNCTION_IS_BLOCKED
 * WORK_PACKAGE_FUNCTION_IS_BLOCKED}</li>
 * </ul>
 *
 */
public interface WorkPackageFunctionSelectable extends EntitySelectable<WorkPackageFunction>
{

}
