/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.PlanDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.PlanDataLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.PlanDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Plan Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PlanData</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlanData extends VdmEntity<PlanData>
{

    /**
     * Selector for all available fields of PlanData.
     *
     */
    public final static PlanDataSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @return Billing Category
     */
    @SerializedName( "BillingControlCategory" )
    @JsonProperty( "BillingControlCategory" )
    @Nullable
    @ODataField( odataName = "BillingControlCategory" )
    private String billingControlCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingControlCategory</b> field to query operations.
     *
     */
    public final static PlanDataField<String> BILLING_CONTROL_CATEGORY =
        new PlanDataField<String>("BillingControlCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategoryID</b>
     * </p>
     *
     * @return Billing Category ID
     */
    @SerializedName( "BillingControlCategoryID" )
    @JsonProperty( "BillingControlCategoryID" )
    @Nullable
    @ODataField( odataName = "BillingControlCategoryID" )
    private String billingControlCategoryID;
    /**
     * Use with available fluent helpers to apply the <b>BillingControlCategoryID</b> field to query operations.
     *
     */
    public final static PlanDataField<String> BILLING_CONTROL_CATEGORY_ID =
        new PlanDataField<String>("BillingControlCategoryID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeName</b>
     * </p>
     *
     * @return Employee Name
     */
    @SerializedName( "EmployeeName" )
    @JsonProperty( "EmployeeName" )
    @Nullable
    @ODataField( odataName = "EmployeeName" )
    private String employeeName;
    /**
     * Use with available fluent helpers to apply the <b>EmployeeName</b> field to query operations.
     *
     */
    public final static PlanDataField<String> EMPLOYEE_NAME = new PlanDataField<String>("EmployeeName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>Wpname</b>
     * </p>
     *
     * @return Work Package Name
     */
    @SerializedName( "Wpname" )
    @JsonProperty( "Wpname" )
    @Nullable
    @ODataField( odataName = "Wpname" )
    private String wpname;
    /**
     * Use with available fluent helpers to apply the <b>Wpname</b> field to query operations.
     *
     */
    public final static PlanDataField<String> WPNAME = new PlanDataField<String>("Wpname");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static PlanDataField<String> PROJECT_ID = new PlanDataField<String>("ProjectID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResType</b>
     * </p>
     *
     * @return Resource Type ID
     */
    @Key
    @SerializedName( "ResType" )
    @JsonProperty( "ResType" )
    @Nullable
    @ODataField( odataName = "ResType" )
    private String resType;
    /**
     * Use with available fluent helpers to apply the <b>ResType</b> field to query operations.
     *
     */
    public final static PlanDataField<String> RES_TYPE = new PlanDataField<String>("ResType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackageID" )
    @JsonProperty( "WorkPackageID" )
    @Nullable
    @ODataField( odataName = "WorkPackageID" )
    private String workPackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageID</b> field to query operations.
     *
     */
    public final static PlanDataField<String> WORK_PACKAGE_ID = new PlanDataField<String>("WorkPackageID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResTypeText</b>
     * </p>
     *
     * @return Resource Type Desc.
     */
    @SerializedName( "ResTypeText" )
    @JsonProperty( "ResTypeText" )
    @Nullable
    @ODataField( odataName = "ResTypeText" )
    private String resTypeText;
    /**
     * Use with available fluent helpers to apply the <b>ResTypeText</b> field to query operations.
     *
     */
    public final static PlanDataField<String> RES_TYPE_TEXT = new PlanDataField<String>("ResTypeText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ResourceId</b>
     * </p>
     *
     * @return Resource ID
     */
    @Key
    @SerializedName( "ResourceId" )
    @JsonProperty( "ResourceId" )
    @Nullable
    @ODataField( odataName = "ResourceId" )
    private String resourceId;
    /**
     * Use with available fluent helpers to apply the <b>ResourceId</b> field to query operations.
     *
     */
    public final static PlanDataField<String> RESOURCE_ID = new PlanDataField<String>("ResourceId");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResourceText</b>
     * </p>
     *
     * @return Resource Desc.
     */
    @SerializedName( "ResourceText" )
    @JsonProperty( "ResourceText" )
    @Nullable
    @ODataField( odataName = "ResourceText" )
    private String resourceText;
    /**
     * Use with available fluent helpers to apply the <b>ResourceText</b> field to query operations.
     *
     */
    public final static PlanDataField<String> RESOURCE_TEXT = new PlanDataField<String>("ResourceText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Uom</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "Uom" )
    @JsonProperty( "Uom" )
    @Nullable
    @ODataField( odataName = "Uom" )
    private String uom;
    /**
     * Use with available fluent helpers to apply the <b>Uom</b> field to query operations.
     *
     */
    public final static PlanDataField<String> UOM = new PlanDataField<String>("Uom");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Version ID
     */
    @Key
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static PlanDataField<String> VERSION = new PlanDataField<String>("Version");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Period</b>
     * </p>
     *
     * @return Month
     */
    @SerializedName( "Period" )
    @JsonProperty( "Period" )
    @Nullable
    @ODataField( odataName = "Period" )
    private String period;
    /**
     * Use with available fluent helpers to apply the <b>Period</b> field to query operations.
     *
     */
    public final static PlanDataField<String> PERIOD = new PlanDataField<String>("Period");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FcYear</b>
     * </p>
     *
     * @return Year
     */
    @SerializedName( "FcYear" )
    @JsonProperty( "FcYear" )
    @Nullable
    @ODataField( odataName = "FcYear" )
    private String fcYear;
    /**
     * Use with available fluent helpers to apply the <b>FcYear</b> field to query operations.
     *
     */
    public final static PlanDataField<String> FC_YEAR = new PlanDataField<String>("FcYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Employee</b>
     * </p>
     *
     * @return Employee ID
     */
    @Key
    @SerializedName( "Employee" )
    @JsonProperty( "Employee" )
    @Nullable
    @ODataField( odataName = "Employee" )
    private String employee;
    /**
     * Use with available fluent helpers to apply the <b>Employee</b> field to query operations.
     *
     */
    public final static PlanDataField<String> EMPLOYEE = new PlanDataField<String>("Employee");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confirmed</b>
     * </p>
     *
     * @return Resource is Confirmed
     */
    @Key
    @SerializedName( "Confirmed" )
    @JsonProperty( "Confirmed" )
    @Nullable
    @ODataField( odataName = "Confirmed" )
    private String confirmed;
    /**
     * Use with available fluent helpers to apply the <b>Confirmed</b> field to query operations.
     *
     */
    public final static PlanDataField<String> CONFIRMED = new PlanDataField<String>("Confirmed");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemId</b>
     * </p>
     *
     * @return Work Item ID
     */
    @Key
    @SerializedName( "WorkitemId" )
    @JsonProperty( "WorkitemId" )
    @Nullable
    @ODataField( odataName = "WorkitemId" )
    private String workitemId;
    /**
     * Use with available fluent helpers to apply the <b>WorkitemId</b> field to query operations.
     *
     */
    public final static PlanDataField<String> WORKITEM_ID = new PlanDataField<String>("WorkitemId");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemName</b>
     * </p>
     *
     * @return Work Item Desc.
     */
    @SerializedName( "WorkitemName" )
    @JsonProperty( "WorkitemName" )
    @Nullable
    @ODataField( odataName = "WorkitemName" )
    private String workitemName;
    /**
     * Use with available fluent helpers to apply the <b>WorkitemName</b> field to query operations.
     *
     */
    public final static PlanDataField<String> WORKITEM_NAME = new PlanDataField<String>("WorkitemName");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Effort</b>
     * </p>
     *
     * @return Planned Effort
     */
    @SerializedName( "Effort" )
    @JsonProperty( "Effort" )
    @Nullable
    @ODataField( odataName = "Effort" )
    private BigDecimal effort;
    /**
     * Use with available fluent helpers to apply the <b>Effort</b> field to query operations.
     *
     */
    public final static PlanDataField<BigDecimal> EFFORT = new PlanDataField<BigDecimal>("Effort");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DelvryServOrg</b>
     * </p>
     *
     * @return Delivery Org. ID
     */
    @Key
    @SerializedName( "DelvryServOrg" )
    @JsonProperty( "DelvryServOrg" )
    @Nullable
    @ODataField( odataName = "DelvryServOrg" )
    private String delvryServOrg;
    /**
     * Use with available fluent helpers to apply the <b>DelvryServOrg</b> field to query operations.
     *
     */
    public final static PlanDataField<String> DELVRY_SERV_ORG = new PlanDataField<String>("DelvryServOrg");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DelvryServOrgT</b>
     * </p>
     *
     * @return Delivery Org. Desc.
     */
    @SerializedName( "DelvryServOrgT" )
    @JsonProperty( "DelvryServOrgT" )
    @Nullable
    @ODataField( odataName = "DelvryServOrgT" )
    private String delvryServOrgT;
    /**
     * Use with available fluent helpers to apply the <b>DelvryServOrgT</b> field to query operations.
     *
     */
    public final static PlanDataField<String> DELVRY_SERV_ORG_T = new PlanDataField<String>("DelvryServOrgT");
    /**
     * Navigation property <b>ToStaffData</b> for <b>PlanData</b> to multiple <b>StaffingData</b>.
     *
     */
    @SerializedName( "ToStaffData" )
    @JsonProperty( "ToStaffData" )
    @ODataField( odataName = "ToStaffData" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<StaffingData> toStaffData;
    /**
     * Use with available fluent helpers to apply the <b>ToStaffData</b> navigation property to query operations.
     *
     */
    public final static PlanDataLink<StaffingData> TO_STAFF_DATA = new PlanDataLink<StaffingData>("ToStaffData");

    @Nonnull
    @Override
    public Class<PlanData> getType()
    {
        return PlanData.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @param billingControlCategory
     *            Billing Category
     */
    public void setBillingControlCategory( @Nullable final String billingControlCategory )
    {
        rememberChangedField("BillingControlCategory", this.billingControlCategory);
        this.billingControlCategory = billingControlCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategoryID</b>
     * </p>
     *
     * @param billingControlCategoryID
     *            Billing Category ID
     */
    public void setBillingControlCategoryID( @Nullable final String billingControlCategoryID )
    {
        rememberChangedField("BillingControlCategoryID", this.billingControlCategoryID);
        this.billingControlCategoryID = billingControlCategoryID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeName</b>
     * </p>
     *
     * @param employeeName
     *            Employee Name
     */
    public void setEmployeeName( @Nullable final String employeeName )
    {
        rememberChangedField("EmployeeName", this.employeeName);
        this.employeeName = employeeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>Wpname</b>
     * </p>
     *
     * @param wpname
     *            Work Package Name
     */
    public void setWpname( @Nullable final String wpname )
    {
        rememberChangedField("Wpname", this.wpname);
        this.wpname = wpname;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResType</b>
     * </p>
     *
     * @param resType
     *            Resource Type ID
     */
    public void setResType( @Nullable final String resType )
    {
        rememberChangedField("ResType", this.resType);
        this.resType = resType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @param workPackageID
     *            Work Package ID
     */
    public void setWorkPackageID( @Nullable final String workPackageID )
    {
        rememberChangedField("WorkPackageID", this.workPackageID);
        this.workPackageID = workPackageID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResTypeText</b>
     * </p>
     *
     * @param resTypeText
     *            Resource Type Desc.
     */
    public void setResTypeText( @Nullable final String resTypeText )
    {
        rememberChangedField("ResTypeText", this.resTypeText);
        this.resTypeText = resTypeText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ResourceId</b>
     * </p>
     *
     * @param resourceId
     *            Resource ID
     */
    public void setResourceId( @Nullable final String resourceId )
    {
        rememberChangedField("ResourceId", this.resourceId);
        this.resourceId = resourceId;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResourceText</b>
     * </p>
     *
     * @param resourceText
     *            Resource Desc.
     */
    public void setResourceText( @Nullable final String resourceText )
    {
        rememberChangedField("ResourceText", this.resourceText);
        this.resourceText = resourceText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Uom</b>
     * </p>
     *
     * @param uom
     *            Unit of Measure
     */
    public void setUom( @Nullable final String uom )
    {
        rememberChangedField("Uom", this.uom);
        this.uom = uom;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Period</b>
     * </p>
     *
     * @param period
     *            Month
     */
    public void setPeriod( @Nullable final String period )
    {
        rememberChangedField("Period", this.period);
        this.period = period;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FcYear</b>
     * </p>
     *
     * @param fcYear
     *            Year
     */
    public void setFcYear( @Nullable final String fcYear )
    {
        rememberChangedField("FcYear", this.fcYear);
        this.fcYear = fcYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Employee</b>
     * </p>
     *
     * @param employee
     *            Employee ID
     */
    public void setEmployee( @Nullable final String employee )
    {
        rememberChangedField("Employee", this.employee);
        this.employee = employee;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confirmed</b>
     * </p>
     *
     * @param confirmed
     *            Resource is Confirmed
     */
    public void setConfirmed( @Nullable final String confirmed )
    {
        rememberChangedField("Confirmed", this.confirmed);
        this.confirmed = confirmed;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemId</b>
     * </p>
     *
     * @param workitemId
     *            Work Item ID
     */
    public void setWorkitemId( @Nullable final String workitemId )
    {
        rememberChangedField("WorkitemId", this.workitemId);
        this.workitemId = workitemId;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemName</b>
     * </p>
     *
     * @param workitemName
     *            Work Item Desc.
     */
    public void setWorkitemName( @Nullable final String workitemName )
    {
        rememberChangedField("WorkitemName", this.workitemName);
        this.workitemName = workitemName;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Effort</b>
     * </p>
     *
     * @param effort
     *            Planned Effort
     */
    public void setEffort( @Nullable final BigDecimal effort )
    {
        rememberChangedField("Effort", this.effort);
        this.effort = effort;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DelvryServOrg</b>
     * </p>
     *
     * @param delvryServOrg
     *            Delivery Org. ID
     */
    public void setDelvryServOrg( @Nullable final String delvryServOrg )
    {
        rememberChangedField("DelvryServOrg", this.delvryServOrg);
        this.delvryServOrg = delvryServOrg;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DelvryServOrgT</b>
     * </p>
     *
     * @param delvryServOrgT
     *            Delivery Org. Desc.
     */
    public void setDelvryServOrgT( @Nullable final String delvryServOrgT )
    {
        rememberChangedField("DelvryServOrgT", this.delvryServOrgT);
        this.delvryServOrgT = delvryServOrgT;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PlanDataSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        result.put("ResType", getResType());
        result.put("WorkPackageID", getWorkPackageID());
        result.put("ResourceId", getResourceId());
        result.put("Version", getVersion());
        result.put("Employee", getEmployee());
        result.put("Confirmed", getConfirmed());
        result.put("WorkitemId", getWorkitemId());
        result.put("DelvryServOrg", getDelvryServOrg());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingControlCategory", getBillingControlCategory());
        values.put("BillingControlCategoryID", getBillingControlCategoryID());
        values.put("EmployeeName", getEmployeeName());
        values.put("Wpname", getWpname());
        values.put("ProjectID", getProjectID());
        values.put("ResType", getResType());
        values.put("WorkPackageID", getWorkPackageID());
        values.put("ResTypeText", getResTypeText());
        values.put("ResourceId", getResourceId());
        values.put("ResourceText", getResourceText());
        values.put("Uom", getUom());
        values.put("Version", getVersion());
        values.put("Period", getPeriod());
        values.put("FcYear", getFcYear());
        values.put("Employee", getEmployee());
        values.put("Confirmed", getConfirmed());
        values.put("WorkitemId", getWorkitemId());
        values.put("WorkitemName", getWorkitemName());
        values.put("Effort", getEffort());
        values.put("DelvryServOrg", getDelvryServOrg());
        values.put("DelvryServOrgT", getDelvryServOrgT());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingControlCategory") ) {
                final Object value = values.remove("BillingControlCategory");
                if( (value == null) || (!value.equals(getBillingControlCategory())) ) {
                    setBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("BillingControlCategoryID") ) {
                final Object value = values.remove("BillingControlCategoryID");
                if( (value == null) || (!value.equals(getBillingControlCategoryID())) ) {
                    setBillingControlCategoryID(((String) value));
                }
            }
            if( values.containsKey("EmployeeName") ) {
                final Object value = values.remove("EmployeeName");
                if( (value == null) || (!value.equals(getEmployeeName())) ) {
                    setEmployeeName(((String) value));
                }
            }
            if( values.containsKey("Wpname") ) {
                final Object value = values.remove("Wpname");
                if( (value == null) || (!value.equals(getWpname())) ) {
                    setWpname(((String) value));
                }
            }
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("ResType") ) {
                final Object value = values.remove("ResType");
                if( (value == null) || (!value.equals(getResType())) ) {
                    setResType(((String) value));
                }
            }
            if( values.containsKey("WorkPackageID") ) {
                final Object value = values.remove("WorkPackageID");
                if( (value == null) || (!value.equals(getWorkPackageID())) ) {
                    setWorkPackageID(((String) value));
                }
            }
            if( values.containsKey("ResTypeText") ) {
                final Object value = values.remove("ResTypeText");
                if( (value == null) || (!value.equals(getResTypeText())) ) {
                    setResTypeText(((String) value));
                }
            }
            if( values.containsKey("ResourceId") ) {
                final Object value = values.remove("ResourceId");
                if( (value == null) || (!value.equals(getResourceId())) ) {
                    setResourceId(((String) value));
                }
            }
            if( values.containsKey("ResourceText") ) {
                final Object value = values.remove("ResourceText");
                if( (value == null) || (!value.equals(getResourceText())) ) {
                    setResourceText(((String) value));
                }
            }
            if( values.containsKey("Uom") ) {
                final Object value = values.remove("Uom");
                if( (value == null) || (!value.equals(getUom())) ) {
                    setUom(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("Period") ) {
                final Object value = values.remove("Period");
                if( (value == null) || (!value.equals(getPeriod())) ) {
                    setPeriod(((String) value));
                }
            }
            if( values.containsKey("FcYear") ) {
                final Object value = values.remove("FcYear");
                if( (value == null) || (!value.equals(getFcYear())) ) {
                    setFcYear(((String) value));
                }
            }
            if( values.containsKey("Employee") ) {
                final Object value = values.remove("Employee");
                if( (value == null) || (!value.equals(getEmployee())) ) {
                    setEmployee(((String) value));
                }
            }
            if( values.containsKey("Confirmed") ) {
                final Object value = values.remove("Confirmed");
                if( (value == null) || (!value.equals(getConfirmed())) ) {
                    setConfirmed(((String) value));
                }
            }
            if( values.containsKey("WorkitemId") ) {
                final Object value = values.remove("WorkitemId");
                if( (value == null) || (!value.equals(getWorkitemId())) ) {
                    setWorkitemId(((String) value));
                }
            }
            if( values.containsKey("WorkitemName") ) {
                final Object value = values.remove("WorkitemName");
                if( (value == null) || (!value.equals(getWorkitemName())) ) {
                    setWorkitemName(((String) value));
                }
            }
            if( values.containsKey("Effort") ) {
                final Object value = values.remove("Effort");
                if( (value == null) || (!value.equals(getEffort())) ) {
                    setEffort(((BigDecimal) value));
                }
            }
            if( values.containsKey("DelvryServOrg") ) {
                final Object value = values.remove("DelvryServOrg");
                if( (value == null) || (!value.equals(getDelvryServOrg())) ) {
                    setDelvryServOrg(((String) value));
                }
            }
            if( values.containsKey("DelvryServOrgT") ) {
                final Object value = values.remove("DelvryServOrgT");
                if( (value == null) || (!value.equals(getDelvryServOrgT())) ) {
                    setDelvryServOrgT(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("ToStaffData") ) {
                final Object value = (values).remove("ToStaffData");
                if( value instanceof Iterable ) {
                    if( toStaffData == null ) {
                        toStaffData = Lists.newArrayList();
                    } else {
                        toStaffData = Lists.newArrayList(toStaffData);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        StaffingData entity;
                        if( toStaffData.size() > i ) {
                            entity = toStaffData.get(i);
                        } else {
                            entity = new StaffingData();
                            toStaffData.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PlanDataField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlanDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlanDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlanDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toStaffData != null ) {
            (values).put("ToStaffData", toStaffData);
        }
        return values;
    }

    /**
     * Fetches the <b>StaffingData</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>ToStaffData</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>StaffingData</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StaffingData> fetchStaffData()
    {
        return fetchFieldAsList("ToStaffData", StaffingData.class);
    }

    /**
     * Retrieval of associated <b>StaffingData</b> entities (one to many). This corresponds to the OData navigation
     * property <b>ToStaffData</b>.
     * <p>
     * If the navigation property <b>ToStaffData</b> of a queried <b>PlanData</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>StaffingData</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<StaffingData> getStaffDataOrFetch()
    {
        if( toStaffData == null ) {
            toStaffData = fetchStaffData();
        }
        return toStaffData;
    }

    /**
     * Retrieval of associated <b>StaffingData</b> entities (one to many). This corresponds to the OData navigation
     * property <b>ToStaffData</b>.
     * <p>
     * If the navigation property for an entity <b>PlanData</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>ToStaffData</b> is already loaded, the result will contain
     *         the <b>StaffingData</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<StaffingData>> getStaffDataIfPresent()
    {
        return Option.of(toStaffData);
    }

    /**
     * Overwrites the list of associated <b>StaffingData</b> entities for the loaded navigation property
     * <b>ToStaffData</b>.
     * <p>
     * If the navigation property <b>ToStaffData</b> of a queried <b>PlanData</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>StaffingData</b> entities.
     */
    public void setStaffData( @Nonnull final List<StaffingData> value )
    {
        if( toStaffData == null ) {
            toStaffData = Lists.newArrayList();
        }
        toStaffData.clear();
        toStaffData.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>StaffingData</b> entities. This corresponds to the OData navigation
     * property <b>ToStaffData</b>.
     * <p>
     * If the navigation property <b>ToStaffData</b> of a queried <b>PlanData</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>StaffingData</b> entities.
     */
    public void addStaffData( StaffingData... entity )
    {
        if( toStaffData == null ) {
            toStaffData = Lists.newArrayList();
        }
        toStaffData.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PlanData instances.
     *
     */
    public final static class PlanDataBuilder
    {

        private List<StaffingData> toStaffData = Lists.newArrayList();

        private PlanData.PlanDataBuilder toStaffData( final List<StaffingData> value )
        {
            toStaffData.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>ToStaffData</b> for <b>PlanData</b> to multiple <b>StaffingData</b>.
         *
         * @param value
         *            The StaffingDatas to build this PlanData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlanData.PlanDataBuilder staffData( StaffingData... value )
        {
            return toStaffData(Lists.newArrayList(value));
        }

    }

}
