/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.PlanDataSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData PlanData} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class PlanDataByKeyFluentHelper
    extends
    FluentHelperByKey<PlanDataByKeyFluentHelper, PlanData, PlanDataSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.PlanData PlanData} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param workitemId
     *            Work Item ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PlanData}
     * @param delvryServOrg
     *            Delivery Org. ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param resourceId
     *            Resource ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param resType
     *            Resource Type ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PlanData}
     * @param employee
     *            Employee ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param version
     *            Version ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 28
     *            </p>
     * @param confirmed
     *            Resource is Confirmed
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public PlanDataByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String projectID,
        final String resType,
        final String workPackageID,
        final String resourceId,
        final String version,
        final String employee,
        final String confirmed,
        final String workitemId,
        final String delvryServOrg )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectID", projectID);
        this.key.put("ResType", resType);
        this.key.put("WorkPackageID", workPackageID);
        this.key.put("ResourceId", resourceId);
        this.key.put("Version", version);
        this.key.put("Employee", employee);
        this.key.put("Confirmed", confirmed);
        this.key.put("WorkitemId", workitemId);
        this.key.put("DelvryServOrg", delvryServOrg);
    }

    @Override
    @Nonnull
    protected Class<PlanData> getEntityClass()
    {
        return PlanData.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
