/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.ProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.ProjectLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.ProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Project</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Project extends VdmEntity<Project>
{

    /**
     * Selector for all available fields of Project.
     *
     */
    public final static ProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangedBy</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "ChangedBy" )
    @JsonProperty( "ChangedBy" )
    @Nullable
    @ODataField( odataName = "ChangedBy" )
    private String changedBy;
    /**
     * Use with available fluent helpers to apply the <b>ChangedBy</b> field to query operations.
     *
     */
    public final static ProjectField<String> CHANGED_BY = new ProjectField<String>("ChangedBy");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>UseProjectBilling</b>
     * </p>
     *
     * @return Use Project Billiing
     */
    @SerializedName( "UseProjectBilling" )
    @JsonProperty( "UseProjectBilling" )
    @Nullable
    @ODataField( odataName = "UseProjectBilling" )
    private String useProjectBilling;
    /**
     * Use with available fluent helpers to apply the <b>UseProjectBilling</b> field to query operations.
     *
     */
    public final static ProjectField<String> USE_PROJECT_BILLING = new ProjectField<String>("UseProjectBilling");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RestrictTimePosting</b>
     * </p>
     *
     * @return Restrict time post
     */
    @SerializedName( "RestrictTimePosting" )
    @JsonProperty( "RestrictTimePosting" )
    @Nullable
    @ODataField( odataName = "RestrictTimePosting" )
    private String restrictTimePosting;
    /**
     * Use with available fluent helpers to apply the <b>RestrictTimePosting</b> field to query operations.
     *
     */
    public final static ProjectField<String> RESTRICT_TIME_POSTING = new ProjectField<String>("RestrictTimePosting");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center ID
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROFIT_CENTER = new ProjectField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "ChangedOn" )
    @JsonProperty( "ChangedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedOn;
    /**
     * Use with available fluent helpers to apply the <b>ChangedOn</b> field to query operations.
     *
     */
    public final static ProjectField<ZonedDateTime> CHANGED_ON = new ProjectField<ZonedDateTime>("ChangedOn");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @return Profit Center Desc.
     */
    @SerializedName( "ProfitCenterName" )
    @JsonProperty( "ProfitCenterName" )
    @Nullable
    @ODataField( odataName = "ProfitCenterName" )
    private String profitCenterName;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenterName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROFIT_CENTER_NAME = new ProjectField<String>("ProfitCenterName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_ID = new ProjectField<String>("ProjectID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectName</b>
     * </p>
     *
     * @return Project Name
     */
    @SerializedName( "ProjectName" )
    @JsonProperty( "ProjectName" )
    @Nullable
    @ODataField( odataName = "ProjectName" )
    private String projectName;
    /**
     * Use with available fluent helpers to apply the <b>ProjectName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_NAME = new ProjectField<String>("ProjectName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStage</b>
     * </p>
     *
     * @return Project Stage
     */
    @SerializedName( "ProjectStage" )
    @JsonProperty( "ProjectStage" )
    @Nullable
    @ODataField( odataName = "ProjectStage" )
    private String projectStage;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStage</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_STAGE = new ProjectField<String>("ProjectStage");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StageDesc</b>
     * </p>
     *
     * @return Stage Desc.
     */
    @SerializedName( "StageDesc" )
    @JsonProperty( "StageDesc" )
    @Nullable
    @ODataField( odataName = "StageDesc" )
    private String stageDesc;
    /**
     * Use with available fluent helpers to apply the <b>StageDesc</b> field to query operations.
     *
     */
    public final static ProjectField<String> STAGE_DESC = new ProjectField<String>("StageDesc");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>StartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "StartDate" )
    @JsonProperty( "StartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "StartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime startDate;
    /**
     * Use with available fluent helpers to apply the <b>StartDate</b> field to query operations.
     *
     */
    public final static ProjectField<LocalDateTime> START_DATE = new ProjectField<LocalDateTime>("StartDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "EndDate" )
    @JsonProperty( "EndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime endDate;
    /**
     * Use with available fluent helpers to apply the <b>EndDate</b> field to query operations.
     *
     */
    public final static ProjectField<LocalDateTime> END_DATE = new ProjectField<LocalDateTime>("EndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer ID
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ProjectField<String> CUSTOMER = new ProjectField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 166
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @return Customer Name
     */
    @SerializedName( "CustomerName" )
    @JsonProperty( "CustomerName" )
    @Nullable
    @ODataField( odataName = "CustomerName" )
    private String customerName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerName</b> field to query operations.
     *
     */
    public final static ProjectField<String> CUSTOMER_NAME = new ProjectField<String>("CustomerName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerId</b>
     * </p>
     *
     * @return Project Manager ID
     */
    @SerializedName( "ProjManagerId" )
    @JsonProperty( "ProjManagerId" )
    @Nullable
    @ODataField( odataName = "ProjManagerId" )
    private String projManagerId;
    /**
     * Use with available fluent helpers to apply the <b>ProjManagerId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_MANAGER_ID = new ProjectField<String>("ProjManagerId");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerName</b>
     * </p>
     *
     * @return Project Manager Name
     */
    @SerializedName( "ProjManagerName" )
    @JsonProperty( "ProjManagerName" )
    @Nullable
    @ODataField( odataName = "ProjManagerName" )
    private String projManagerName;
    /**
     * Use with available fluent helpers to apply the <b>ProjManagerName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_MANAGER_NAME = new ProjectField<String>("ProjManagerName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantId</b>
     * </p>
     *
     * @return Project Accountant ID
     */
    @SerializedName( "ProjAccountantId" )
    @JsonProperty( "ProjAccountantId" )
    @Nullable
    @ODataField( odataName = "ProjAccountantId" )
    private String projAccountantId;
    /**
     * Use with available fluent helpers to apply the <b>ProjAccountantId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_ACCOUNTANT_ID = new ProjectField<String>("ProjAccountantId");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantName</b>
     * </p>
     *
     * @return Project Accountant Name
     */
    @SerializedName( "ProjAccountantName" )
    @JsonProperty( "ProjAccountantName" )
    @Nullable
    @ODataField( odataName = "ProjAccountantName" )
    private String projAccountantName;
    /**
     * Use with available fluent helpers to apply the <b>ProjAccountantName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_ACCOUNTANT_NAME = new ProjectField<String>("ProjAccountantName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerId</b>
     * </p>
     *
     * @return Project Controller ID
     */
    @SerializedName( "ProjControllerId" )
    @JsonProperty( "ProjControllerId" )
    @Nullable
    @ODataField( odataName = "ProjControllerId" )
    private String projControllerId;
    /**
     * Use with available fluent helpers to apply the <b>ProjControllerId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_CONTROLLER_ID = new ProjectField<String>("ProjControllerId");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerName</b>
     * </p>
     *
     * @return Project Controller Name
     */
    @SerializedName( "ProjControllerName" )
    @JsonProperty( "ProjControllerName" )
    @Nullable
    @ODataField( odataName = "ProjControllerName" )
    private String projControllerName;
    /**
     * Use with available fluent helpers to apply the <b>ProjControllerName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_CONTROLLER_NAME = new ProjectField<String>("ProjControllerName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerId</b>
     * </p>
     *
     * @return Project Partner ID
     */
    @SerializedName( "ProjPartnerId" )
    @JsonProperty( "ProjPartnerId" )
    @Nullable
    @ODataField( odataName = "ProjPartnerId" )
    private String projPartnerId;
    /**
     * Use with available fluent helpers to apply the <b>ProjPartnerId</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_PARTNER_ID = new ProjectField<String>("ProjPartnerId");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerName</b>
     * </p>
     *
     * @return Project Partner Name
     */
    @SerializedName( "ProjPartnerName" )
    @JsonProperty( "ProjPartnerName" )
    @Nullable
    @ODataField( odataName = "ProjPartnerName" )
    private String projPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>ProjPartnerName</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJ_PARTNER_NAME = new ProjectField<String>("ProjPartnerName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center ID
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static ProjectField<String> COST_CENTER = new ProjectField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return Cost Center Name
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static ProjectField<String> COST_CENTER_NAME = new ProjectField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCategory</b>
     * </p>
     *
     * @return Project Type
     */
    @SerializedName( "ProjectCategory" )
    @JsonProperty( "ProjectCategory" )
    @Nullable
    @ODataField( odataName = "ProjectCategory" )
    private String projectCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProjectCategory</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_CATEGORY = new ProjectField<String>("ProjectCategory");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProjectField<String> CURRENCY = new ProjectField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Currencyname</b>
     * </p>
     *
     * @return Currency Desc.
     */
    @SerializedName( "Currencyname" )
    @JsonProperty( "Currencyname" )
    @Nullable
    @ODataField( odataName = "Currencyname" )
    private String currencyname;
    /**
     * Use with available fluent helpers to apply the <b>Currencyname</b> field to query operations.
     *
     */
    public final static ProjectField<String> CURRENCYNAME = new ProjectField<String>("Currencyname");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrgID</b>
     * </p>
     *
     * @return Service Organization ID
     */
    @SerializedName( "OrgID" )
    @JsonProperty( "OrgID" )
    @Nullable
    @ODataField( odataName = "OrgID" )
    private String orgID;
    /**
     * Use with available fluent helpers to apply the <b>OrgID</b> field to query operations.
     *
     */
    public final static ProjectField<String> ORG_ID = new ProjectField<String>("OrgID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrgDesc</b>
     * </p>
     *
     * @return Service Organization Desc.
     */
    @SerializedName( "OrgDesc" )
    @JsonProperty( "OrgDesc" )
    @Nullable
    @ODataField( odataName = "OrgDesc" )
    private String orgDesc;
    /**
     * Use with available fluent helpers to apply the <b>OrgDesc</b> field to query operations.
     *
     */
    public final static ProjectField<String> ORG_DESC = new ProjectField<String>("OrgDesc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confidential</b>
     * </p>
     *
     * @return Confidential
     */
    @SerializedName( "Confidential" )
    @JsonProperty( "Confidential" )
    @Nullable
    @ODataField( odataName = "Confidential" )
    private String confidential;
    /**
     * Use with available fluent helpers to apply the <b>Confidential</b> field to query operations.
     *
     */
    public final static ProjectField<String> CONFIDENTIAL = new ProjectField<String>("Confidential");
    /**
     * Navigation property <b>ProjectRoleSet</b> for <b>Project</b> to multiple <b>ProjectRole</b>.
     *
     */
    @SerializedName( "ProjectRoleSet" )
    @JsonProperty( "ProjectRoleSet" )
    @ODataField( odataName = "ProjectRoleSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjectRole> toProjectRoleSet;
    /**
     * Navigation property <b>WorkpackageSet</b> for <b>Project</b> to multiple <b>Workpackage</b>.
     *
     */
    @SerializedName( "WorkpackageSet" )
    @JsonProperty( "WorkpackageSet" )
    @ODataField( odataName = "WorkpackageSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Workpackage> toWorkpackageSet;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleSet</b> navigation property to query operations.
     *
     */
    public final static ProjectLink<ProjectRole> TO_PROJECT_ROLE_SET = new ProjectLink<ProjectRole>("ProjectRoleSet");
    /**
     * Use with available fluent helpers to apply the <b>WorkpackageSet</b> navigation property to query operations.
     *
     */
    public final static ProjectLink<Workpackage> TO_WORKPACKAGE_SET = new ProjectLink<Workpackage>("WorkpackageSet");

    @Nonnull
    @Override
    public Class<Project> getType()
    {
        return Project.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangedBy</b>
     * </p>
     *
     * @param changedBy
     *            Changed By
     */
    public void setChangedBy( @Nullable final String changedBy )
    {
        rememberChangedField("ChangedBy", this.changedBy);
        this.changedBy = changedBy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>UseProjectBilling</b>
     * </p>
     *
     * @param useProjectBilling
     *            Use Project Billiing
     */
    public void setUseProjectBilling( @Nullable final String useProjectBilling )
    {
        rememberChangedField("UseProjectBilling", this.useProjectBilling);
        this.useProjectBilling = useProjectBilling;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RestrictTimePosting</b>
     * </p>
     *
     * @param restrictTimePosting
     *            Restrict time post
     */
    public void setRestrictTimePosting( @Nullable final String restrictTimePosting )
    {
        rememberChangedField("RestrictTimePosting", this.restrictTimePosting);
        this.restrictTimePosting = restrictTimePosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center ID
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @param changedOn
     *            Changed On
     */
    public void setChangedOn( @Nullable final ZonedDateTime changedOn )
    {
        rememberChangedField("ChangedOn", this.changedOn);
        this.changedOn = changedOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenterName</b>
     * </p>
     *
     * @param profitCenterName
     *            Profit Center Desc.
     */
    public void setProfitCenterName( @Nullable final String profitCenterName )
    {
        rememberChangedField("ProfitCenterName", this.profitCenterName);
        this.profitCenterName = profitCenterName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectName</b>
     * </p>
     *
     * @param projectName
     *            Project Name
     */
    public void setProjectName( @Nullable final String projectName )
    {
        rememberChangedField("ProjectName", this.projectName);
        this.projectName = projectName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStage</b>
     * </p>
     *
     * @param projectStage
     *            Project Stage
     */
    public void setProjectStage( @Nullable final String projectStage )
    {
        rememberChangedField("ProjectStage", this.projectStage);
        this.projectStage = projectStage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StageDesc</b>
     * </p>
     *
     * @param stageDesc
     *            Stage Desc.
     */
    public void setStageDesc( @Nullable final String stageDesc )
    {
        rememberChangedField("StageDesc", this.stageDesc);
        this.stageDesc = stageDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>StartDate</b>
     * </p>
     *
     * @param startDate
     *            Start Date
     */
    public void setStartDate( @Nullable final LocalDateTime startDate )
    {
        rememberChangedField("StartDate", this.startDate);
        this.startDate = startDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>EndDate</b>
     * </p>
     *
     * @param endDate
     *            End Date
     */
    public void setEndDate( @Nullable final LocalDateTime endDate )
    {
        rememberChangedField("EndDate", this.endDate);
        this.endDate = endDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer ID
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 166
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @param customerName
     *            Customer Name
     */
    public void setCustomerName( @Nullable final String customerName )
    {
        rememberChangedField("CustomerName", this.customerName);
        this.customerName = customerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerId</b>
     * </p>
     *
     * @param projManagerId
     *            Project Manager ID
     */
    public void setProjManagerId( @Nullable final String projManagerId )
    {
        rememberChangedField("ProjManagerId", this.projManagerId);
        this.projManagerId = projManagerId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjManagerName</b>
     * </p>
     *
     * @param projManagerName
     *            Project Manager Name
     */
    public void setProjManagerName( @Nullable final String projManagerName )
    {
        rememberChangedField("ProjManagerName", this.projManagerName);
        this.projManagerName = projManagerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantId</b>
     * </p>
     *
     * @param projAccountantId
     *            Project Accountant ID
     */
    public void setProjAccountantId( @Nullable final String projAccountantId )
    {
        rememberChangedField("ProjAccountantId", this.projAccountantId);
        this.projAccountantId = projAccountantId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjAccountantName</b>
     * </p>
     *
     * @param projAccountantName
     *            Project Accountant Name
     */
    public void setProjAccountantName( @Nullable final String projAccountantName )
    {
        rememberChangedField("ProjAccountantName", this.projAccountantName);
        this.projAccountantName = projAccountantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerId</b>
     * </p>
     *
     * @param projControllerId
     *            Project Controller ID
     */
    public void setProjControllerId( @Nullable final String projControllerId )
    {
        rememberChangedField("ProjControllerId", this.projControllerId);
        this.projControllerId = projControllerId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjControllerName</b>
     * </p>
     *
     * @param projControllerName
     *            Project Controller Name
     */
    public void setProjControllerName( @Nullable final String projControllerName )
    {
        rememberChangedField("ProjControllerName", this.projControllerName);
        this.projControllerName = projControllerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerId</b>
     * </p>
     *
     * @param projPartnerId
     *            Project Partner ID
     */
    public void setProjPartnerId( @Nullable final String projPartnerId )
    {
        rememberChangedField("ProjPartnerId", this.projPartnerId);
        this.projPartnerId = projPartnerId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ProjPartnerName</b>
     * </p>
     *
     * @param projPartnerName
     *            Project Partner Name
     */
    public void setProjPartnerName( @Nullable final String projPartnerName )
    {
        rememberChangedField("ProjPartnerName", this.projPartnerName);
        this.projPartnerName = projPartnerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center ID
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            Cost Center Name
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCategory</b>
     * </p>
     *
     * @param projectCategory
     *            Project Type
     */
    public void setProjectCategory( @Nullable final String projectCategory )
    {
        rememberChangedField("ProjectCategory", this.projectCategory);
        this.projectCategory = projectCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Currencyname</b>
     * </p>
     *
     * @param currencyname
     *            Currency Desc.
     */
    public void setCurrencyname( @Nullable final String currencyname )
    {
        rememberChangedField("Currencyname", this.currencyname);
        this.currencyname = currencyname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrgID</b>
     * </p>
     *
     * @param orgID
     *            Service Organization ID
     */
    public void setOrgID( @Nullable final String orgID )
    {
        rememberChangedField("OrgID", this.orgID);
        this.orgID = orgID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrgDesc</b>
     * </p>
     *
     * @param orgDesc
     *            Service Organization Desc.
     */
    public void setOrgDesc( @Nullable final String orgDesc )
    {
        rememberChangedField("OrgDesc", this.orgDesc);
        this.orgDesc = orgDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confidential</b>
     * </p>
     *
     * @param confidential
     *            Confidential
     */
    public void setConfidential( @Nullable final String confidential )
    {
        rememberChangedField("Confidential", this.confidential);
        this.confidential = confidential;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProjectSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChangedBy", getChangedBy());
        values.put("UseProjectBilling", getUseProjectBilling());
        values.put("RestrictTimePosting", getRestrictTimePosting());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ChangedOn", getChangedOn());
        values.put("ProfitCenterName", getProfitCenterName());
        values.put("ProjectID", getProjectID());
        values.put("ProjectName", getProjectName());
        values.put("ProjectStage", getProjectStage());
        values.put("StageDesc", getStageDesc());
        values.put("StartDate", getStartDate());
        values.put("EndDate", getEndDate());
        values.put("Customer", getCustomer());
        values.put("CustomerName", getCustomerName());
        values.put("ProjManagerId", getProjManagerId());
        values.put("ProjManagerName", getProjManagerName());
        values.put("ProjAccountantId", getProjAccountantId());
        values.put("ProjAccountantName", getProjAccountantName());
        values.put("ProjControllerId", getProjControllerId());
        values.put("ProjControllerName", getProjControllerName());
        values.put("ProjPartnerId", getProjPartnerId());
        values.put("ProjPartnerName", getProjPartnerName());
        values.put("CostCenter", getCostCenter());
        values.put("CostCenterName", getCostCenterName());
        values.put("ProjectCategory", getProjectCategory());
        values.put("Currency", getCurrency());
        values.put("Currencyname", getCurrencyname());
        values.put("OrgID", getOrgID());
        values.put("OrgDesc", getOrgDesc());
        values.put("Confidential", getConfidential());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChangedBy") ) {
                final Object value = values.remove("ChangedBy");
                if( (value == null) || (!value.equals(getChangedBy())) ) {
                    setChangedBy(((String) value));
                }
            }
            if( values.containsKey("UseProjectBilling") ) {
                final Object value = values.remove("UseProjectBilling");
                if( (value == null) || (!value.equals(getUseProjectBilling())) ) {
                    setUseProjectBilling(((String) value));
                }
            }
            if( values.containsKey("RestrictTimePosting") ) {
                final Object value = values.remove("RestrictTimePosting");
                if( (value == null) || (!value.equals(getRestrictTimePosting())) ) {
                    setRestrictTimePosting(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ChangedOn") ) {
                final Object value = values.remove("ChangedOn");
                if( (value == null) || (!value.equals(getChangedOn())) ) {
                    setChangedOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProfitCenterName") ) {
                final Object value = values.remove("ProfitCenterName");
                if( (value == null) || (!value.equals(getProfitCenterName())) ) {
                    setProfitCenterName(((String) value));
                }
            }
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("ProjectName") ) {
                final Object value = values.remove("ProjectName");
                if( (value == null) || (!value.equals(getProjectName())) ) {
                    setProjectName(((String) value));
                }
            }
            if( values.containsKey("ProjectStage") ) {
                final Object value = values.remove("ProjectStage");
                if( (value == null) || (!value.equals(getProjectStage())) ) {
                    setProjectStage(((String) value));
                }
            }
            if( values.containsKey("StageDesc") ) {
                final Object value = values.remove("StageDesc");
                if( (value == null) || (!value.equals(getStageDesc())) ) {
                    setStageDesc(((String) value));
                }
            }
            if( values.containsKey("StartDate") ) {
                final Object value = values.remove("StartDate");
                if( (value == null) || (!value.equals(getStartDate())) ) {
                    setStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EndDate") ) {
                final Object value = values.remove("EndDate");
                if( (value == null) || (!value.equals(getEndDate())) ) {
                    setEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerName") ) {
                final Object value = values.remove("CustomerName");
                if( (value == null) || (!value.equals(getCustomerName())) ) {
                    setCustomerName(((String) value));
                }
            }
            if( values.containsKey("ProjManagerId") ) {
                final Object value = values.remove("ProjManagerId");
                if( (value == null) || (!value.equals(getProjManagerId())) ) {
                    setProjManagerId(((String) value));
                }
            }
            if( values.containsKey("ProjManagerName") ) {
                final Object value = values.remove("ProjManagerName");
                if( (value == null) || (!value.equals(getProjManagerName())) ) {
                    setProjManagerName(((String) value));
                }
            }
            if( values.containsKey("ProjAccountantId") ) {
                final Object value = values.remove("ProjAccountantId");
                if( (value == null) || (!value.equals(getProjAccountantId())) ) {
                    setProjAccountantId(((String) value));
                }
            }
            if( values.containsKey("ProjAccountantName") ) {
                final Object value = values.remove("ProjAccountantName");
                if( (value == null) || (!value.equals(getProjAccountantName())) ) {
                    setProjAccountantName(((String) value));
                }
            }
            if( values.containsKey("ProjControllerId") ) {
                final Object value = values.remove("ProjControllerId");
                if( (value == null) || (!value.equals(getProjControllerId())) ) {
                    setProjControllerId(((String) value));
                }
            }
            if( values.containsKey("ProjControllerName") ) {
                final Object value = values.remove("ProjControllerName");
                if( (value == null) || (!value.equals(getProjControllerName())) ) {
                    setProjControllerName(((String) value));
                }
            }
            if( values.containsKey("ProjPartnerId") ) {
                final Object value = values.remove("ProjPartnerId");
                if( (value == null) || (!value.equals(getProjPartnerId())) ) {
                    setProjPartnerId(((String) value));
                }
            }
            if( values.containsKey("ProjPartnerName") ) {
                final Object value = values.remove("ProjPartnerName");
                if( (value == null) || (!value.equals(getProjPartnerName())) ) {
                    setProjPartnerName(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("ProjectCategory") ) {
                final Object value = values.remove("ProjectCategory");
                if( (value == null) || (!value.equals(getProjectCategory())) ) {
                    setProjectCategory(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Currencyname") ) {
                final Object value = values.remove("Currencyname");
                if( (value == null) || (!value.equals(getCurrencyname())) ) {
                    setCurrencyname(((String) value));
                }
            }
            if( values.containsKey("OrgID") ) {
                final Object value = values.remove("OrgID");
                if( (value == null) || (!value.equals(getOrgID())) ) {
                    setOrgID(((String) value));
                }
            }
            if( values.containsKey("OrgDesc") ) {
                final Object value = values.remove("OrgDesc");
                if( (value == null) || (!value.equals(getOrgDesc())) ) {
                    setOrgDesc(((String) value));
                }
            }
            if( values.containsKey("Confidential") ) {
                final Object value = values.remove("Confidential");
                if( (value == null) || (!value.equals(getConfidential())) ) {
                    setConfidential(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("ProjectRoleSet") ) {
                final Object value = (values).remove("ProjectRoleSet");
                if( value instanceof Iterable ) {
                    if( toProjectRoleSet == null ) {
                        toProjectRoleSet = Lists.newArrayList();
                    } else {
                        toProjectRoleSet = Lists.newArrayList(toProjectRoleSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjectRole entity;
                        if( toProjectRoleSet.size() > i ) {
                            entity = toProjectRoleSet.get(i);
                        } else {
                            entity = new ProjectRole();
                            toProjectRoleSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("WorkpackageSet") ) {
                final Object value = (values).remove("WorkpackageSet");
                if( value instanceof Iterable ) {
                    if( toWorkpackageSet == null ) {
                        toWorkpackageSet = Lists.newArrayList();
                    } else {
                        toWorkpackageSet = Lists.newArrayList(toWorkpackageSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Workpackage entity;
                        if( toWorkpackageSet.size() > i ) {
                            entity = toWorkpackageSet.get(i);
                        } else {
                            entity = new Workpackage();
                            toWorkpackageSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProjectRoleSet != null ) {
            (values).put("ProjectRoleSet", toProjectRoleSet);
        }
        if( toWorkpackageSet != null ) {
            (values).put("WorkpackageSet", toWorkpackageSet);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectRole</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>ProjectRoleSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjectRole</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectRole> fetchProjectRoleSet()
    {
        return fetchFieldAsList("ProjectRoleSet", ProjectRole.class);
    }

    /**
     * Retrieval of associated <b>ProjectRole</b> entities (one to many). This corresponds to the OData navigation
     * property <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property <b>ProjectRoleSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectRole</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectRole> getProjectRoleSetOrFetch()
    {
        if( toProjectRoleSet == null ) {
            toProjectRoleSet = fetchProjectRoleSet();
        }
        return toProjectRoleSet;
    }

    /**
     * Retrieval of associated <b>ProjectRole</b> entities (one to many). This corresponds to the OData navigation
     * property <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property for an entity <b>Project</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>ProjectRoleSet</b> is already loaded, the result will
     *         contain the <b>ProjectRole</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjectRole>> getProjectRoleSetIfPresent()
    {
        return Option.of(toProjectRoleSet);
    }

    /**
     * Overwrites the list of associated <b>ProjectRole</b> entities for the loaded navigation property
     * <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property <b>ProjectRoleSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjectRole</b> entities.
     */
    public void setProjectRoleSet( @Nonnull final List<ProjectRole> value )
    {
        if( toProjectRoleSet == null ) {
            toProjectRoleSet = Lists.newArrayList();
        }
        toProjectRoleSet.clear();
        toProjectRoleSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjectRole</b> entities. This corresponds to the OData navigation
     * property <b>ProjectRoleSet</b>.
     * <p>
     * If the navigation property <b>ProjectRoleSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjectRole</b> entities.
     */
    public void addProjectRoleSet( ProjectRole... entity )
    {
        if( toProjectRoleSet == null ) {
            toProjectRoleSet = Lists.newArrayList();
        }
        toProjectRoleSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>Workpackage</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>WorkpackageSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>Workpackage</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Workpackage> fetchWorkpackageSet()
    {
        return fetchFieldAsList("WorkpackageSet", Workpackage.class);
    }

    /**
     * Retrieval of associated <b>Workpackage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>WorkpackageSet</b>.
     * <p>
     * If the navigation property <b>WorkpackageSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Workpackage</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Workpackage> getWorkpackageSetOrFetch()
    {
        if( toWorkpackageSet == null ) {
            toWorkpackageSet = fetchWorkpackageSet();
        }
        return toWorkpackageSet;
    }

    /**
     * Retrieval of associated <b>Workpackage</b> entities (one to many). This corresponds to the OData navigation
     * property <b>WorkpackageSet</b>.
     * <p>
     * If the navigation property for an entity <b>Project</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>WorkpackageSet</b> is already loaded, the result will
     *         contain the <b>Workpackage</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<Workpackage>> getWorkpackageSetIfPresent()
    {
        return Option.of(toWorkpackageSet);
    }

    /**
     * Overwrites the list of associated <b>Workpackage</b> entities for the loaded navigation property
     * <b>WorkpackageSet</b>.
     * <p>
     * If the navigation property <b>WorkpackageSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>Workpackage</b> entities.
     */
    public void setWorkpackageSet( @Nonnull final List<Workpackage> value )
    {
        if( toWorkpackageSet == null ) {
            toWorkpackageSet = Lists.newArrayList();
        }
        toWorkpackageSet.clear();
        toWorkpackageSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Workpackage</b> entities. This corresponds to the OData navigation
     * property <b>WorkpackageSet</b>.
     * <p>
     * If the navigation property <b>WorkpackageSet</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>Workpackage</b> entities.
     */
    public void addWorkpackageSet( Workpackage... entity )
    {
        if( toWorkpackageSet == null ) {
            toWorkpackageSet = Lists.newArrayList();
        }
        toWorkpackageSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Project instances.
     *
     */
    public final static class ProjectBuilder
    {

        private List<ProjectRole> toProjectRoleSet = Lists.newArrayList();
        private List<Workpackage> toWorkpackageSet = Lists.newArrayList();

        private Project.ProjectBuilder toProjectRoleSet( final List<ProjectRole> value )
        {
            toProjectRoleSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>ProjectRoleSet</b> for <b>Project</b> to multiple <b>ProjectRole</b>.
         *
         * @param value
         *            The ProjectRoles to build this Project with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Project.ProjectBuilder projectRoleSet( ProjectRole... value )
        {
            return toProjectRoleSet(Lists.newArrayList(value));
        }

        private Project.ProjectBuilder toWorkpackageSet( final List<Workpackage> value )
        {
            toWorkpackageSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>WorkpackageSet</b> for <b>Project</b> to multiple <b>Workpackage</b>.
         *
         * @param value
         *            The Workpackages to build this Project with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Project.ProjectBuilder workpackageSet( Workpackage... value )
        {
            return toWorkpackageSet(Lists.newArrayList(value));
        }

    }

}
