/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.StaffingDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.StaffingDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Staffing Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>StaffingData</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class StaffingData extends VdmEntity<StaffingData>
{

    /**
     * Selector for all available fields of StaffingData.
     *
     */
    public final static StaffingDataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @Key
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> PROJECT_ID = new StaffingDataField<String>("ProjectID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @return Billing Control Category Desc.
     */
    @SerializedName( "BillingControlCategory" )
    @JsonProperty( "BillingControlCategory" )
    @Nullable
    @ODataField( odataName = "BillingControlCategory" )
    private String billingControlCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingControlCategory</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> BILLING_CONTROL_CATEGORY =
        new StaffingDataField<String>("BillingControlCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackageID" )
    @JsonProperty( "WorkPackageID" )
    @Nullable
    @ODataField( odataName = "WorkPackageID" )
    private String workPackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageID</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> WORK_PACKAGE_ID = new StaffingDataField<String>("WorkPackageID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WPname</b>
     * </p>
     *
     * @return Work Package Name
     */
    @SerializedName( "WPname" )
    @JsonProperty( "WPname" )
    @Nullable
    @ODataField( odataName = "WPname" )
    private String wPname;
    /**
     * Use with available fluent helpers to apply the <b>WPname</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> W_PNAME = new StaffingDataField<String>("WPname");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResType</b>
     * </p>
     *
     * @return ResourceTypeID
     */
    @Key
    @SerializedName( "ResType" )
    @JsonProperty( "ResType" )
    @Nullable
    @ODataField( odataName = "ResType" )
    private String resType;
    /**
     * Use with available fluent helpers to apply the <b>ResType</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> RES_TYPE = new StaffingDataField<String>("ResType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ResTypeText</b>
     * </p>
     *
     * @return Resource Type Desc.
     */
    @SerializedName( "ResTypeText" )
    @JsonProperty( "ResTypeText" )
    @Nullable
    @ODataField( odataName = "ResTypeText" )
    private String resTypeText;
    /**
     * Use with available fluent helpers to apply the <b>ResTypeText</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> RES_TYPE_TEXT = new StaffingDataField<String>("ResTypeText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ResourceId</b>
     * </p>
     *
     * @return Resource ID
     */
    @Key
    @SerializedName( "ResourceId" )
    @JsonProperty( "ResourceId" )
    @Nullable
    @ODataField( odataName = "ResourceId" )
    private String resourceId;
    /**
     * Use with available fluent helpers to apply the <b>ResourceId</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> RESOURCE_ID = new StaffingDataField<String>("ResourceId");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ResourceText</b>
     * </p>
     *
     * @return Resource Desc.
     */
    @SerializedName( "ResourceText" )
    @JsonProperty( "ResourceText" )
    @Nullable
    @ODataField( odataName = "ResourceText" )
    private String resourceText;
    /**
     * Use with available fluent helpers to apply the <b>ResourceText</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> RESOURCE_TEXT = new StaffingDataField<String>("ResourceText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Uom</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "Uom" )
    @JsonProperty( "Uom" )
    @Nullable
    @ODataField( odataName = "Uom" )
    private String uom;
    /**
     * Use with available fluent helpers to apply the <b>Uom</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> UOM = new StaffingDataField<String>("Uom");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @return Plan Version ID
     */
    @SerializedName( "Version" )
    @JsonProperty( "Version" )
    @Nullable
    @ODataField( odataName = "Version" )
    private String version;
    /**
     * Use with available fluent helpers to apply the <b>Version</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> VERSION = new StaffingDataField<String>("Version");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Period</b>
     * </p>
     *
     * @return Month
     */
    @SerializedName( "Period" )
    @JsonProperty( "Period" )
    @Nullable
    @ODataField( odataName = "Period" )
    private String period;
    /**
     * Use with available fluent helpers to apply the <b>Period</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> PERIOD = new StaffingDataField<String>("Period");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FcYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FcYear" )
    @JsonProperty( "FcYear" )
    @Nullable
    @ODataField( odataName = "FcYear" )
    private String fcYear;
    /**
     * Use with available fluent helpers to apply the <b>FcYear</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> FC_YEAR = new StaffingDataField<String>("FcYear");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmployee</b>
     * </p>
     *
     * @return Staffed Employee ID
     */
    @SerializedName( "StaffedEmployee" )
    @JsonProperty( "StaffedEmployee" )
    @Nullable
    @ODataField( odataName = "StaffedEmployee" )
    private String staffedEmployee;
    /**
     * Use with available fluent helpers to apply the <b>StaffedEmployee</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> STAFFED_EMPLOYEE = new StaffingDataField<String>("StaffedEmployee");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confirmed</b>
     * </p>
     *
     * @return Resource is Confirmed
     */
    @SerializedName( "Confirmed" )
    @JsonProperty( "Confirmed" )
    @Nullable
    @ODataField( odataName = "Confirmed" )
    private String confirmed;
    /**
     * Use with available fluent helpers to apply the <b>Confirmed</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> CONFIRMED = new StaffingDataField<String>("Confirmed");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemId</b>
     * </p>
     *
     * @return Work Item ID
     */
    @Key
    @SerializedName( "WorkitemId" )
    @JsonProperty( "WorkitemId" )
    @Nullable
    @ODataField( odataName = "WorkitemId" )
    private String workitemId;
    /**
     * Use with available fluent helpers to apply the <b>WorkitemId</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> WORKITEM_ID = new StaffingDataField<String>("WorkitemId");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemName</b>
     * </p>
     *
     * @return Work Item Desc.
     */
    @SerializedName( "WorkitemName" )
    @JsonProperty( "WorkitemName" )
    @Nullable
    @ODataField( odataName = "WorkitemName" )
    private String workitemName;
    /**
     * Use with available fluent helpers to apply the <b>WorkitemName</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> WORKITEM_NAME = new StaffingDataField<String>("WorkitemName");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEffort</b>
     * </p>
     *
     * @return Staffed Efforts
     */
    @SerializedName( "StaffedEffort" )
    @JsonProperty( "StaffedEffort" )
    @Nullable
    @ODataField( odataName = "StaffedEffort" )
    private BigDecimal staffedEffort;
    /**
     * Use with available fluent helpers to apply the <b>StaffedEffort</b> field to query operations.
     *
     */
    public final static StaffingDataField<BigDecimal> STAFFED_EFFORT =
        new StaffingDataField<BigDecimal>("StaffedEffort");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmpDelvryServOrg</b>
     * </p>
     *
     * @return Service Org.
     */
    @SerializedName( "StaffedEmpDelvryServOrg" )
    @JsonProperty( "StaffedEmpDelvryServOrg" )
    @Nullable
    @ODataField( odataName = "StaffedEmpDelvryServOrg" )
    private String staffedEmpDelvryServOrg;
    /**
     * Use with available fluent helpers to apply the <b>StaffedEmpDelvryServOrg</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> STAFFED_EMP_DELVRY_SERV_ORG =
        new StaffingDataField<String>("StaffedEmpDelvryServOrg");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmpDelvryServOrgT</b>
     * </p>
     *
     * @return Delivery Org. Desc.
     */
    @SerializedName( "StaffedEmpDelvryServOrgT" )
    @JsonProperty( "StaffedEmpDelvryServOrgT" )
    @Nullable
    @ODataField( odataName = "StaffedEmpDelvryServOrgT" )
    private String staffedEmpDelvryServOrgT;
    /**
     * Use with available fluent helpers to apply the <b>StaffedEmpDelvryServOrgT</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> STAFFED_EMP_DELVRY_SERV_ORG_T =
        new StaffingDataField<String>("StaffedEmpDelvryServOrgT");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmployeeName</b>
     * </p>
     *
     * @return Staffed Employee Name
     */
    @SerializedName( "StaffedEmployeeName" )
    @JsonProperty( "StaffedEmployeeName" )
    @Nullable
    @ODataField( odataName = "StaffedEmployeeName" )
    private String staffedEmployeeName;
    /**
     * Use with available fluent helpers to apply the <b>StaffedEmployeeName</b> field to query operations.
     *
     */
    public final static StaffingDataField<String> STAFFED_EMPLOYEE_NAME =
        new StaffingDataField<String>("StaffedEmployeeName");

    @Nonnull
    @Override
    public Class<StaffingData> getType()
    {
        return StaffingData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BillingControlCategory</b>
     * </p>
     *
     * @param billingControlCategory
     *            Billing Control Category Desc.
     */
    public void setBillingControlCategory( @Nullable final String billingControlCategory )
    {
        rememberChangedField("BillingControlCategory", this.billingControlCategory);
        this.billingControlCategory = billingControlCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @param workPackageID
     *            Work Package ID
     */
    public void setWorkPackageID( @Nullable final String workPackageID )
    {
        rememberChangedField("WorkPackageID", this.workPackageID);
        this.workPackageID = workPackageID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WPname</b>
     * </p>
     *
     * @param wPname
     *            Work Package Name
     */
    public void setWPname( @Nullable final String wPname )
    {
        rememberChangedField("WPname", this.wPname);
        this.wPname = wPname;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ResType</b>
     * </p>
     *
     * @param resType
     *            ResourceTypeID
     */
    public void setResType( @Nullable final String resType )
    {
        rememberChangedField("ResType", this.resType);
        this.resType = resType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ResTypeText</b>
     * </p>
     *
     * @param resTypeText
     *            Resource Type Desc.
     */
    public void setResTypeText( @Nullable final String resTypeText )
    {
        rememberChangedField("ResTypeText", this.resTypeText);
        this.resTypeText = resTypeText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ResourceId</b>
     * </p>
     *
     * @param resourceId
     *            Resource ID
     */
    public void setResourceId( @Nullable final String resourceId )
    {
        rememberChangedField("ResourceId", this.resourceId);
        this.resourceId = resourceId;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ResourceText</b>
     * </p>
     *
     * @param resourceText
     *            Resource Desc.
     */
    public void setResourceText( @Nullable final String resourceText )
    {
        rememberChangedField("ResourceText", this.resourceText);
        this.resourceText = resourceText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Uom</b>
     * </p>
     *
     * @param uom
     *            Unit of Measure
     */
    public void setUom( @Nullable final String uom )
    {
        rememberChangedField("Uom", this.uom);
        this.uom = uom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>Version</b>
     * </p>
     *
     * @param version
     *            Plan Version ID
     */
    public void setVersion( @Nullable final String version )
    {
        rememberChangedField("Version", this.version);
        this.version = version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Period</b>
     * </p>
     *
     * @param period
     *            Month
     */
    public void setPeriod( @Nullable final String period )
    {
        rememberChangedField("Period", this.period);
        this.period = period;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FcYear</b>
     * </p>
     *
     * @param fcYear
     *            Fiscal Year
     */
    public void setFcYear( @Nullable final String fcYear )
    {
        rememberChangedField("FcYear", this.fcYear);
        this.fcYear = fcYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmployee</b>
     * </p>
     *
     * @param staffedEmployee
     *            Staffed Employee ID
     */
    public void setStaffedEmployee( @Nullable final String staffedEmployee )
    {
        rememberChangedField("StaffedEmployee", this.staffedEmployee);
        this.staffedEmployee = staffedEmployee;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Confirmed</b>
     * </p>
     *
     * @param confirmed
     *            Resource is Confirmed
     */
    public void setConfirmed( @Nullable final String confirmed )
    {
        rememberChangedField("Confirmed", this.confirmed);
        this.confirmed = confirmed;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemId</b>
     * </p>
     *
     * @param workitemId
     *            Work Item ID
     */
    public void setWorkitemId( @Nullable final String workitemId )
    {
        rememberChangedField("WorkitemId", this.workitemId);
        this.workitemId = workitemId;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>WorkitemName</b>
     * </p>
     *
     * @param workitemName
     *            Work Item Desc.
     */
    public void setWorkitemName( @Nullable final String workitemName )
    {
        rememberChangedField("WorkitemName", this.workitemName);
        this.workitemName = workitemName;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEffort</b>
     * </p>
     *
     * @param staffedEffort
     *            Staffed Efforts
     */
    public void setStaffedEffort( @Nullable final BigDecimal staffedEffort )
    {
        rememberChangedField("StaffedEffort", this.staffedEffort);
        this.staffedEffort = staffedEffort;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmpDelvryServOrg</b>
     * </p>
     *
     * @param staffedEmpDelvryServOrg
     *            Service Org.
     */
    public void setStaffedEmpDelvryServOrg( @Nullable final String staffedEmpDelvryServOrg )
    {
        rememberChangedField("StaffedEmpDelvryServOrg", this.staffedEmpDelvryServOrg);
        this.staffedEmpDelvryServOrg = staffedEmpDelvryServOrg;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmpDelvryServOrgT</b>
     * </p>
     *
     * @param staffedEmpDelvryServOrgT
     *            Delivery Org. Desc.
     */
    public void setStaffedEmpDelvryServOrgT( @Nullable final String staffedEmpDelvryServOrgT )
    {
        rememberChangedField("StaffedEmpDelvryServOrgT", this.staffedEmpDelvryServOrgT);
        this.staffedEmpDelvryServOrgT = staffedEmpDelvryServOrgT;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StaffedEmployeeName</b>
     * </p>
     *
     * @param staffedEmployeeName
     *            Staffed Employee Name
     */
    public void setStaffedEmployeeName( @Nullable final String staffedEmployeeName )
    {
        rememberChangedField("StaffedEmployeeName", this.staffedEmployeeName);
        this.staffedEmployeeName = staffedEmployeeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "StaffingDataSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectID", getProjectID());
        result.put("WorkPackageID", getWorkPackageID());
        result.put("ResType", getResType());
        result.put("ResourceId", getResourceId());
        result.put("WorkitemId", getWorkitemId());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectID", getProjectID());
        values.put("BillingControlCategory", getBillingControlCategory());
        values.put("WorkPackageID", getWorkPackageID());
        values.put("WPname", getWPname());
        values.put("ResType", getResType());
        values.put("ResTypeText", getResTypeText());
        values.put("ResourceId", getResourceId());
        values.put("ResourceText", getResourceText());
        values.put("Uom", getUom());
        values.put("Version", getVersion());
        values.put("Period", getPeriod());
        values.put("FcYear", getFcYear());
        values.put("StaffedEmployee", getStaffedEmployee());
        values.put("Confirmed", getConfirmed());
        values.put("WorkitemId", getWorkitemId());
        values.put("WorkitemName", getWorkitemName());
        values.put("StaffedEffort", getStaffedEffort());
        values.put("StaffedEmpDelvryServOrg", getStaffedEmpDelvryServOrg());
        values.put("StaffedEmpDelvryServOrgT", getStaffedEmpDelvryServOrgT());
        values.put("StaffedEmployeeName", getStaffedEmployeeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("BillingControlCategory") ) {
                final Object value = values.remove("BillingControlCategory");
                if( (value == null) || (!value.equals(getBillingControlCategory())) ) {
                    setBillingControlCategory(((String) value));
                }
            }
            if( values.containsKey("WorkPackageID") ) {
                final Object value = values.remove("WorkPackageID");
                if( (value == null) || (!value.equals(getWorkPackageID())) ) {
                    setWorkPackageID(((String) value));
                }
            }
            if( values.containsKey("WPname") ) {
                final Object value = values.remove("WPname");
                if( (value == null) || (!value.equals(getWPname())) ) {
                    setWPname(((String) value));
                }
            }
            if( values.containsKey("ResType") ) {
                final Object value = values.remove("ResType");
                if( (value == null) || (!value.equals(getResType())) ) {
                    setResType(((String) value));
                }
            }
            if( values.containsKey("ResTypeText") ) {
                final Object value = values.remove("ResTypeText");
                if( (value == null) || (!value.equals(getResTypeText())) ) {
                    setResTypeText(((String) value));
                }
            }
            if( values.containsKey("ResourceId") ) {
                final Object value = values.remove("ResourceId");
                if( (value == null) || (!value.equals(getResourceId())) ) {
                    setResourceId(((String) value));
                }
            }
            if( values.containsKey("ResourceText") ) {
                final Object value = values.remove("ResourceText");
                if( (value == null) || (!value.equals(getResourceText())) ) {
                    setResourceText(((String) value));
                }
            }
            if( values.containsKey("Uom") ) {
                final Object value = values.remove("Uom");
                if( (value == null) || (!value.equals(getUom())) ) {
                    setUom(((String) value));
                }
            }
            if( values.containsKey("Version") ) {
                final Object value = values.remove("Version");
                if( (value == null) || (!value.equals(getVersion())) ) {
                    setVersion(((String) value));
                }
            }
            if( values.containsKey("Period") ) {
                final Object value = values.remove("Period");
                if( (value == null) || (!value.equals(getPeriod())) ) {
                    setPeriod(((String) value));
                }
            }
            if( values.containsKey("FcYear") ) {
                final Object value = values.remove("FcYear");
                if( (value == null) || (!value.equals(getFcYear())) ) {
                    setFcYear(((String) value));
                }
            }
            if( values.containsKey("StaffedEmployee") ) {
                final Object value = values.remove("StaffedEmployee");
                if( (value == null) || (!value.equals(getStaffedEmployee())) ) {
                    setStaffedEmployee(((String) value));
                }
            }
            if( values.containsKey("Confirmed") ) {
                final Object value = values.remove("Confirmed");
                if( (value == null) || (!value.equals(getConfirmed())) ) {
                    setConfirmed(((String) value));
                }
            }
            if( values.containsKey("WorkitemId") ) {
                final Object value = values.remove("WorkitemId");
                if( (value == null) || (!value.equals(getWorkitemId())) ) {
                    setWorkitemId(((String) value));
                }
            }
            if( values.containsKey("WorkitemName") ) {
                final Object value = values.remove("WorkitemName");
                if( (value == null) || (!value.equals(getWorkitemName())) ) {
                    setWorkitemName(((String) value));
                }
            }
            if( values.containsKey("StaffedEffort") ) {
                final Object value = values.remove("StaffedEffort");
                if( (value == null) || (!value.equals(getStaffedEffort())) ) {
                    setStaffedEffort(((BigDecimal) value));
                }
            }
            if( values.containsKey("StaffedEmpDelvryServOrg") ) {
                final Object value = values.remove("StaffedEmpDelvryServOrg");
                if( (value == null) || (!value.equals(getStaffedEmpDelvryServOrg())) ) {
                    setStaffedEmpDelvryServOrg(((String) value));
                }
            }
            if( values.containsKey("StaffedEmpDelvryServOrgT") ) {
                final Object value = values.remove("StaffedEmpDelvryServOrgT");
                if( (value == null) || (!value.equals(getStaffedEmpDelvryServOrgT())) ) {
                    setStaffedEmpDelvryServOrgT(((String) value));
                }
            }
            if( values.containsKey("StaffedEmployeeName") ) {
                final Object value = values.remove("StaffedEmployeeName");
                if( (value == null) || (!value.equals(getStaffedEmployeeName())) ) {
                    setStaffedEmployeeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> StaffingDataField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new StaffingDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> StaffingDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new StaffingDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService.DEFAULT_SERVICE_PATH);
    }

}
