/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.WorkItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.WorkItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Work Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WorkItem</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkItem extends VdmEntity<WorkItem>
{

    /**
     * Selector for all available fields of WorkItem.
     *
     */
    public final static WorkItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Workitem</b>
     * </p>
     *
     * @return Work Item ID
     */
    @Key
    @SerializedName( "Workitem" )
    @JsonProperty( "Workitem" )
    @Nullable
    @ODataField( odataName = "Workitem" )
    private String workitem;
    /**
     * Use with available fluent helpers to apply the <b>Workitem</b> field to query operations.
     *
     */
    public final static WorkItemField<String> WORKITEM = new WorkItemField<String>("Workitem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkpackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkpackageID" )
    @JsonProperty( "WorkpackageID" )
    @Nullable
    @ODataField( odataName = "WorkpackageID" )
    private String workpackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkpackageID</b> field to query operations.
     *
     */
    public final static WorkItemField<String> WORKPACKAGE_ID = new WorkItemField<String>("WorkpackageID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Workitemname</b>
     * </p>
     *
     * @return Work Item Desc.
     */
    @SerializedName( "Workitemname" )
    @JsonProperty( "Workitemname" )
    @Nullable
    @ODataField( odataName = "Workitemname" )
    private String workitemname;
    /**
     * Use with available fluent helpers to apply the <b>Workitemname</b> field to query operations.
     *
     */
    public final static WorkItemField<String> WORKITEMNAME = new WorkItemField<String>("Workitemname");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Workitemisinactive</b>
     * </p>
     *
     * @return Work Item is Inactive
     */
    @SerializedName( "Workitemisinactive" )
    @JsonProperty( "Workitemisinactive" )
    @Nullable
    @ODataField( odataName = "Workitemisinactive" )
    private String workitemisinactive;
    /**
     * Use with available fluent helpers to apply the <b>Workitemisinactive</b> field to query operations.
     *
     */
    public final static WorkItemField<String> WORKITEMISINACTIVE = new WorkItemField<String>("Workitemisinactive");

    @Nonnull
    @Override
    public Class<WorkItem> getType()
    {
        return WorkItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Workitem</b>
     * </p>
     *
     * @param workitem
     *            Work Item ID
     */
    public void setWorkitem( @Nullable final String workitem )
    {
        rememberChangedField("Workitem", this.workitem);
        this.workitem = workitem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkpackageID</b>
     * </p>
     *
     * @param workpackageID
     *            Work Package ID
     */
    public void setWorkpackageID( @Nullable final String workpackageID )
    {
        rememberChangedField("WorkpackageID", this.workpackageID);
        this.workpackageID = workpackageID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Workitemname</b>
     * </p>
     *
     * @param workitemname
     *            Work Item Desc.
     */
    public void setWorkitemname( @Nullable final String workitemname )
    {
        rememberChangedField("Workitemname", this.workitemname);
        this.workitemname = workitemname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Workitemisinactive</b>
     * </p>
     *
     * @param workitemisinactive
     *            Work Item is Inactive
     */
    public void setWorkitemisinactive( @Nullable final String workitemisinactive )
    {
        rememberChangedField("Workitemisinactive", this.workitemisinactive);
        this.workitemisinactive = workitemisinactive;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WorkItemSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Workitem", getWorkitem());
        result.put("WorkpackageID", getWorkpackageID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Workitem", getWorkitem());
        values.put("WorkpackageID", getWorkpackageID());
        values.put("Workitemname", getWorkitemname());
        values.put("Workitemisinactive", getWorkitemisinactive());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Workitem") ) {
                final Object value = values.remove("Workitem");
                if( (value == null) || (!value.equals(getWorkitem())) ) {
                    setWorkitem(((String) value));
                }
            }
            if( values.containsKey("WorkpackageID") ) {
                final Object value = values.remove("WorkpackageID");
                if( (value == null) || (!value.equals(getWorkpackageID())) ) {
                    setWorkpackageID(((String) value));
                }
            }
            if( values.containsKey("Workitemname") ) {
                final Object value = values.remove("Workitemname");
                if( (value == null) || (!value.equals(getWorkitemname())) ) {
                    setWorkitemname(((String) value));
                }
            }
            if( values.containsKey("Workitemisinactive") ) {
                final Object value = values.remove("Workitemisinactive");
                if( (value == null) || (!value.equals(getWorkitemisinactive())) ) {
                    setWorkitemisinactive(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService.DEFAULT_SERVICE_PATH);
    }

}
