/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.WorkPackageFunctionSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunction
 * WorkPackageFunction} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class WorkPackageFunctionByKeyFluentHelper
    extends
    FluentHelperByKey<WorkPackageFunctionByKeyFluentHelper, WorkPackageFunction, WorkPackageFunctionSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.WorkPackageFunction
     * WorkPackageFunction} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkPackageFunction}
     * @param workPackageID
     *            Work Package ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkPackageFunction}
     * @param workPackageFunctionId
     *            Work Package Function ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param projectID
     *            Project ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     */
    public WorkPackageFunctionByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String projectID,
        final String workPackageID,
        final String workPackageFunctionId )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectID", projectID);
        this.key.put("WorkPackageID", workPackageID);
        this.key.put("WorkPackageFunctionId", workPackageFunctionId);
    }

    @Override
    @Nonnull
    protected Class<WorkPackageFunction> getEntityClass()
    {
        return WorkPackageFunction.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
