/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.field.WorkpackageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.link.WorkpackageLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.selectable.WorkpackageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Work Packages
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Workpackage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Workpackage extends VdmEntity<Workpackage>
{

    /**
     * Selector for all available fields of Workpackage.
     *
     */
    public final static WorkpackageSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageUnitText</b>
     * </p>
     *
     * @return Work Package Unit Text
     */
    @SerializedName( "WorkPackageUnitText" )
    @JsonProperty( "WorkPackageUnitText" )
    @Nullable
    @ODataField( odataName = "WorkPackageUnitText" )
    private String workPackageUnitText;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageUnitText</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> WORK_PACKAGE_UNIT_TEXT =
        new WorkpackageField<String>("WorkPackageUnitText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageType</b>
     * </p>
     *
     * @return Work Package Type
     */
    @SerializedName( "WorkPackageType" )
    @JsonProperty( "WorkPackageType" )
    @Nullable
    @ODataField( odataName = "WorkPackageType" )
    private String workPackageType;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageType</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> WORK_PACKAGE_TYPE = new WorkpackageField<String>("WorkPackageType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Unit Of Measure
     */
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> UNIT_OF_MEASURE = new WorkpackageField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private String quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> QUANTITY = new WorkpackageField<String>("Quantity");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @return Changed on
     */
    @SerializedName( "ChangedOn" )
    @JsonProperty( "ChangedOn" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedOn",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedOn;
    /**
     * Use with available fluent helpers to apply the <b>ChangedOn</b> field to query operations.
     *
     */
    public final static WorkpackageField<ZonedDateTime> CHANGED_ON = new WorkpackageField<ZonedDateTime>("ChangedOn");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @return Project ID
     */
    @SerializedName( "ProjectID" )
    @JsonProperty( "ProjectID" )
    @Nullable
    @ODataField( odataName = "ProjectID" )
    private String projectID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectID</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> PROJECT_ID = new WorkpackageField<String>("ProjectID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangedBy</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "ChangedBy" )
    @JsonProperty( "ChangedBy" )
    @Nullable
    @ODataField( odataName = "ChangedBy" )
    private String changedBy;
    /**
     * Use with available fluent helpers to apply the <b>ChangedBy</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> CHANGED_BY = new WorkpackageField<String>("ChangedBy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @return Work Package ID
     */
    @Key
    @SerializedName( "WorkPackageID" )
    @JsonProperty( "WorkPackageID" )
    @Nullable
    @ODataField( odataName = "WorkPackageID" )
    private String workPackageID;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageID</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> WORK_PACKAGE_ID = new WorkpackageField<String>("WorkPackageID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @return Work Package Name
     */
    @SerializedName( "WorkPackageName" )
    @JsonProperty( "WorkPackageName" )
    @Nullable
    @ODataField( odataName = "WorkPackageName" )
    private String workPackageName;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageName</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> WORK_PACKAGE_NAME = new WorkpackageField<String>("WorkPackageName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPStartDate</b>
     * </p>
     *
     * @return Work Package Start Date
     */
    @SerializedName( "WPStartDate" )
    @JsonProperty( "WPStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WPStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime wPStartDate;
    /**
     * Use with available fluent helpers to apply the <b>WPStartDate</b> field to query operations.
     *
     */
    public final static WorkpackageField<LocalDateTime> WP_START_DATE =
        new WorkpackageField<LocalDateTime>("WPStartDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPEndDate</b>
     * </p>
     *
     * @return Work Package EndDate
     */
    @SerializedName( "WPEndDate" )
    @JsonProperty( "WPEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "WPEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime wPEndDate;
    /**
     * Use with available fluent helpers to apply the <b>WPEndDate</b> field to query operations.
     *
     */
    public final static WorkpackageField<LocalDateTime> WP_END_DATE = new WorkpackageField<LocalDateTime>("WPEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectName</b>
     * </p>
     *
     * @return Project Name
     */
    @SerializedName( "ProjectName" )
    @JsonProperty( "ProjectName" )
    @Nullable
    @ODataField( odataName = "ProjectName" )
    private String projectName;
    /**
     * Use with available fluent helpers to apply the <b>ProjectName</b> field to query operations.
     *
     */
    public final static WorkpackageField<String> PROJECT_NAME = new WorkpackageField<String>("ProjectName");
    /**
     * Navigation property <b>WorkPackageFunctionSet</b> for <b>Workpackage</b> to multiple <b>WorkPackageFunction</b>.
     *
     */
    @SerializedName( "WorkPackageFunctionSet" )
    @JsonProperty( "WorkPackageFunctionSet" )
    @ODataField( odataName = "WorkPackageFunctionSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkPackageFunction> toWorkPackageFunctionSet;
    /**
     * Navigation property <b>WorkItemSet</b> for <b>Workpackage</b> to multiple <b>WorkItem</b>.
     *
     */
    @SerializedName( "WorkItemSet" )
    @JsonProperty( "WorkItemSet" )
    @ODataField( odataName = "WorkItemSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkItem> toWorkItemSet;
    /**
     * Navigation property <b>PlanDataSet</b> for <b>Workpackage</b> to multiple <b>PlanData</b>.
     *
     */
    @SerializedName( "PlanDataSet" )
    @JsonProperty( "PlanDataSet" )
    @ODataField( odataName = "PlanDataSet" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PlanData> toPlanDataSet;
    /**
     * Use with available fluent helpers to apply the <b>WorkPackageFunctionSet</b> navigation property to query
     * operations.
     *
     */
    public final static WorkpackageLink<WorkPackageFunction> TO_WORK_PACKAGE_FUNCTION_SET =
        new WorkpackageLink<WorkPackageFunction>("WorkPackageFunctionSet");
    /**
     * Use with available fluent helpers to apply the <b>WorkItemSet</b> navigation property to query operations.
     *
     */
    public final static WorkpackageLink<WorkItem> TO_WORK_ITEM_SET = new WorkpackageLink<WorkItem>("WorkItemSet");
    /**
     * Use with available fluent helpers to apply the <b>PlanDataSet</b> navigation property to query operations.
     *
     */
    public final static WorkpackageLink<PlanData> TO_PLAN_DATA_SET = new WorkpackageLink<PlanData>("PlanDataSet");

    @Nonnull
    @Override
    public Class<Workpackage> getType()
    {
        return Workpackage.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageUnitText</b>
     * </p>
     *
     * @param workPackageUnitText
     *            Work Package Unit Text
     */
    public void setWorkPackageUnitText( @Nullable final String workPackageUnitText )
    {
        rememberChangedField("WorkPackageUnitText", this.workPackageUnitText);
        this.workPackageUnitText = workPackageUnitText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageType</b>
     * </p>
     *
     * @param workPackageType
     *            Work Package Type
     */
    public void setWorkPackageType( @Nullable final String workPackageType )
    {
        rememberChangedField("WorkPackageType", this.workPackageType);
        this.workPackageType = workPackageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Unit Of Measure
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Quantity
     */
    public void setQuantity( @Nullable final String quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ChangedOn</b>
     * </p>
     *
     * @param changedOn
     *            Changed on
     */
    public void setChangedOn( @Nullable final ZonedDateTime changedOn )
    {
        rememberChangedField("ChangedOn", this.changedOn);
        this.changedOn = changedOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectID</b>
     * </p>
     *
     * @param projectID
     *            Project ID
     */
    public void setProjectID( @Nullable final String projectID )
    {
        rememberChangedField("ProjectID", this.projectID);
        this.projectID = projectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangedBy</b>
     * </p>
     *
     * @param changedBy
     *            Changed By
     */
    public void setChangedBy( @Nullable final String changedBy )
    {
        rememberChangedField("ChangedBy", this.changedBy);
        this.changedBy = changedBy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageID</b>
     * </p>
     *
     * @param workPackageID
     *            Work Package ID
     */
    public void setWorkPackageID( @Nullable final String workPackageID )
    {
        rememberChangedField("WorkPackageID", this.workPackageID);
        this.workPackageID = workPackageID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WorkPackageName</b>
     * </p>
     *
     * @param workPackageName
     *            Work Package Name
     */
    public void setWorkPackageName( @Nullable final String workPackageName )
    {
        rememberChangedField("WorkPackageName", this.workPackageName);
        this.workPackageName = workPackageName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPStartDate</b>
     * </p>
     *
     * @param wPStartDate
     *            Work Package Start Date
     */
    public void setWPStartDate( @Nullable final LocalDateTime wPStartDate )
    {
        rememberChangedField("WPStartDate", this.wPStartDate);
        this.wPStartDate = wPStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WPEndDate</b>
     * </p>
     *
     * @param wPEndDate
     *            Work Package EndDate
     */
    public void setWPEndDate( @Nullable final LocalDateTime wPEndDate )
    {
        rememberChangedField("WPEndDate", this.wPEndDate);
        this.wPEndDate = wPEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectName</b>
     * </p>
     *
     * @param projectName
     *            Project Name
     */
    public void setProjectName( @Nullable final String projectName )
    {
        rememberChangedField("ProjectName", this.projectName);
        this.projectName = projectName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WorkpackageSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkPackageID", getWorkPackageID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkPackageUnitText", getWorkPackageUnitText());
        values.put("WorkPackageType", getWorkPackageType());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("Quantity", getQuantity());
        values.put("ChangedOn", getChangedOn());
        values.put("ProjectID", getProjectID());
        values.put("ChangedBy", getChangedBy());
        values.put("WorkPackageID", getWorkPackageID());
        values.put("WorkPackageName", getWorkPackageName());
        values.put("WPStartDate", getWPStartDate());
        values.put("WPEndDate", getWPEndDate());
        values.put("ProjectName", getProjectName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkPackageUnitText") ) {
                final Object value = values.remove("WorkPackageUnitText");
                if( (value == null) || (!value.equals(getWorkPackageUnitText())) ) {
                    setWorkPackageUnitText(((String) value));
                }
            }
            if( values.containsKey("WorkPackageType") ) {
                final Object value = values.remove("WorkPackageType");
                if( (value == null) || (!value.equals(getWorkPackageType())) ) {
                    setWorkPackageType(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((String) value));
                }
            }
            if( values.containsKey("ChangedOn") ) {
                final Object value = values.remove("ChangedOn");
                if( (value == null) || (!value.equals(getChangedOn())) ) {
                    setChangedOn(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProjectID") ) {
                final Object value = values.remove("ProjectID");
                if( (value == null) || (!value.equals(getProjectID())) ) {
                    setProjectID(((String) value));
                }
            }
            if( values.containsKey("ChangedBy") ) {
                final Object value = values.remove("ChangedBy");
                if( (value == null) || (!value.equals(getChangedBy())) ) {
                    setChangedBy(((String) value));
                }
            }
            if( values.containsKey("WorkPackageID") ) {
                final Object value = values.remove("WorkPackageID");
                if( (value == null) || (!value.equals(getWorkPackageID())) ) {
                    setWorkPackageID(((String) value));
                }
            }
            if( values.containsKey("WorkPackageName") ) {
                final Object value = values.remove("WorkPackageName");
                if( (value == null) || (!value.equals(getWorkPackageName())) ) {
                    setWorkPackageName(((String) value));
                }
            }
            if( values.containsKey("WPStartDate") ) {
                final Object value = values.remove("WPStartDate");
                if( (value == null) || (!value.equals(getWPStartDate())) ) {
                    setWPStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WPEndDate") ) {
                final Object value = values.remove("WPEndDate");
                if( (value == null) || (!value.equals(getWPEndDate())) ) {
                    setWPEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectName") ) {
                final Object value = values.remove("ProjectName");
                if( (value == null) || (!value.equals(getProjectName())) ) {
                    setProjectName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("WorkPackageFunctionSet") ) {
                final Object value = (values).remove("WorkPackageFunctionSet");
                if( value instanceof Iterable ) {
                    if( toWorkPackageFunctionSet == null ) {
                        toWorkPackageFunctionSet = Lists.newArrayList();
                    } else {
                        toWorkPackageFunctionSet = Lists.newArrayList(toWorkPackageFunctionSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkPackageFunction entity;
                        if( toWorkPackageFunctionSet.size() > i ) {
                            entity = toWorkPackageFunctionSet.get(i);
                        } else {
                            entity = new WorkPackageFunction();
                            toWorkPackageFunctionSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("WorkItemSet") ) {
                final Object value = (values).remove("WorkItemSet");
                if( value instanceof Iterable ) {
                    if( toWorkItemSet == null ) {
                        toWorkItemSet = Lists.newArrayList();
                    } else {
                        toWorkItemSet = Lists.newArrayList(toWorkItemSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkItem entity;
                        if( toWorkItemSet.size() > i ) {
                            entity = toWorkItemSet.get(i);
                        } else {
                            entity = new WorkItem();
                            toWorkItemSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("PlanDataSet") ) {
                final Object value = (values).remove("PlanDataSet");
                if( value instanceof Iterable ) {
                    if( toPlanDataSet == null ) {
                        toPlanDataSet = Lists.newArrayList();
                    } else {
                        toPlanDataSet = Lists.newArrayList(toPlanDataSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PlanData entity;
                        if( toPlanDataSet.size() > i ) {
                            entity = toPlanDataSet.get(i);
                        } else {
                            entity = new PlanData();
                            toPlanDataSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkpackageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkpackageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkpackageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkpackageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWorkPackageFunctionSet != null ) {
            (values).put("WorkPackageFunctionSet", toWorkPackageFunctionSet);
        }
        if( toWorkItemSet != null ) {
            (values).put("WorkItemSet", toWorkItemSet);
        }
        if( toPlanDataSet != null ) {
            (values).put("PlanDataSet", toPlanDataSet);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkPackageFunction</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkPackageFunction</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkPackageFunction> fetchWorkPackageFunctionSet()
    {
        return fetchFieldAsList("WorkPackageFunctionSet", WorkPackageFunction.class);
    }

    /**
     * Retrieval of associated <b>WorkPackageFunction</b> entities (one to many). This corresponds to the OData
     * navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageFunctionSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkPackageFunction</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkPackageFunction> getWorkPackageFunctionSetOrFetch()
    {
        if( toWorkPackageFunctionSet == null ) {
            toWorkPackageFunctionSet = fetchWorkPackageFunctionSet();
        }
        return toWorkPackageFunctionSet;
    }

    /**
     * Retrieval of associated <b>WorkPackageFunction</b> entities (one to many). This corresponds to the OData
     * navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property for an entity <b>Workpackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>WorkPackageFunctionSet</b> is already loaded, the result
     *         will contain the <b>WorkPackageFunction</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkPackageFunction>> getWorkPackageFunctionSetIfPresent()
    {
        return Option.of(toWorkPackageFunctionSet);
    }

    /**
     * Overwrites the list of associated <b>WorkPackageFunction</b> entities for the loaded navigation property
     * <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageFunctionSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkPackageFunction</b> entities.
     */
    public void setWorkPackageFunctionSet( @Nonnull final List<WorkPackageFunction> value )
    {
        if( toWorkPackageFunctionSet == null ) {
            toWorkPackageFunctionSet = Lists.newArrayList();
        }
        toWorkPackageFunctionSet.clear();
        toWorkPackageFunctionSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkPackageFunction</b> entities. This corresponds to the OData
     * navigation property <b>WorkPackageFunctionSet</b>.
     * <p>
     * If the navigation property <b>WorkPackageFunctionSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkPackageFunction</b> entities.
     */
    public void addWorkPackageFunctionSet( WorkPackageFunction... entity )
    {
        if( toWorkPackageFunctionSet == null ) {
            toWorkPackageFunctionSet = Lists.newArrayList();
        }
        toWorkPackageFunctionSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkItem</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>WorkItemSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkItem</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkItem> fetchWorkItemSet()
    {
        return fetchFieldAsList("WorkItemSet", WorkItem.class);
    }

    /**
     * Retrieval of associated <b>WorkItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>WorkItemSet</b>.
     * <p>
     * If the navigation property <b>WorkItemSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkItem> getWorkItemSetOrFetch()
    {
        if( toWorkItemSet == null ) {
            toWorkItemSet = fetchWorkItemSet();
        }
        return toWorkItemSet;
    }

    /**
     * Retrieval of associated <b>WorkItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>WorkItemSet</b>.
     * <p>
     * If the navigation property for an entity <b>Workpackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>WorkItemSet</b> is already loaded, the result will contain
     *         the <b>WorkItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<WorkItem>> getWorkItemSetIfPresent()
    {
        return Option.of(toWorkItemSet);
    }

    /**
     * Overwrites the list of associated <b>WorkItem</b> entities for the loaded navigation property <b>WorkItemSet</b>.
     * <p>
     * If the navigation property <b>WorkItemSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkItem</b> entities.
     */
    public void setWorkItemSet( @Nonnull final List<WorkItem> value )
    {
        if( toWorkItemSet == null ) {
            toWorkItemSet = Lists.newArrayList();
        }
        toWorkItemSet.clear();
        toWorkItemSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkItem</b> entities. This corresponds to the OData navigation
     * property <b>WorkItemSet</b>.
     * <p>
     * If the navigation property <b>WorkItemSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkItem</b> entities.
     */
    public void addWorkItemSet( WorkItem... entity )
    {
        if( toWorkItemSet == null ) {
            toWorkItemSet = Lists.newArrayList();
        }
        toWorkItemSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PlanData</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>PlanDataSet</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PlanData</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlanData> fetchPlanDataSet()
    {
        return fetchFieldAsList("PlanDataSet", PlanData.class);
    }

    /**
     * Retrieval of associated <b>PlanData</b> entities (one to many). This corresponds to the OData navigation property
     * <b>PlanDataSet</b>.
     * <p>
     * If the navigation property <b>PlanDataSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlanData</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlanData> getPlanDataSetOrFetch()
    {
        if( toPlanDataSet == null ) {
            toPlanDataSet = fetchPlanDataSet();
        }
        return toPlanDataSet;
    }

    /**
     * Retrieval of associated <b>PlanData</b> entities (one to many). This corresponds to the OData navigation property
     * <b>PlanDataSet</b>.
     * <p>
     * If the navigation property for an entity <b>Workpackage</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>PlanDataSet</b> is already loaded, the result will contain
     *         the <b>PlanData</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<PlanData>> getPlanDataSetIfPresent()
    {
        return Option.of(toPlanDataSet);
    }

    /**
     * Overwrites the list of associated <b>PlanData</b> entities for the loaded navigation property <b>PlanDataSet</b>.
     * <p>
     * If the navigation property <b>PlanDataSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PlanData</b> entities.
     */
    public void setPlanDataSet( @Nonnull final List<PlanData> value )
    {
        if( toPlanDataSet == null ) {
            toPlanDataSet = Lists.newArrayList();
        }
        toPlanDataSet.clear();
        toPlanDataSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PlanData</b> entities. This corresponds to the OData navigation
     * property <b>PlanDataSet</b>.
     * <p>
     * If the navigation property <b>PlanDataSet</b> of a queried <b>Workpackage</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PlanData</b> entities.
     */
    public void addPlanDataSet( PlanData... entity )
    {
        if( toPlanDataSet == null ) {
            toPlanDataSet = Lists.newArrayList();
        }
        toPlanDataSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Workpackage instances.
     *
     */
    public final static class WorkpackageBuilder
    {

        private List<WorkPackageFunction> toWorkPackageFunctionSet = Lists.newArrayList();
        private List<WorkItem> toWorkItemSet = Lists.newArrayList();
        private List<PlanData> toPlanDataSet = Lists.newArrayList();

        private Workpackage.WorkpackageBuilder toWorkPackageFunctionSet( final List<WorkPackageFunction> value )
        {
            toWorkPackageFunctionSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>WorkPackageFunctionSet</b> for <b>Workpackage</b> to multiple
         * <b>WorkPackageFunction</b>.
         *
         * @param value
         *            The WorkPackageFunctions to build this Workpackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Workpackage.WorkpackageBuilder workPackageFunctionSet( WorkPackageFunction... value )
        {
            return toWorkPackageFunctionSet(Lists.newArrayList(value));
        }

        private Workpackage.WorkpackageBuilder toWorkItemSet( final List<WorkItem> value )
        {
            toWorkItemSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>WorkItemSet</b> for <b>Workpackage</b> to multiple <b>WorkItem</b>.
         *
         * @param value
         *            The WorkItems to build this Workpackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Workpackage.WorkpackageBuilder workItemSet( WorkItem... value )
        {
            return toWorkItemSet(Lists.newArrayList(value));
        }

        private Workpackage.WorkpackageBuilder toPlanDataSet( final List<PlanData> value )
        {
            toPlanDataSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>PlanDataSet</b> for <b>Workpackage</b> to multiple <b>PlanData</b>.
         *
         * @param value
         *            The PlanDatas to build this Workpackage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Workpackage.WorkpackageBuilder planDataSet( PlanData... value )
        {
            return toPlanDataSet(Lists.newArrayList(value));
        }

    }

}
