/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CommercialProjectDetailServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService
 * CommercialProjectDetailService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCommercialProjectDetailServiceBatch
    extends
    BatchFluentHelperBasic<CommercialProjectDetailServiceBatch, CommercialProjectDetailServiceBatchChangeSet>
    implements
    CommercialProjectDetailServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCommercialProjectDetailServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCommercialProjectDetailServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCommercialProjectDetailServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCommercialProjectDetailServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCommercialProjectDetailServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CommercialProjectDetailServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCommercialProjectDetailServiceBatchChangeSet(this, service);
    }

}
