/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.commercialprojectdetail.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CommercialProjectDetailServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService
 * CommercialProjectDetailService}.
 *
 */
public class DefaultCommercialProjectDetailServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CommercialProjectDetailServiceBatch, CommercialProjectDetailServiceBatchChangeSet>
    implements
    CommercialProjectDetailServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService service;

    @SuppressWarnings( "deprecation" )
    DefaultCommercialProjectDetailServiceBatchChangeSet(
        @Nonnull final DefaultCommercialProjectDetailServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CommercialProjectDetailService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCommercialProjectDetailServiceBatchChangeSet getThis()
    {
        return this;
    }

}
